/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.circuits.timing;

import net.minecraft.nbt.NBTTagCompound;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetLogicCircuit;

public class Multipulse
implements IRedNetLogicCircuit {
    private static final String[] _inputPinNames = new String[]{"I", "CLK", "CNT", "THi", "TLo"};
    private int _pulsesCompleted;
    private int _ticksCompleted;
    private boolean _isActive;
    private boolean _lastClockState;

    @Override
    public int getInputCount() {
        return 5;
    }

    @Override
    public int getOutputCount() {
        return 2;
    }

    @Override
    public int[] recalculateOutputValues(long l, int[] nArray) {
        boolean bl = false;
        int n = 0;
        if (!this._lastClockState && nArray[1] != 0) {
            this._pulsesCompleted = 0;
            this._ticksCompleted = 0;
            this._isActive = true;
        }
        if (this._pulsesCompleted < nArray[2]) {
            if (this._isActive) {
                n = nArray[0];
                if (this._ticksCompleted >= nArray[3]) {
                    this._isActive = false;
                    this._ticksCompleted = 0;
                    ++this._pulsesCompleted;
                } else {
                    ++this._ticksCompleted;
                }
            } else if (this._ticksCompleted >= nArray[4]) {
                this._isActive = true;
                this._ticksCompleted = 0;
            } else {
                ++this._ticksCompleted;
            }
        } else {
            bl = true;
        }
        this._lastClockState = nArray[1] > 0;
        return new int[]{n, bl ? 15 : 0};
    }

    @Override
    public String getUnlocalizedName() {
        return "circuit.mfr.multipulse";
    }

    @Override
    public String getInputPinLabel(int n) {
        return _inputPinNames[n];
    }

    @Override
    public String getOutputPinLabel(int n) {
        return n == 0 ? "Q" : "DN";
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        this._pulsesCompleted = nBTTagCompound.func_74762_e("pulsesCompleted");
        this._ticksCompleted = nBTTagCompound.func_74762_e("ticksCompleted");
        this._isActive = nBTTagCompound.func_74767_n("isActive");
        this._lastClockState = nBTTagCompound.func_74767_n("lastClockState");
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74768_a("pulsesCompleted", this._pulsesCompleted);
        nBTTagCompound.func_74768_a("ticksCompleted", this._ticksCompleted);
        nBTTagCompound.func_74757_a("isActive", this._isActive);
        nBTTagCompound.func_74757_a("lastClockState", this._lastClockState);
    }
}

