/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.base;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.net.PacketWrapper;
import powercrystals.core.position.IRotateableTile;
import powercrystals.minefactoryreloaded.MineFactoryReloadedClient;
import powercrystals.minefactoryreloaded.core.HarvestAreaManager;
import powercrystals.minefactoryreloaded.core.IHarvestAreaContainer;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryInventory;
import powercrystals.minefactoryreloaded.setup.Machine;

public abstract class TileEntityFactory
extends TileEntity
implements IRotateableTile,
IPipeConnection,
IHarvestAreaContainer {
    private static final int[][] _textureSelection = new int[][]{{0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 5}, {0, 1, 3, 2, 5, 4}, {0, 1, 5, 4, 2, 3}, {0, 1, 4, 5, 3, 2}};
    private ForgeDirection _forwardDirection;
    private boolean _canRotate = false;
    private boolean _isActive = false;
    private boolean _prevActive;
    private long _lastActive;
    private boolean _manageFluids = false;
    private boolean _manageSolids = false;
    protected int _rednetState;
    protected HarvestAreaManager _areaManager;
    protected Machine _machine;
    protected String _owner = "";
    private static final int HASH_A = 1664525;
    private static final int HASH_C = 1013904223;

    protected TileEntityFactory(Machine machine) {
        this._machine = machine;
        this._forwardDirection = ForgeDirection.NORTH;
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (this.field_70331_k.field_72995_K && this.hasHAM()) {
            MineFactoryReloadedClient.addTileToAreaList(this);
        }
    }

    public void func_70313_j() {
        super.func_70313_j();
        this.onChunkUnload();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.field_70331_k.field_72995_K && this.hasHAM()) {
            MineFactoryReloadedClient.removeTileFromAreaList(this);
        }
    }

    @Override
    public boolean hasHAM() {
        return this.getHAM() != null;
    }

    @Override
    public HarvestAreaManager getHAM() {
        return this._areaManager;
    }

    public World getWorld() {
        return this.field_70331_k;
    }

    public ForgeDirection getDirectionFacing() {
        return this._forwardDirection;
    }

    public boolean canRotate() {
        return this._canRotate;
    }

    public void setCanRotate(boolean bl) {
        this._canRotate = bl;
    }

    public void rotate() {
        this.rotate(false);
    }

    public void rotate(boolean bl) {
        if (this.field_70331_k != null && !this.field_70331_k.field_72995_K) {
            switch (bl ? this._forwardDirection.getOpposite() : this._forwardDirection) {
                case NORTH: {
                    this._forwardDirection = ForgeDirection.EAST;
                    break;
                }
                case EAST: {
                    this._forwardDirection = ForgeDirection.SOUTH;
                    break;
                }
                case SOUTH: {
                    this._forwardDirection = ForgeDirection.WEST;
                    break;
                }
                case WEST: {
                    this._forwardDirection = ForgeDirection.NORTH;
                    break;
                }
                default: {
                    this._forwardDirection = ForgeDirection.NORTH;
                }
            }
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)50.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)this.func_70319_e());
        }
    }

    public void rotateDirectlyTo(int n) {
        this._forwardDirection = ForgeDirection.getOrientation((int)n);
        if (this.field_70331_k != null) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public int getRotatedSide(int n) {
        return _textureSelection[this._forwardDirection.ordinal()][n];
    }

    public ForgeDirection getDropDirection() {
        if (this.canRotate()) {
            return this.getDirectionFacing().getOpposite();
        }
        return ForgeDirection.UP;
    }

    public ForgeDirection[] getDropDirections() {
        return ForgeDirection.VALID_DIRECTIONS;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public void setIsActive(boolean bl) {
        if (this._isActive != bl & this.field_70331_k != null && !this.field_70331_k.field_72995_K && this._lastActive < this.field_70331_k.func_82737_E()) {
            this._lastActive = this.field_70331_k.func_82737_E() + 101L;
            this._prevActive = this._isActive;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)50.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)this.func_70319_e());
        }
        this._isActive = bl;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && this._prevActive != this._isActive && this._lastActive < this.field_70331_k.func_82737_E()) {
            this._prevActive = this._isActive;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)50.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)this.func_70319_e());
        }
    }

    public void setOwner(String string) {
        if (string == null) {
            string = "";
        }
        if (this._owner == null || this._owner.isEmpty()) {
            this._owner = string;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return null;
    }

    public ContainerFactoryInventory getContainer(InventoryPlayer inventoryPlayer) {
        return null;
    }

    public String getGuiBackground() {
        if (this._machine == null) {
            return null;
        }
        return this._machine.getName().toLowerCase() + ".png";
    }

    public void func_70296_d() {
        Packet packet;
        if (this.field_70331_k != null && !this.field_70331_k.field_72995_K && this.hasHAM() && (packet = this.getHAM().getUpgradePacket(this)) != null) {
            PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)50.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)packet);
        }
        super.func_70296_d();
    }

    public Packet func_70319_e() {
        Object[] objectArray = new Object[]{this.field_70329_l, this.field_70330_m, this.field_70327_n, this._forwardDirection.ordinal(), this._isActive};
        return PacketWrapper.createPacket((String)"MFReloaded", (int)1, (Object[])objectArray);
    }

    public void onNeighborTileChange(int n, int n2, int n3) {
    }

    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        int n = nBTTagCompound.func_74762_e("rotation");
        this.rotateDirectlyTo(n);
        this._owner = nBTTagCompound.func_74779_i("owner");
    }

    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("rotation", this.getDirectionFacing().ordinal());
        if (this._owner != null) {
            nBTTagCompound.func_74778_a("owner", this._owner);
        }
    }

    public void onRedNetChanged(ForgeDirection forgeDirection, int n) {
        this._rednetState = n;
    }

    public int getRedNetOutput(ForgeDirection forgeDirection) {
        return 0;
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType pipeType, ForgeDirection forgeDirection) {
        switch (pipeType) {
            case FLUID: {
                return this.manageFluids() ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
            }
            case ITEM: {
                return this.manageSolids() ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
            }
            case STRUCTURE: {
                return IPipeConnection.ConnectOverride.CONNECT;
            }
        }
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }

    public void setManageFluids(boolean bl) {
        this._manageFluids = bl;
    }

    public boolean manageFluids() {
        return this._manageFluids;
    }

    public void setManageSolids(boolean bl) {
        this._manageSolids = bl;
    }

    public boolean manageSolids() {
        return this._manageSolids;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_82115_m() {
        return -1.0;
    }

    public boolean shouldRenderInPass(int n) {
        return n == 0 && this.func_82115_m() != -1.0;
    }

    public int hashCode() {
        int n = 1664525 * (this.field_70329_l ^ 0xBABECAFE) + 1013904223;
        int n2 = 1664525 * (this.field_70327_n ^ 0xDEADBEEF) + 1013904223;
        int n3 = 1664525 * (this.field_70330_m ^ 0xE73AAE09) + 1013904223;
        return n ^ n2 ^ n3;
    }

    public boolean equals(Object object) {
        if (object instanceof TileEntityFactory) {
            TileEntityFactory tileEntityFactory = (TileEntityFactory)object;
            return tileEntityFactory.field_70329_l == this.field_70329_l & tileEntityFactory.field_70330_m == this.field_70330_m & tileEntityFactory.field_70327_n == this.field_70327_n && tileEntityFactory.func_70320_p() == this.func_70320_p() && this.field_70331_k == tileEntityFactory.field_70331_k;
        }
        return false;
    }
}

