/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import powercrystals.core.position.Area;
import powercrystals.core.position.BlockPosition;
import powercrystals.core.random.WeightedRandomItemStack;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryPowered;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntitySludgeBoiler
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private Random _rand;
    private int _tick;

    public TileEntitySludgeBoiler() {
        super(Machine.SludgeBoiler);
        this.setManageSolids(true);
        this._rand = new Random();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiFactoryPowered(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFactoryPowered(this, inventoryPlayer);
    }

    @Override
    public int getWorkMax() {
        return 100;
    }

    @Override
    public int getIdleTicksMax() {
        return 1;
    }

    @Override
    protected boolean activateMachine() {
        if (this.drain(this._tanks[0], 10, false) == 10) {
            ItemStack itemStack;
            this.drain(this._tanks[0], 10, true);
            this.setWorkDone(this.getWorkDone() + 1);
            ++this._tick;
            if (this.getWorkDone() >= this.getWorkMax()) {
                itemStack = ((WeightedRandomItemStack)WeightedRandom.func_76271_a((Random)this._rand, MFRRegistry.getSludgeDrops())).getStack();
                this.doDrop(itemStack);
                this.setWorkDone(0);
            }
            if (this._tick >= 23) {
                itemStack = new Area(new BlockPosition((TileEntity)this), 3, 3, 3);
                List list = this.field_70331_k.func_72872_a(EntityLivingBase.class, itemStack.toAxisAlignedBB());
                for (Object e : list) {
                    if (e instanceof EntityPlayer) {
                        ((EntityPlayer)e).func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 400, 0));
                    }
                    if (!(e instanceof EntityPlayer)) continue;
                    ((EntityPlayer)e).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 120, 0));
                }
                this._tick = 0;
            }
            return true;
        }
        return false;
    }

    @Override
    public ForgeDirection getDropDirection() {
        return ForgeDirection.DOWN;
    }

    @Override
    public boolean allowBucketFill() {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack == null || !fluidStack.isFluidEqual(FluidRegistry.getFluidStack((String)"sludge", (int)1))) {
            return 0;
        }
        return this._tanks[0].fill(fluidStack, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return null;
    }

    @Override
    protected FluidTank[] createTanks() {
        return new FluidTank[]{new FluidTank(4000)};
    }

    public int func_70302_i_() {
        return 0;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }
}

