/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.rednet;

import cpw.mods.fml.common.FMLLog;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.bouncycastle.util.Arrays;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.rednet.IConnectableRedNet;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetCable;

public class RedstoneNetwork {
    private static int _nextId = 0;
    private boolean _ignoreUpdates;
    private boolean _mustUpdate;
    private int _id;
    private boolean _invalid;
    private Map<Integer, Set<BlockPosition>> _singleNodes = new HashMap<Integer, Set<BlockPosition>>();
    private Set<BlockPosition> _omniNodes = new LinkedHashSet<BlockPosition>();
    private Set<BlockPosition> _weakNodes = new LinkedHashSet<BlockPosition>();
    private Set<BlockPosition> _cables = new LinkedHashSet<BlockPosition>();
    private int[] _powerLevelOutput = new int[16];
    private BlockPosition[] _powerProviders = new BlockPosition[16];
    private World _world;
    private static boolean log = false;

    public static void log(String string, Object ... objectArray) {
        if (log && string != null) {
            FMLLog.info((String)("RedNet Debug: " + string), (Object[])objectArray);
        }
    }

    public RedstoneNetwork(World world) {
        this._world = world;
        this._id = _nextId++;
        log = MFRConfig.redNetDebug.getBoolean(false);
        for (int i = 0; i < 16; ++i) {
            this._singleNodes.put(i, new LinkedHashSet());
        }
    }

    public void tick() {
        if (this._mustUpdate) {
            this._mustUpdate = false;
            this.updatePowerLevels();
        }
    }

    public void setInvalid() {
        this._invalid = true;
    }

    public boolean isInvalid() {
        return this._invalid;
    }

    public int getPowerLevelOutput(int n) {
        return this._powerLevelOutput[n];
    }

    public boolean isWeakNode(BlockPosition blockPosition) {
        return this._weakNodes.contains(blockPosition);
    }

    public int getId() {
        return this._id;
    }

    public void addOrUpdateNode(BlockPosition blockPosition) {
        int n = this._world.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
        if (n == MineFactoryReloadedCore.rednetCableBlock.field_71990_ca) {
            return;
        }
        if (!this._omniNodes.contains(blockPosition)) {
            RedstoneNetwork.log("Network with ID %d adding omni node %s", this._id, blockPosition.toString());
            this._omniNodes.add(blockPosition);
            this.notifyOmniNode(blockPosition);
        }
        for (int i = 0; i < 16; ++i) {
            int n2 = this.getOmniNodePowerLevel(blockPosition, i);
            if (Math.abs(n2) > Math.abs(this._powerLevelOutput[i])) {
                RedstoneNetwork.log("Network with ID %d:%d has omni node %s as new power provider", this._id, i, blockPosition.toString());
                this._powerLevelOutput[i] = n2;
                this._powerProviders[i] = blockPosition;
                this.notifyNodes(i);
                continue;
            }
            if (!blockPosition.equals((Object)this._powerProviders[i]) || Math.abs(n2) >= Math.abs(this._powerLevelOutput[i])) continue;
            this.updatePowerLevels(i);
        }
    }

    public void addOrUpdateNode(BlockPosition blockPosition, int n, boolean bl) {
        int n2 = this._world.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
        if (n2 == MineFactoryReloadedCore.rednetCableBlock.field_71990_ca) {
            return;
        }
        if (!this._singleNodes.get(n).contains(blockPosition)) {
            this.removeNode(blockPosition);
            RedstoneNetwork.log("Network with ID %d:%d adding node %s", this._id, n, blockPosition.toString());
            this._singleNodes.get(n).add(blockPosition);
            this.notifySingleNode(blockPosition, n);
        }
        if (bl) {
            this._weakNodes.add(blockPosition);
        } else {
            this._weakNodes.remove(blockPosition);
        }
        int n3 = this.getSingleNodePowerLevel(blockPosition);
        RedstoneNetwork.log("Network with ID %d:%d calculated power for node %s as %d", this._id, n, blockPosition.toString(), n3);
        if (Math.abs(n3) > Math.abs(this._powerLevelOutput[n])) {
            RedstoneNetwork.log("Network with ID %d:%d has node %s as new power provider", this._id, n, blockPosition.toString());
            this._powerLevelOutput[n] = n3;
            this._powerProviders[n] = blockPosition;
            this.notifyNodes(n);
        } else if (blockPosition.equals((Object)this._powerProviders[n]) && Math.abs(n3) < Math.abs(this._powerLevelOutput[n])) {
            RedstoneNetwork.log("Network with ID %d:%d removing power provider node, recalculating", this._id, n);
            this.updatePowerLevels(n);
        }
    }

    public void removeNode(BlockPosition blockPosition) {
        int n;
        boolean bl = false;
        boolean bl2 = this._omniNodes.contains(blockPosition);
        if (bl2) {
            this._omniNodes.remove(blockPosition);
        }
        this._weakNodes.remove(blockPosition);
        for (n = 0; n < 16; ++n) {
            if (this._singleNodes.get(n).contains(blockPosition)) {
                bl = true;
                RedstoneNetwork.log("Network with ID %d:%d removing node %s", this._id, n, blockPosition.toString());
                this._singleNodes.get(n).remove(blockPosition);
            }
            if (!blockPosition.equals((Object)this._powerProviders[n])) continue;
            RedstoneNetwork.log("Network with ID %d:%d removing power provider node, recalculating", this._id, n);
            this.updatePowerLevels(n);
        }
        n = this._world.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
        if (bl) {
            if (n == MineFactoryReloadedCore.rednetCableBlock.field_71990_ca) {
                return;
            }
            if (Block.field_71973_m[n] instanceof IConnectableRedNet) {
                ((IConnectableRedNet)Block.field_71973_m[n]).onInputChanged(this._world, blockPosition.x, blockPosition.y, blockPosition.z, blockPosition.orientation.getOpposite(), 0);
            }
        } else if (bl2 && Block.field_71973_m[n] instanceof IConnectableRedNet) {
            ((IConnectableRedNet)Block.field_71973_m[n]).onInputsChanged(this._world, blockPosition.x, blockPosition.y, blockPosition.z, blockPosition.orientation.getOpposite(), new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        }
        this._world.func_72821_m(blockPosition.x, blockPosition.y, blockPosition.z, MineFactoryReloadedCore.rednetCableBlock.field_71990_ca);
        this._world.func_72898_h(blockPosition.x, blockPosition.y, blockPosition.z, MineFactoryReloadedCore.rednetCableBlock.field_71990_ca);
    }

    public void addCable(BlockPosition blockPosition) {
        if (!this._cables.contains(blockPosition)) {
            this._cables.add(blockPosition);
        }
    }

    public void mergeNetwork(RedstoneNetwork redstoneNetwork) {
        if (this._invalid) {
            return;
        }
        RedstoneNetwork.log("Network with ID %d merging with network %d", this._id, redstoneNetwork._id);
        redstoneNetwork.setInvalid();
        for (int i = 0; i < 16; ++i) {
            this._singleNodes.get(i).addAll((Collection<BlockPosition>)redstoneNetwork._singleNodes.get(i));
        }
        this._omniNodes.addAll(redstoneNetwork._omniNodes);
        this._weakNodes.addAll(redstoneNetwork._weakNodes);
        this._mustUpdate |= redstoneNetwork._mustUpdate;
        for (BlockPosition blockPosition : redstoneNetwork._cables) {
            this._cables.add(blockPosition);
            TileEntity tileEntity = blockPosition.getTileEntity(this._world);
            if (!(tileEntity instanceof TileEntityRedNetCable)) continue;
            ((TileEntityRedNetCable)tileEntity).setNetwork(this);
        }
        this.updatePowerLevels();
    }

    public void updatePowerLevels() {
        for (int i = 0; i < 16; ++i) {
            this.updatePowerLevels(i);
        }
    }

    public void updatePowerLevels(int n) {
        int n2;
        int n3 = this._powerLevelOutput[n];
        this._powerLevelOutput[n] = 0;
        this._powerProviders[n] = null;
        RedstoneNetwork.log("Network with ID %d:%d recalculating power levels for %d single nodes and %d omni nodes", this._id, n, this._singleNodes.get(n).size(), this._omniNodes.size());
        for (BlockPosition blockPosition : this._singleNodes.get(n)) {
            if (!this.isNodeLoaded(blockPosition) || Math.abs(n2 = this.getSingleNodePowerLevel(blockPosition)) <= Math.abs(this._powerLevelOutput[n])) continue;
            this._powerLevelOutput[n] = n2;
            this._powerProviders[n] = blockPosition;
        }
        for (BlockPosition blockPosition : this._omniNodes) {
            if (!this.isNodeLoaded(blockPosition) || Math.abs(n2 = this.getOmniNodePowerLevel(blockPosition, n)) <= Math.abs(this._powerLevelOutput[n])) continue;
            this._powerLevelOutput[n] = n2;
            this._powerProviders[n] = blockPosition;
        }
        RedstoneNetwork.log("Network with ID %d:%d recalculated power levels as: output: %d with powering node %s", this._id, n, this._powerLevelOutput[n], this._powerProviders[n]);
        if (this._powerLevelOutput[n] != n3) {
            this.notifyNodes(n);
        }
    }

    private void notifyNodes(int n) {
        if (this._ignoreUpdates) {
            RedstoneNetwork.log("Network asked to notify nodes while ignoring updates (API misuse?)!", new Object[0]);
            this._mustUpdate = true;
            return;
        }
        this._ignoreUpdates = true;
        RedstoneNetwork.log("Network with ID %d:%d notifying %d single nodes and %d omni nodes", this._id, n, this._singleNodes.get(n).size(), this._omniNodes.size());
        for (BlockPosition blockPosition : this._singleNodes.get(n)) {
            RedstoneNetwork.log("Network with ID %d:%d notifying node %s of power state change to %d", this._id, n, blockPosition.toString(), this._powerLevelOutput[n]);
            this.notifySingleNode(blockPosition, n);
        }
        for (BlockPosition blockPosition : this._omniNodes) {
            RedstoneNetwork.log("Network with ID %d:%d notifying omni node %s of power state change to %d", this._id, n, blockPosition.toString(), this._powerLevelOutput[n]);
            this.notifyOmniNode(blockPosition);
        }
        this._ignoreUpdates = false;
    }

    private boolean isNodeLoaded(BlockPosition blockPosition) {
        return this._world.func_72863_F().func_73149_a(blockPosition.x >> 4, blockPosition.z >> 4);
    }

    private void notifySingleNode(BlockPosition blockPosition, int n) {
        if (this.isNodeLoaded(blockPosition)) {
            int n2 = this._world.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
            if (n2 == MineFactoryReloadedCore.rednetCableBlock.field_71990_ca) {
                return;
            }
            if (Block.field_71973_m[n2] instanceof IConnectableRedNet) {
                ((IConnectableRedNet)Block.field_71973_m[n2]).onInputChanged(this._world, blockPosition.x, blockPosition.y, blockPosition.z, blockPosition.orientation.getOpposite(), this._powerLevelOutput[n]);
            } else {
                this._world.func_72821_m(blockPosition.x, blockPosition.y, blockPosition.z, MineFactoryReloadedCore.rednetCableBlock.field_71990_ca);
                this._world.func_72898_h(blockPosition.x, blockPosition.y, blockPosition.z, MineFactoryReloadedCore.rednetCableBlock.field_71990_ca);
            }
        }
    }

    private void notifyOmniNode(BlockPosition blockPosition) {
        int n;
        if (this.isNodeLoaded(blockPosition) && Block.field_71973_m[n = this._world.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z)] instanceof IConnectableRedNet) {
            ((IConnectableRedNet)Block.field_71973_m[n]).onInputsChanged(this._world, blockPosition.x, blockPosition.y, blockPosition.z, blockPosition.orientation.getOpposite(), Arrays.clone((int[])this._powerLevelOutput));
        }
    }

    private int getOmniNodePowerLevel(BlockPosition blockPosition, int n) {
        if (!this.isNodeLoaded(blockPosition)) {
            return 0;
        }
        IConnectableRedNet iConnectableRedNet = (IConnectableRedNet)Block.field_71973_m[this._world.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z)];
        if (iConnectableRedNet != null) {
            return iConnectableRedNet.getOutputValue(this._world, blockPosition.x, blockPosition.y, blockPosition.z, blockPosition.orientation.getOpposite(), n);
        }
        return 0;
    }

    private int getSingleNodePowerLevel(BlockPosition blockPosition) {
        if (!this.isNodeLoaded(blockPosition)) {
            return 0;
        }
        int n = 0;
        int n2 = this._world.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
        if (n2 == Block.field_72075_av.field_71990_ca) {
            n = -1;
        }
        int n3 = 0;
        if (this._weakNodes.contains(blockPosition) || Block.field_71973_m[n2] instanceof IConnectableRedNet) {
            int n4 = this._world.func_72878_l(blockPosition.x, blockPosition.y, blockPosition.z, blockPosition.orientation.ordinal()) + n;
            int n5 = this._world.func_72879_k(blockPosition.x, blockPosition.y, blockPosition.z, blockPosition.orientation.ordinal()) + n;
            n3 = Math.abs(n4) > Math.abs(n5) ? n4 : n5;
        } else {
            n3 = this._world.func_72879_k(blockPosition.x, blockPosition.y, blockPosition.z, blockPosition.orientation.ordinal()) + n;
        }
        if (n == n3) {
            return 0;
        }
        return n3;
    }
}

