/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.ColourModifier;
import codechicken.lib.render.ColourMultiplier;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IVertexModifier;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.UV;
import codechicken.lib.render.UVScale;
import codechicken.lib.render.UVTranslation;
import codechicken.lib.render.Vertex5;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.Arrays;
import java.util.LinkedList;
import mrtjp.projectred.transmission.WirePart;

public class RenderWire {
    public static int[] reorientSide = new int[]{0, 3, 3, 0, 0, 3};
    public static CCModel[] wireModels = new CCModel[4608];
    public static CCModel[] invModels = new CCModel[3];
    private static WireModelGenerator gen_inst = new WireModelGenerator();

    public static int addVerts(CCModel cCModel, Vertex5[] vertex5Array, int n) {
        for (int i = 0; i < vertex5Array.length; ++i) {
            cCModel.verts[n + i] = vertex5Array[i];
        }
        return n + vertex5Array.length;
    }

    public static CCModel finishModel(CCModel cCModel) {
        cCModel.apply((IUVTransformation)new UVScale(0.03125));
        cCModel.shrinkUVs(5.0E-4);
        cCModel.computeNormals();
        cCModel.computeLighting(LightModel.standardLightModel);
        return cCModel;
    }

    public static int modelKey(int n, int n2, int n3) {
        int n4 = n3 & 0xFF;
        int n5 = n3 >> 20 & 0xF;
        n4 |= (n5 ^ n4 & 0xF) << 4;
        n4 &= 0xFFFFFFF0 | n5;
        int n6 = (n3 & 0xF00) >> 8;
        n4 |= n6 << 4 | n6;
        return n4 |= n + n2 * 6 << 8;
    }

    public static int modelKey(WirePart wirePart) {
        return RenderWire.modelKey(wirePart.side(), wirePart.getThickness(), wirePart.connMap());
    }

    public static CCModel getOrGenerateModel(int n) {
        CCModel cCModel = wireModels[n];
        if (cCModel == null) {
            RenderWire.wireModels[n] = cCModel = gen_inst.generateModel(n, false);
        }
        return cCModel;
    }

    public static void render(WirePart wirePart, Vector3 vector3) {
        ColourModifier colourModifier = wirePart.renderHue() == -1 ? ColourModifier.instance : new ColourMultiplier(wirePart.renderHue());
        RenderWire.getOrGenerateModel(RenderWire.modelKey(wirePart)).render((Transformation)new Translation(vector3), (IUVTransformation)new IconTransformation(wirePart.getIcon()), (IVertexModifier)colourModifier);
    }

    public static void renderInv(int n, Transformation transformation, ms ms2) {
        CCModel cCModel = invModels[n];
        if (cCModel == null) {
            RenderWire.invModels[n] = cCModel = gen_inst.generateInvModel(n);
        }
        cCModel.render(transformation, (IUVTransformation)new IconTransformation(ms2));
    }

    public static void renderBreakingOverlay(ms ms2, WirePart wirePart) {
        int n = RenderWire.modelKey(wirePart);
        int n2 = (n >> 8) % 6;
        double d = (double)((n >> 8) / 6 + 1) / 16.0;
        double d2 = d + 0.0625;
        int n3 = n & 0xFF;
        int n4 = (n3 & 0xF0) >> 4 | n3 & 0xF;
        int n5 = WireModelGenerator.countConnections(n4);
        LinkedList<Cuboid6> linkedList = new LinkedList<Cuboid6>();
        linkedList.add(new Cuboid6(0.5 - d, 0.0, 0.5 - d, 0.5 + d, d2, 0.5 + d).apply(Rotation.sideRotations[n2].at(Vector3.center)));
        for (int i = 0; i < 4; ++i) {
            int n6;
            if (n5 == 0) {
                n6 = i % 2 == 1 ? 4 : 0;
            } else if (n5 == 1) {
                n6 = n4 == 1 << (i + 2) % 4 ? 4 : (n4 == 1 << i ? 8 : 0);
            } else {
                int n7 = n6 = (n4 & 1 << i) != 0 ? 8 : 0;
            }
            if (n6 <= 0) continue;
            double d3 = (double)n6 / 16.0;
            linkedList.add(new Cuboid6(0.5 - d, 0.0, 0.5 + d, 0.5 + d, d2, 0.5 + d3).apply(Rotation.sideOrientation((int)n2, (int)i).at(Vector3.center)));
        }
        for (Cuboid6 cuboid6 : linkedList) {
            RenderUtils.renderBlock((Cuboid6)cuboid6, (int)0, (Transformation)new Translation((double)wirePart.x(), (double)wirePart.y(), (double)wirePart.z()), (IUVTransformation)new IconTransformation(ms2), null);
        }
    }

    private static class WireModelGenerator {
        int side;
        int tw;
        int th;
        double w;
        double h;
        int mask;
        int connMask;
        int connCount;
        CCModel model;
        int i = 0;
        boolean inv;
        private static UVT sideReflect = new UVT(Rotation.quarterRotations[2].at(new Vector3(8.0, 0.0, 16.0)));

        private WireModelGenerator() {
        }

        public static int countConnections(int n) {
            int n2 = 0;
            for (int i = 0; i < 4; ++i) {
                if ((n & 1 << i) == 0) continue;
                ++n2;
            }
            return n2;
        }

        public int numFaces() {
            if (this.inv) {
                return 22;
            }
            int n = this.connCount <= 2 ? 2 : this.connCount;
            int n2 = n * 3 + 5;
            for (int i = 0; i < 4; ++i) {
                if ((this.mask >> i & 0x11) != 1) continue;
                ++n2;
            }
            return n2;
        }

        public CCModel generateInvModel(int n) {
            return this.generateModel(RenderWire.modelKey(0, n, 240), true);
        }

        public CCModel generateModel(int n, boolean bl) {
            this.inv = bl;
            this.side = (n >> 8) % 6;
            this.tw = (n >> 8) / 6 + 1;
            this.w = (double)this.tw / 16.0;
            this.th = this.tw + 1;
            this.h = (double)this.th / 16.0;
            this.mask = n & 0xFF;
            this.connMask = (this.mask & 0xF0) >> 4 | this.mask & 0xF;
            this.connCount = WireModelGenerator.countConnections(this.connMask);
            this.model = CCModel.quadModel((int)(this.numFaces() * 4));
            this.i = 0;
            this.generateCenter();
            for (int i = 0; i < 4; ++i) {
                this.generateSide(i);
            }
            this.model.apply(Rotation.sideOrientation((int)this.side, (int)0).at(Vector3.center));
            return RenderWire.finishModel(this.model);
        }

        private void generateSide(int n) {
            int n2 = this.mask >> n & 0x11;
            Vertex5[] vertex5Array = this.inv ? this.generateSideInv(n) : (this.connCount == 0 ? (n % 2 == 1 ? this.generateStub(n) : this.generateFlat(n)) : (this.connCount == 1 ? (this.connMask == 1 << (n + 2) % 4 ? this.generateStub(n) : this.generateSideFromType(n2, n)) : this.generateSideFromType(n2, n)));
            Transformation transformation = Rotation.quarterRotations[n].at(Vector3.center);
            for (Vertex5 vertex5 : vertex5Array) {
                vertex5.apply(transformation);
            }
            this.i = RenderWire.addVerts(this.model, vertex5Array, this.i);
        }

        private Vertex5[] generateSideInv(int n) {
            return this.withBottom(this.generateStraight(n), 4, 4);
        }

        private Vertex5[] generateSideFromType(int n, int n2) {
            if (n == 0) {
                return this.generateFlat(n2);
            }
            if (n == 1) {
                return this.generateCorner(n2);
            }
            if (n == 16) {
                return this.generateStraight(n2);
            }
            return this.generateInternal(n2);
        }

        private Vertex5[] generateFlat(int n) {
            Vertex5[] vertex5Array = new Vertex5[]{new Vertex5(0.5 - this.w, 0.0, 0.5 + this.w, 16.0, (double)(16 + this.tw)), new Vertex5(0.5 + this.w, 0.0, 0.5 + this.w, 16.0, (double)(16 - this.tw)), new Vertex5(0.5 + this.w, this.h, 0.5 + this.w, (double)(16 - this.th), (double)(16 - this.tw)), new Vertex5(0.5 - this.w, this.h, 0.5 + this.w, (double)(16 - this.th), (double)(16 + this.tw))};
            if (Rotation.rotateSide((int)this.side, (int)n) % 2 == 0) {
                UVT uVT = new UVT(Rotation.quarterRotations[2].at(new Vector3(8.0, 0.0, 16.0)));
                for (Vertex5 vertex5 : vertex5Array) {
                    vertex5.apply((IUVTransformation)uVT);
                }
            }
            return vertex5Array;
        }

        private Vertex5[] generateStub(int n) {
            Vertex5[] vertex5Array = this.generateExtension(4);
            for (int i = 0; i < 4; ++i) {
                vertex5Array[i].vec.z -= 0.002;
            }
            this.reflectSide(vertex5Array, n);
            return vertex5Array;
        }

        private Vertex5[] generateStraight(int n) {
            Vertex5[] vertex5Array = this.generateExtension(8);
            this.reflectSide(vertex5Array, n);
            return vertex5Array;
        }

        private Vertex5[] generateCorner(int n) {
            Vertex5[] vertex5Array = this.generateExtension(8 + this.th);
            for (int i = 0; i < 4; ++i) {
                vertex5Array[i].apply((IUVTransformation)new UVTranslation(0.0, (double)(-this.th)));
            }
            vertex5Array = Arrays.copyOf(vertex5Array, 20);
            vertex5Array[16] = new Vertex5(0.5 - this.w, 0.0, 1.0, (double)(8 - this.tw), (double)(24 + 2 * this.th));
            vertex5Array[17] = new Vertex5(0.5 + this.w, 0.0, 1.0, (double)(8 + this.tw), (double)(24 + 2 * this.th));
            vertex5Array[18] = new Vertex5(0.5 + this.w, 0.0, 1.0 + this.h, (double)(8 + this.tw), (double)(24 + this.th));
            vertex5Array[19] = new Vertex5(0.5 - this.w, 0.0, 1.0 + this.h, (double)(8 - this.tw), (double)(24 + this.th));
            this.reflectSide(vertex5Array, n);
            return vertex5Array;
        }

        private Vertex5[] generateInternal(int n) {
            Vertex5[] vertex5Array = this.generateExtension(8);
            vertex5Array[0].uv.set((double)(8 + this.tw), 24.0);
            vertex5Array[1].uv.set((double)(8 - this.tw), 24.0);
            vertex5Array[2].uv.set((double)(8 - this.tw), (double)(24 + this.tw));
            vertex5Array[3].uv.set((double)(8 + this.tw), (double)(24 + this.tw));
            this.reflectSide(vertex5Array, n);
            for (int i = 4; i < 16; ++i) {
                vertex5Array[i].apply((IUVTransformation)new UVTranslation(16.0, 0.0));
            }
            return vertex5Array;
        }

        private Vertex5[] generateExtension(int n) {
            double d = (double)n / 16.0;
            return new Vertex5[]{new Vertex5(0.5 - this.w, 0.0, 0.5 + d, (double)(8 - this.tw), (double)(24 + 2 * this.th)), new Vertex5(0.5 + this.w, 0.0, 0.5 + d, (double)(8 + this.tw), (double)(24 + 2 * this.th)), new Vertex5(0.5 + this.w, this.h, 0.5 + d, (double)(8 + this.tw), (double)(24 + this.th)), new Vertex5(0.5 - this.w, this.h, 0.5 + d, (double)(8 - this.tw), (double)(24 + this.th)), new Vertex5(0.5 - this.w, this.h, 0.5 + d, (double)(8 - this.tw), (double)(16 + n)), new Vertex5(0.5 + this.w, this.h, 0.5 + d, (double)(8 + this.tw), (double)(16 + n)), new Vertex5(0.5 + this.w, this.h, 0.5 + this.w, (double)(8 + this.tw), (double)(16 + this.tw)), new Vertex5(0.5 - this.w, this.h, 0.5 + this.w, (double)(8 - this.tw), (double)(16 + this.tw)), new Vertex5(0.5 - this.w, 0.0, 0.5 + this.w, 0.0, (double)(16 + this.tw)), new Vertex5(0.5 - this.w, 0.0, 0.5 + d, 0.0, (double)(16 + n)), new Vertex5(0.5 - this.w, this.h, 0.5 + d, (double)this.th, (double)(16 + n)), new Vertex5(0.5 - this.w, this.h, 0.5 + this.w, (double)this.th, (double)(16 + this.tw)), new Vertex5(0.5 + this.w, 0.0, 0.5 + d, 16.0, (double)(16 + n)), new Vertex5(0.5 + this.w, 0.0, 0.5 + this.w, 16.0, (double)(16 + this.tw)), new Vertex5(0.5 + this.w, this.h, 0.5 + this.w, (double)(16 - this.th), (double)(16 + this.tw)), new Vertex5(0.5 + this.w, this.h, 0.5 + d, (double)(16 - this.th), (double)(16 + n))};
        }

        private void generateCenter() {
            Object object;
            int n = this.connCount == 0 ? 1 : (this.connCount == 1 ? ((this.connMask & 5) != 0 ? 0 : 1) : (this.connMask == 5 ? 0 : (this.connMask == 10 ? 1 : 2)));
            Vertex5[] vertex5Array = new Vertex5[]{new Vertex5(0.5 - this.w, this.h, 0.5 + this.w, (double)(8 - this.tw), (double)(16 + this.tw)), new Vertex5(0.5 + this.w, this.h, 0.5 + this.w, (double)(8 + this.tw), (double)(16 + this.tw)), new Vertex5(0.5 + this.w, this.h, 0.5 - this.w, (double)(8 + this.tw), (double)(16 - this.tw)), new Vertex5(0.5 - this.w, this.h, 0.5 - this.w, (double)(8 - this.tw), (double)(16 - this.tw))};
            if (n == 0 || n == 1) {
                n = (n + reorientSide[this.side]) % 2;
            }
            int n2 = reorientSide[this.side];
            if (n == 1) {
                n2 += 3;
            }
            if (n2 != 0) {
                object = new UVT(Rotation.quarterRotations[n2 % 4].at(new Vector3(8.0, 0.0, 16.0)));
                for (Vertex5 vertex5 : vertex5Array) {
                    vertex5.apply((IUVTransformation)object);
                }
            }
            if (n == 2) {
                object = new UVTranslation(16.0, 0.0);
                for (Vertex5 vertex5 : vertex5Array) {
                    vertex5.apply((IUVTransformation)object);
                }
            }
            if (this.inv) {
                vertex5Array = this.withBottom(vertex5Array, 0, 4);
            }
            this.i = RenderWire.addVerts(this.model, vertex5Array, this.i);
        }

        private void reflectSide(Vertex5[] vertex5Array, int n) {
            if ((n + reorientSide[this.side]) % 4 >= 2) {
                for (Vertex5 vertex5 : vertex5Array) {
                    vertex5.apply((IUVTransformation)sideReflect);
                }
            }
        }

        private Vertex5[] withBottom(Vertex5[] vertex5Array, int n, int n2) {
            Vertex5[] vertex5Array2 = new Vertex5[vertex5Array.length + n2];
            Transformation transformation = new Rotation(Math.PI, 0.0, 0.0, 1.0).at(new Vector3(0.5, this.h / 2.0, 0.0));
            for (int i = 0; i < n2; ++i) {
                vertex5Array2[i] = vertex5Array[i + n].copy().apply(transformation);
            }
            System.arraycopy(vertex5Array, 0, vertex5Array2, n2, vertex5Array.length);
            return vertex5Array2;
        }
    }

    public static class UVT
    implements IUVTransformation {
        public Transformation t;
        private Vector3 vec = new Vector3();

        public UVT(Transformation transformation) {
            this.t = transformation;
        }

        public void transform(UV uV) {
            this.vec.set(uV.u, 0.0, uV.v).apply(this.t);
            uV.set(this.vec.x, this.vec.z);
        }
    }
}

