/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.fx;

import codechicken.lib.vec.Vector3;
import java.util.Random;
import mrtjp.projectred.core.fx.ParticleLogic;

public final class ParticleLogicOrbitPoint
extends ParticleLogic {
    private Vector3 target;
    private double distance;
    private boolean rotateClockwise;
    private double targetY;
    private double targetDistance;
    private double orbitSpeed;
    private double orbitAngle;
    private double orbitY = -512.0;
    private boolean useCurrentDistance;
    private boolean ignoreYCoord;
    private boolean shrinkingOrbit;
    private double shrinkSpeed = 0.0;
    private double shrinkTargetDistance = 0.0;

    public ParticleLogicOrbitPoint(Vector3 vector3) {
        this.target = vector3.copy();
        this.orbitAngle = this.rand.nextInt(360);
        this.rotateClockwise = this.rand.nextInt(10) < 5;
        this.generateNewTargetY();
        this.targetDistance = 1.0 + this.rand.nextDouble() * 0.5;
    }

    public ParticleLogicOrbitPoint setOrbitY(double d) {
        this.orbitY = d;
        return this;
    }

    public ParticleLogicOrbitPoint setIgnoreYCoordinate(boolean bl) {
        this.ignoreYCoord = bl;
        return this;
    }

    public ParticleLogicOrbitPoint setTargetDistance(double d) {
        this.targetDistance = d;
        this.useCurrentDistance = false;
        return this;
    }

    public ParticleLogicOrbitPoint setUseCurrentDistance() {
        this.useCurrentDistance = true;
        return this;
    }

    public ParticleLogicOrbitPoint setOrbitSpeed(double d) {
        this.orbitSpeed = d;
        return this;
    }

    public ParticleLogicOrbitPoint setShrinkingOrbit(double d, double d2) {
        this.shrinkingOrbit = true;
        this.shrinkSpeed = d;
        this.shrinkTargetDistance = d2;
        return this;
    }

    private void generateNewTargetY() {
        this.targetY = this.target != null ? new Random().nextDouble() * 2.0 : 0.0;
    }

    private void generateNewDistance() {
        this.targetDistance = this.target != null ? new Random().nextDouble() * 2.0 : 0.0;
    }

    public ParticleLogicOrbitPoint setRotateDirection(boolean bl) {
        this.rotateClockwise = bl;
        return this;
    }

    public ParticleLogicOrbitPoint setStartAngle(float f) {
        this.orbitAngle = f;
        return this;
    }

    @Override
    public void doUpdate() {
        double d;
        double d2;
        double d3 = this.particle.v;
        double d4 = this.target.y + this.targetY;
        if (!this.ignoreYCoord && Math.abs(this.particle.v - d4) < 0.1) {
            this.generateNewTargetY();
        }
        if (this.useCurrentDistance) {
            double d5 = this.target.z - this.particle.w;
            double d6 = this.target.x - this.particle.u;
            double d7 = Math.sqrt(d5 * d5 + d6 * d6);
            d2 = this.target.x + Math.cos(this.orbitAngle) * d7;
            d = this.target.z + Math.sin(this.orbitAngle) * d7;
        } else {
            if (this.shrinkingOrbit) {
                if (this.targetDistance <= this.shrinkTargetDistance) {
                    this.shrinkingOrbit = false;
                } else if (this.targetDistance < this.shrinkTargetDistance + this.shrinkSpeed * 10.0) {
                    double d8 = this.targetDistance - this.shrinkTargetDistance;
                    this.targetDistance -= d8 * this.shrinkSpeed;
                } else {
                    this.targetDistance -= this.shrinkSpeed;
                }
            }
            d2 = this.target.x + Math.cos(this.orbitAngle) * this.targetDistance;
            d = this.target.z + Math.sin(this.orbitAngle) * this.targetDistance;
        }
        if (!this.ignoreYCoord) {
            if (this.particle.v < d4) {
                this.particle.v += 0.1;
            } else if (this.particle.v > d4) {
                this.particle.v -= 0.1;
            }
        }
        this.orbitAngle = this.rotateClockwise ? (this.orbitAngle += this.orbitSpeed) : (this.orbitAngle -= this.orbitSpeed);
        if (this.orbitAngle > 360.0) {
            this.orbitAngle -= 360.0;
        } else if (this.orbitAngle < 0.0) {
            this.orbitAngle += 360.0;
        }
        if (this.orbitY != -512.0) {
            d3 = this.target.y + this.orbitY;
        }
        this.particle.b(d2, d3, d);
    }

    @Override
    public ParticleLogic clone() {
        ParticleLogicOrbitPoint particleLogicOrbitPoint = new ParticleLogicOrbitPoint(this.target);
        if (this.useCurrentDistance) {
            particleLogicOrbitPoint.setUseCurrentDistance();
        } else {
            particleLogicOrbitPoint.setTargetDistance(this.targetDistance);
        }
        if (this.orbitY != -512.0) {
            particleLogicOrbitPoint.setOrbitY(this.orbitY);
        }
        particleLogicOrbitPoint.setOrbitSpeed(this.orbitSpeed);
        particleLogicOrbitPoint.setIgnoreYCoordinate(this.ignoreYCoord);
        particleLogicOrbitPoint.setRotateDirection(this.rotateClockwise);
        particleLogicOrbitPoint.setStartAngle((float)this.orbitAngle);
        if (this.shrinkingOrbit) {
            particleLogicOrbitPoint.setShrinkingOrbit(this.shrinkSpeed, this.shrinkTargetDistance);
        }
        return particleLogicOrbitPoint.setFinal(this.finalLogic).setPriority(this.priority);
    }
}

