/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.addon.thaumcraft;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.addon.Addon;
import net.mcft.copy.betterstorage.addon.thaumcraft.TileEntityThaumcraftBackpack;
import net.mcft.copy.betterstorage.addon.thaumcraft.TileEntityThaumiumChest;
import net.mcft.copy.betterstorage.addon.thaumcraft.TileThaumcraftBackpack;
import net.mcft.copy.betterstorage.addon.thaumcraft.TileThaumiumChest;
import net.mcft.copy.betterstorage.client.renderer.ItemRendererBackpack;
import net.mcft.copy.betterstorage.client.renderer.TileEntityReinforcedChestRenderer;
import net.mcft.copy.betterstorage.config.setting.TileIdSetting;
import net.mcft.copy.betterstorage.content.Items;
import net.mcft.copy.betterstorage.content.Tiles;
import net.mcft.copy.betterstorage.proxy.ClientProxy;
import net.mcft.copy.betterstorage.tile.TileBackpack;
import net.mcft.copy.betterstorage.utils.MiscUtils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import thaumcraft.api.ItemApi;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;

public class ThaumcraftAddon
extends Addon {
    public static final String thaumcraftBackpackId = "block.thaumcraftBackpack";
    public static final String thaumiumChestId = "block.thaumiumChest";
    public static TileBackpack thaumcraftBackpack;
    public static TileThaumiumChest thaumiumChest;
    public static int thaumiumChestRenderId;
    public static ItemStack thaumium;
    public static ItemStack thaumiumBlock;
    public static ItemStack fabric;
    public static InfusionRecipe thaumcraftBackpackRecipe;
    public static InfusionRecipe thaumiumChestRecipe;

    public ThaumcraftAddon() {
        super("Thaumcraft");
    }

    @Override
    public void setupConfig() {
        new TileIdSetting(BetterStorage.globalConfig, thaumcraftBackpackId, 2880);
        new TileIdSetting(BetterStorage.globalConfig, thaumiumChestId, 2881);
    }

    @Override
    public void initializeBlocks() {
        thaumcraftBackpack = MiscUtils.conditionalNew(TileThaumcraftBackpack.class, thaumcraftBackpackId);
        thaumiumChest = MiscUtils.conditionalNew(TileThaumiumChest.class, thaumiumChestId);
    }

    @Override
    public void addRecipes() {
        thaumium = ItemApi.getItem((String)"itemResource", (int)2);
        thaumiumBlock = ItemApi.getBlock((String)"blockCosmeticSolid", (int)4);
        fabric = ItemApi.getItem((String)"itemResource", (int)7);
        ItemStack oakWood = new ItemStack(Block.field_71951_J);
        if (MiscUtils.isEnabled(new Object[]{thaumcraftBackpack, Tiles.backpack})) {
            thaumcraftBackpackRecipe = ThaumcraftApi.addInfusionCraftingRecipe((String)"betterstorage.magicstorage", (Object)new ItemStack((Block)thaumcraftBackpack), (int)1, (AspectList)ThaumcraftAddon.createAspectList(Aspect.VOID, 16, Aspect.EXCHANGE, 12, Aspect.MAGIC, 10), (ItemStack)new ItemStack((Block)Tiles.backpack), (ItemStack[])new ItemStack[]{thaumium, fabric, fabric, fabric});
        }
        if (MiscUtils.isEnabled(new Object[]{thaumiumChest, Tiles.reinforcedChest})) {
            thaumiumChestRecipe = ThaumcraftApi.addInfusionCraftingRecipe((String)"betterstorage.magicstorage", (Object)new ItemStack((Block)thaumiumChest), (int)4, (AspectList)ThaumcraftAddon.createAspectList(Aspect.METAL, 16, Aspect.VOID, 20, Aspect.MAGIC, 16), (ItemStack)new ItemStack((Block)Tiles.reinforcedChest), (ItemStack[])new ItemStack[]{thaumiumBlock, thaumium, oakWood, thaumium, oakWood, thaumium});
        }
    }

    private void addItemAspects() {
        ThaumcraftAddon.addAspectsFor(Tiles.crate, -1, true, Aspect.VOID, 3);
        ThaumcraftAddon.addAspectsFor(Tiles.locker, -1, true, Aspect.VOID, 4);
        ThaumcraftAddon.addAspectsFor(Tiles.reinforcedChest, -1, true, Aspect.VOID, 5, Aspect.METAL, 10, Aspect.ARMOR, 6);
        ThaumcraftAddon.addAspectsFor(Tiles.craftingStation, -1, true, Aspect.CRAFT, 6, Aspect.MECHANISM, 4);
        ThaumcraftAddon.addAspectsFor(Tiles.backpack, -1, true, Aspect.VOID, 4, Aspect.EXCHANGE, 6);
        ThaumcraftAddon.addAspectsFor(Tiles.enderBackpack, -1, true, Aspect.DARKNESS, 8, Aspect.VOID, 4, Aspect.EXCHANGE, 8, Aspect.TRAVEL, 4, Aspect.ELDRITCH, 4, Aspect.MAGIC, 4);
        ThaumcraftAddon.addAspectsFor(Items.cardboardSheet, -1, false, Aspect.CRAFT, 1);
        ThaumcraftAddon.addAspectsFor(Tiles.cardboardBox, -1, true, Aspect.VOID, 2, Aspect.TRAVEL, 2);
        ThaumcraftAddon.addAspectsFor(Items.key, -1, false, Aspect.GREED, 5, Aspect.METAL, 4, Aspect.TOOL, 2);
        ThaumcraftAddon.addAspectsFor(Items.lock, -1, false, Aspect.GREED, 4, Aspect.METAL, 6, Aspect.MECHANISM, 6, Aspect.ARMOR, 8);
        ThaumcraftAddon.addAspectsFor(Items.keyring, -1, false, Aspect.GREED, 1, Aspect.METAL, 2, Aspect.TOOL, 1);
        ThaumcraftAddon.addAspectsFor((Item)Items.drinkingHelmet, -1, true, Aspect.ARMOR, 2, Aspect.MECHANISM, 5, Aspect.ENERGY, 6);
        ThaumcraftAddon.addAspectsFor(Items.slimeBucket, -1, false, Aspect.METAL, 8, Aspect.VOID, 1, Aspect.SLIME, 4);
    }

    private void addEntityAspects() {
        ThaumcraftAddon.addAspectsFor("betterstorage.Frienderman", Aspect.ELDRITCH, 4, Aspect.TRAVEL, 4, Aspect.EXCHANGE, 2);
        ThaumcraftAddon.addAspectsFor("betterstorage.Cluckington", Aspect.BEAST, 2, Aspect.FLIGHT, 2, Aspect.WEAPON, 1);
    }

    private static void addAspectsFor(Block block, int meta, boolean add, Object ... aspects) {
        if (MiscUtils.isEnabled(block)) {
            ThaumcraftAddon.addAspectsFor(block.field_71990_ca, meta, add, aspects);
        }
    }

    private static void addAspectsFor(Item item, int meta, boolean add, Object ... aspects) {
        if (MiscUtils.isEnabled(item)) {
            ThaumcraftAddon.addAspectsFor(item.field_77779_bT, meta, add, aspects);
        }
    }

    private static void addAspectsFor(int id, int meta, boolean add, Object ... aspects) {
        AspectList list = ThaumcraftAddon.createAspectList(aspects);
        if (add) {
            ThaumcraftApi.registerComplexObjectTag((int)id, (int)meta, (AspectList)list);
        } else {
            ThaumcraftApi.registerObjectTag((int)id, (int)meta, (AspectList)list);
        }
    }

    private static void addAspectsFor(String entityName, Object ... aspects) {
        ThaumcraftApi.registerEntityTag((String)entityName, (AspectList)ThaumcraftAddon.createAspectList(aspects), (NBTBase[])new NBTBase[0]);
    }

    public static AspectList createAspectList(Object ... aspects) {
        AspectList list = new AspectList();
        for (int i = 0; i < aspects.length; i += 2) {
            list.add((Aspect)aspects[i], ((Integer)aspects[i + 1]).intValue());
        }
        return list;
    }

    @Override
    public void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityThaumcraftBackpack.class, (String)"container.betterstorage.thaumcraftBackpack");
        GameRegistry.registerTileEntity(TileEntityThaumiumChest.class, (String)"container.betterstorage.thaumiumChest");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        MinecraftForgeClient.registerItemRenderer((int)BetterStorage.globalConfig.getInteger(thaumcraftBackpackId), (IItemRenderer)ItemRendererBackpack.instance);
        thaumiumChestRenderId = ClientProxy.registerTileEntityRenderer(TileEntityThaumiumChest.class, new TileEntityReinforcedChestRenderer());
    }

    @Override
    public void postInitialize() {
        this.addItemAspects();
        this.addEntityAspects();
        if (MiscUtils.isEnabled(new Object[]{thaumcraftBackpack}) || MiscUtils.isEnabled(new Object[]{thaumiumChest})) {
            ArrayList<ResearchPage> pages = new ArrayList<ResearchPage>();
            pages.add(new ResearchPage("tc.research_page.betterstorage.magicstorage.1"));
            if (MiscUtils.isEnabled(new Object[]{thaumcraftBackpack})) {
                pages.add(new ResearchPage(thaumcraftBackpackRecipe));
            }
            if (MiscUtils.isEnabled(new Object[]{thaumiumChest})) {
                pages.add(new ResearchPage(thaumiumChestRecipe));
            }
            ResearchItem researchItem = new ResearchItem("betterstorage.magicstorage", "ARTIFICE", ThaumcraftAddon.createAspectList(Aspect.VOID, 8, Aspect.MAGIC, 5, Aspect.EXCHANGE, 5), 2, 2, 2, new ItemStack((Block)thaumcraftBackpack)).setPages(pages.toArray(new ResearchPage[0])).setParents(new String[]{"ENCHFABRIC"}).setParentsHidden(new String[]{"INFUSION"}).setConcealed().registerResearchItem();
        }
    }
}

