/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.api.crafting;

import java.util.HashMap;
import java.util.Map;
import net.mcft.copy.betterstorage.api.crafting.BetterStorageCrafting;
import net.mcft.copy.betterstorage.api.crafting.IRecipeInput;
import net.mcft.copy.betterstorage.api.crafting.IStationRecipe;
import net.mcft.copy.betterstorage.api.crafting.StationCrafting;
import net.minecraft.item.ItemStack;

public class ShapedStationRecipe
implements IStationRecipe {
    public final IRecipeInput[] recipeInput;
    public final ItemStack[] recipeOutput;
    public final int recipeWidth;
    public final int recipeHeight;
    public int requiredExperience = 0;
    public int craftingTime = 0;

    public ShapedStationRecipe(IRecipeInput[] input, int width, int height, ItemStack[] output) {
        this.recipeInput = input;
        this.recipeOutput = output;
        this.recipeWidth = width;
        this.recipeHeight = height;
    }

    public ShapedStationRecipe(ItemStack[] output, Object ... input) {
        int width = 0;
        int height = 0;
        int inputIndex = 0;
        HashMap<Character, IRecipeInput> inputMap = new HashMap<Character, IRecipeInput>();
        while (inputIndex < input.length && input[inputIndex] instanceof String) {
            String line;
            if ((line = (String)input[inputIndex++]).isEmpty()) {
                throw new IllegalArgumentException("Empty string isn't valid.");
            }
            if (width <= 0) {
                width = line.length();
            } else if (width != line.length()) {
                throw new IllegalArgumentException("All strings must have the same length.");
            }
            for (char chr : line.toCharArray()) {
                inputMap.put(Character.valueOf(chr), null);
            }
            ++height;
        }
        if (height <= 0) {
            throw new IllegalArgumentException("At least one string must be supplied.");
        }
        if (inputIndex >= input.length) {
            throw new IllegalArgumentException("At least one mapping must be supplied.");
        }
        if ((input.length - inputIndex) % 2 > 0) {
            throw new IllegalArgumentException("Mappings have to be in pairs of two.");
        }
        while (inputIndex < input.length) {
            if (!(input[inputIndex] instanceof Character)) {
                throw new IllegalArgumentException("First argument of a mapping needs to be a character.");
            }
            char chr = ((Character)input[inputIndex]).charValue();
            if (!inputMap.containsKey(Character.valueOf(chr))) {
                throw new IllegalArgumentException("Mapping for unused character '" + chr + "'.");
            }
            if (inputMap.get(Character.valueOf(chr)) != null) {
                throw new IllegalArgumentException("Duplicate mapping for character '" + chr + "'.");
            }
            IRecipeInput mapping = BetterStorageCrafting.makeInput(input[inputIndex + 1]);
            inputMap.put(Character.valueOf(chr), mapping);
            inputIndex += 2;
        }
        for (Map.Entry entry : inputMap.entrySet()) {
            if (((Character)entry.getKey()).charValue() == ' ' || entry.getValue() != null) continue;
            throw new IllegalArgumentException("No mapping for character '" + entry.getKey() + "'.");
        }
        this.recipeInput = new IRecipeInput[width * height];
        this.recipeOutput = output;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                this.recipeInput[x + y * width] = (IRecipeInput)inputMap.get(Character.valueOf(((String)input[y]).charAt(x)));
            }
        }
        this.recipeWidth = width;
        this.recipeHeight = height;
    }

    public ShapedStationRecipe setRequiredExperience(int experience) {
        this.requiredExperience = experience;
        return this;
    }

    public ShapedStationRecipe setCraftingTime(int time) {
        this.craftingTime = time;
        return this;
    }

    @Override
    public StationCrafting checkMatch(ItemStack[] input) {
        int x;
        int y;
        int y2;
        int x2;
        int minX = 0;
        int maxX = 2;
        int minY = 0;
        int maxY = 2;
        block0: for (x2 = minX; x2 <= maxX; ++x2) {
            for (y2 = minY; y2 <= maxY; ++y2) {
                if (input[x2 + y2 * 3] == null) continue;
                minX = x2;
                continue block0;
            }
        }
        block2: for (x2 = maxX; x2 > minX; ++x2) {
            for (y2 = minY; y2 <= maxY; ++y2) {
                if (input[x2 + y2 * 3] == null) continue;
                maxX = x2;
                continue block2;
            }
        }
        block4: for (y = minY; y <= maxY; ++y) {
            for (x = minX; x <= maxX; ++x) {
                if (input[x + y * 3] == null) continue;
                minY = y;
                continue block4;
            }
        }
        block6: for (y = maxY; y > minY; ++y) {
            for (x = minX; x <= maxX; ++x) {
                if (input[x + y * 3] == null) continue;
                maxY = y;
                continue block6;
            }
        }
        if (this.recipeWidth != maxX - minX + 1 || this.recipeHeight != maxY - minY + 1) {
            return null;
        }
        IRecipeInput[] requiredInput = new IRecipeInput[9];
        for (y2 = 0; y2 < this.recipeHeight; ++y2) {
            System.arraycopy(this.recipeInput, y2 * this.recipeWidth, requiredInput, minX + (minY + y2) * 3, this.recipeWidth);
            for (int x3 = 0; x3 < this.recipeWidth; ++x3) {
                IRecipeInput recipeStack = this.recipeInput[x3 + y2 * this.recipeWidth];
                int adjustedIndex = minX + x3 + (minY + y2) * 3;
                ItemStack inputStack = input[adjustedIndex];
                if (recipeStack.matches(inputStack) && inputStack.field_77994_a >= recipeStack.getAmount()) continue;
                return null;
            }
        }
        return new StationCrafting(this.recipeOutput, requiredInput, this.requiredExperience, this.craftingTime);
    }

    public static int[] calculateRecipeBounds(ItemStack[] input) {
        int x;
        int y;
        int y2;
        int x2;
        int minX = 0;
        int maxX = 2;
        int minY = 0;
        int maxY = 2;
        block0: for (x2 = minX; x2 <= maxX; ++x2) {
            for (y2 = minY; y2 <= maxY; ++y2) {
                if (input[x2 + y2 * 3] == null) continue;
                minX = x2;
                continue block0;
            }
        }
        block2: for (x2 = maxX; x2 >= minX; --x2) {
            for (y2 = minY; y2 <= maxY; ++y2) {
                if (input[x2 + y2 * 3] == null) continue;
                maxX = x2;
                continue block2;
            }
        }
        block4: for (y = minY; y <= maxY; ++y) {
            for (x = minX; x <= maxX; ++x) {
                if (input[x + y * 3] == null) continue;
                minY = y;
                continue block4;
            }
        }
        block6: for (y = maxY; y >= minY; --y) {
            for (x = minX; x <= maxX; ++x) {
                if (input[x + y * 3] == null) continue;
                maxY = y;
                continue block6;
            }
        }
        int width = maxX - minX + 1;
        int height = maxY - minY + 1;
        return new int[]{minX, minY, width, height};
    }
}

