/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.config;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mcft.copy.betterstorage.config.setting.BooleanSetting;
import net.mcft.copy.betterstorage.config.setting.DoubleSetting;
import net.mcft.copy.betterstorage.config.setting.IntegerSetting;
import net.mcft.copy.betterstorage.config.setting.Setting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.Configuration;

public class Config {
    private final Configuration forgeConfig;
    private final Map<String, Setting> settings = new HashMap<String, Setting>();
    private final List<Setting> syncedSettings = new ArrayList<Setting>();

    public Config(File file) {
        this.forgeConfig = new Configuration(file);
    }

    public void add(Setting setting) {
        this.settings.put(setting.fullName, setting);
    }

    public void syncSetting(Setting setting) {
        this.syncedSettings.add(setting);
    }

    public Setting get(String name) {
        return this.settings.get(name);
    }

    public int getInteger(String name) {
        return (Integer)((IntegerSetting)this.get(name)).getValue();
    }

    public double getDouble(String name) {
        return (Double)((DoubleSetting)this.get(name)).getValue();
    }

    public boolean getBoolean(String name) {
        return (Boolean)((BooleanSetting)this.get(name)).getValue();
    }

    public void load() {
        this.forgeConfig.load();
        for (Setting setting : this.settings.values()) {
            setting.load(this.forgeConfig);
        }
    }

    public void save() {
        for (Setting setting : this.settings.values()) {
            setting.save(this.forgeConfig);
        }
        this.forgeConfig.save();
    }

    public void validate() {
        for (Setting setting : this.settings.values()) {
            setting.validate();
        }
    }

    public void read(NBTTagCompound compound) {
        for (Setting setting : this.syncedSettings) {
            setting.read(compound);
        }
    }

    public void write(NBTTagCompound compound) {
        for (Setting setting : this.syncedSettings) {
            setting.write(compound);
        }
    }
}

