/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.inventory;

import java.util.Arrays;
import net.mcft.copy.betterstorage.api.crafting.BetterStorageCrafting;
import net.mcft.copy.betterstorage.api.crafting.ContainerInfo;
import net.mcft.copy.betterstorage.api.crafting.CraftingSourceTileEntity;
import net.mcft.copy.betterstorage.api.crafting.IRecipeInput;
import net.mcft.copy.betterstorage.api.crafting.StationCrafting;
import net.mcft.copy.betterstorage.config.GlobalConfig;
import net.mcft.copy.betterstorage.inventory.InventoryBetterStorage;
import net.mcft.copy.betterstorage.inventory.InventoryStacks;
import net.mcft.copy.betterstorage.item.recipe.VanillaStationCrafting;
import net.mcft.copy.betterstorage.tile.entity.TileEntityCraftingStation;
import net.mcft.copy.betterstorage.utils.InventoryUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public class InventoryCraftingStation
extends InventoryBetterStorage {
    public TileEntityCraftingStation entity = null;
    public final ItemStack[] crafting;
    public final ItemStack[] output;
    public final ItemStack[] contents;
    public final ItemStack[] lastOutput;
    public StationCrafting currentCrafting = null;
    public boolean outputIsReal = false;
    public int progress = 0;
    private boolean hasRequirements = false;
    private boolean checkHasRequirements = true;

    public InventoryCraftingStation(TileEntityCraftingStation entity) {
        this("", entity.crafting, entity.output, entity.contents);
        this.entity = entity;
    }

    public InventoryCraftingStation(String name) {
        this(name, new ItemStack[9], new ItemStack[9], new ItemStack[18]);
    }

    private InventoryCraftingStation(String name, ItemStack[] crafting, ItemStack[] output, ItemStack[] contents) {
        super(name);
        this.crafting = crafting;
        this.output = output;
        this.contents = contents;
        this.lastOutput = new ItemStack[output.length];
        this.updateLastOutput();
        this.func_70296_d();
    }

    public void update() {
        if (!(this.outputIsReal || this.currentCrafting == null || this.progress >= this.currentCrafting.getCraftingTime() && this.progress >= (Integer)GlobalConfig.stationAutocraftDelaySetting.getValue())) {
            ++this.progress;
        }
    }

    public void inputChanged() {
        this.currentCrafting = BetterStorageCrafting.findMatchingStationCrafting(this.crafting);
        if (this.currentCrafting == null) {
            this.currentCrafting = VanillaStationCrafting.findVanillaRecipe(this);
        }
        if (!this.outputIsReal) {
            if (this.currentCrafting != null) {
                ItemStack[] craftingOutput = this.currentCrafting.getOutput();
                for (int i = 0; i < this.output.length; ++i) {
                    this.output[i] = i < craftingOutput.length ? ItemStack.func_77944_b((ItemStack)craftingOutput[i]) : null;
                }
            } else {
                Arrays.fill(this.output, null);
            }
        }
        this.updateLastOutput();
    }

    public void craft(EntityPlayer player) {
        CraftingSourceTileEntity source = new CraftingSourceTileEntity(this.entity, player);
        this.currentCrafting.craft(source);
        IRecipeInput[] requiredInput = this.currentCrafting.getCraftRequirements();
        for (int i = 0; i < this.crafting.length; ++i) {
            if (this.crafting[i] == null) continue;
            this.crafting[i] = this.craftSlot(this.crafting[i], requiredInput[i], player, false);
        }
        int requiredExperience = this.currentCrafting.getRequiredExperience();
        if (requiredExperience != 0 && player != null && !player.field_71075_bZ.field_75098_d) {
            player.field_71068_ca -= requiredExperience;
        }
        if (this.hasItemRequirements()) {
            this.pullRequired(requiredInput, false);
        }
        this.outputIsReal = !this.outputEmpty();
        this.progress = 0;
        this.inputChanged();
        this.checkHasRequirements = true;
    }

    private ItemStack craftSlot(ItemStack stack, IRecipeInput requiredInput, EntityPlayer player, boolean simulate) {
        if (simulate) {
            stack = stack.func_77946_l();
        }
        ContainerInfo containerInfo = new ContainerInfo();
        requiredInput.craft(stack, containerInfo);
        ItemStack containerItem = ItemStack.func_77944_b((ItemStack)containerInfo.getContainerItem());
        boolean removeStack = false;
        if (stack.field_77994_a <= 0) {
            removeStack = true;
        } else if (stack.func_77973_b().func_77645_m() && stack.func_77960_j() > stack.func_77958_k()) {
            removeStack = true;
            if (player != null) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, stack));
            }
        }
        if (removeStack) {
            if (!containerInfo.doesLeaveCrafting()) {
                stack = containerItem;
                containerItem = null;
            } else {
                stack = null;
            }
        }
        if (containerItem != null && !simulate && !InventoryUtils.tryAddItemToInventory(containerItem, new InventoryStacks(new ItemStack[][]{this.contents}), true) && this.entity != null) {
            WorldUtils.spawnItem(this.entity.field_70331_k, (double)this.entity.field_70329_l + 0.5, (double)this.entity.field_70330_m + 0.5, (double)this.entity.field_70327_n + 0.5, containerItem);
        }
        return stack;
    }

    public boolean pullRequired(IRecipeInput[] requiredInput, boolean simulate) {
        ItemStack[] contents = simulate ? (ItemStack[])this.contents.clone() : this.contents;
        ItemStack[] crafting = simulate ? (ItemStack[])this.crafting.clone() : this.crafting;
        boolean success = true;
        block0: for (int i = 0; i < crafting.length; ++i) {
            ItemStack stack = crafting[i];
            IRecipeInput required = requiredInput[i];
            if (required != null) {
                int requiredAmount;
                int currentAmount = 0;
                if (stack != null && simulate) {
                    stack = this.craftSlot(stack, required, null, true);
                }
                if (stack != null) {
                    if (!required.matches(stack)) {
                        return false;
                    }
                    currentAmount = stack.field_77994_a;
                }
                if ((requiredAmount = required.getAmount() - currentAmount) <= 0) continue;
                for (int j = 0; j < contents.length; ++j) {
                    ItemStack contentsStack = contents[j];
                    if (contentsStack == null || !(stack == null ? required.matches(contentsStack) : StackUtils.matches(stack, contentsStack))) continue;
                    int amount = Math.min(contentsStack.field_77994_a, requiredAmount);
                    crafting[i] = stack = StackUtils.copyStack(contentsStack, currentAmount += amount);
                    contents[j] = StackUtils.copyStack(contentsStack, contentsStack.field_77994_a - amount);
                    if ((requiredAmount -= amount) <= 0) continue block0;
                }
            } else if (stack == null) continue;
            success = false;
            if (!simulate) break;
        }
        return success;
    }

    public boolean canTake(EntityPlayer player) {
        return this.outputIsReal || this.currentCrafting != null && this.currentCrafting.canCraft(new CraftingSourceTileEntity(this.entity, player)) && this.progress >= this.currentCrafting.getCraftingTime() && this.hasRequiredExperience(player) && (player != null || this.progress >= (Integer)GlobalConfig.stationAutocraftDelaySetting.getValue() && this.hasItemRequirements());
    }

    private boolean hasRequiredExperience(EntityPlayer player) {
        int requiredExperience = this.currentCrafting.getRequiredExperience();
        return requiredExperience == 0 || player != null && (player.field_71075_bZ.field_75098_d || player.field_71068_ca >= requiredExperience);
    }

    public boolean hasItemRequirements() {
        if (this.checkHasRequirements) {
            this.hasRequirements = this.pullRequired(this.currentCrafting.getCraftRequirements(), true);
            this.checkHasRequirements = false;
        }
        return this.hasRequirements;
    }

    public int func_70302_i_() {
        return this.crafting.length + this.output.length + this.contents.length;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < this.crafting.length) {
            return this.crafting[slot];
        }
        if (slot < this.crafting.length + this.output.length) {
            return this.output[slot - this.crafting.length];
        }
        return this.contents[slot - (this.crafting.length + this.output.length)];
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot < this.crafting.length) {
            this.crafting[slot] = stack;
        } else if (slot < this.crafting.length + this.output.length) {
            this.output[slot - this.crafting.length] = stack;
        } else {
            this.contents[slot - (this.crafting.length + this.output.length)] = stack;
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_70296_d() {
        boolean updateLastOutput = false;
        if (this.outputChanged()) {
            if (!this.outputIsReal && this.currentCrafting != null && this.entity != null) {
                this.craft(null);
            }
            updateLastOutput = true;
        }
        if (this.outputEmpty()) {
            this.outputIsReal = false;
            if (this.currentCrafting != null) {
                ItemStack[] recipeOutput = this.currentCrafting.getOutput();
                for (int i = 0; i < recipeOutput.length; ++i) {
                    this.output[i] = ItemStack.func_77944_b((ItemStack)recipeOutput[i]);
                }
            }
            updateLastOutput = true;
        }
        this.checkHasRequirements = true;
        if (updateLastOutput) {
            this.updateLastOutput();
        }
    }

    private void updateLastOutput() {
        for (int i = 0; i < this.output.length; ++i) {
            this.lastOutput[i] = ItemStack.func_77944_b((ItemStack)this.output[i]);
        }
    }

    private boolean outputChanged() {
        for (int i = 0; i < this.output.length; ++i) {
            if (ItemStack.func_77989_b((ItemStack)this.output[i], (ItemStack)this.lastOutput[i])) continue;
            return true;
        }
        return false;
    }

    private boolean outputEmpty() {
        for (int i = 0; i < this.output.length; ++i) {
            if (this.output[i] == null) continue;
            return false;
        }
        return true;
    }
}

