/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.inventory;

import java.util.List;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.api.ICrateWatcher;
import net.mcft.copy.betterstorage.config.GlobalConfig;
import net.mcft.copy.betterstorage.inventory.InventoryBetterStorage;
import net.mcft.copy.betterstorage.tile.crate.CratePileData;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class InventoryCrateBlockView
extends InventoryBetterStorage
implements ICrateWatcher {
    private static final int numStacksStored = 4;
    private final CratePileData data;
    private final ItemStack[] originalStacks = new ItemStack[4];
    private final ItemStack[] exposedStacks = new ItemStack[4];
    private boolean changed = true;
    private boolean isModifying = false;
    private boolean accessed = false;

    public InventoryCrateBlockView(CratePileData data) {
        super("container.betterstorage.crate");
        this.data = data;
        data.addWatcher(this);
    }

    public int func_70302_i_() {
        return 5;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot > 0 || this.data.spaceForItem(stack) >= stack.field_77994_a;
    }

    public ItemStack func_70301_a(int slot) {
        this.access();
        if (slot <= 0 || slot >= this.func_70302_i_()) {
            return null;
        }
        return this.exposedStacks[slot - 1];
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.access();
        if (slot < 0 || slot >= this.func_70302_i_()) {
            return;
        }
        ItemStack oldStack = null;
        if (slot > 0) {
            oldStack = this.originalStacks[slot - 1];
            this.exposedStacks[slot - 1] = stack;
            this.originalStacks[slot - 1] = ItemStack.func_77944_b((ItemStack)stack);
        }
        this.isModifying = true;
        if (oldStack != null) {
            if (StackUtils.matches(oldStack, stack)) {
                int count = stack.field_77994_a - oldStack.field_77994_a;
                if (count > 0) {
                    this.data.addItems(StackUtils.copyStack(stack, count));
                } else if (count < 0) {
                    this.data.removeItems(StackUtils.copyStack(stack, -count));
                }
                this.isModifying = false;
                return;
            }
            this.data.removeItems(oldStack);
        }
        this.data.addItems(stack);
        this.isModifying = false;
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack == null) {
            return null;
        }
        amount = Math.min(amount, stack.field_77994_a);
        this.originalStacks[slot - 1].field_77994_a = this.exposedStacks[slot - 1].field_77994_a -= amount;
        this.isModifying = true;
        ItemStack result = this.data.removeItems(stack, amount);
        this.isModifying = false;
        return result;
    }

    public void func_70296_d() {
        for (int i = 0; i < 4; ++i) {
            if (ItemStack.func_77989_b((ItemStack)this.originalStacks[i], (ItemStack)this.exposedStacks[i])) continue;
            this.func_70299_a(i + 1, this.exposedStacks[i]);
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void onUpdate() {
        if (!((Boolean)GlobalConfig.enableCrateInventoryInterfaceSetting.getValue()).booleanValue() || !this.accessed) {
            return;
        }
        this.accessed = false;
        for (int i = 0; i < 4; ++i) {
            if (ItemStack.func_77989_b((ItemStack)this.originalStacks[i], (ItemStack)this.exposedStacks[i])) continue;
            BetterStorage.log.warning("A crate inventory was modified without onInventoryChanged() being called afterwards.");
            BetterStorage.log.warning("The crate Inventory interface will be disabled until the next restart, to minimize chances of issues.");
            BetterStorage.log.warning(String.format("You can find the crate pile at [%s,%s,%s] in dimension %s.", this.data.getCenterX(), this.data.getCenterY(), this.data.getCenterZ(), this.data.collection.dimension));
            GlobalConfig.enableCrateInventoryInterfaceSetting.setSyncedValue(false);
            this.func_70296_d();
            return;
        }
        this.changed = true;
    }

    private void access() {
        this.accessed = true;
        if (this.changed) {
            List<ItemStack> picked = this.data.pickItemStacks(4);
            for (int i = 0; i < 4; ++i) {
                this.exposedStacks[i] = i < picked.size() ? picked.get(i) : null;
                this.originalStacks[i] = ItemStack.func_77944_b((ItemStack)this.exposedStacks[i]);
            }
            this.changed = false;
        }
    }

    @Override
    public void onCrateItemsModified(ItemStack stack) {
        if (!this.isModifying) {
            this.changed = true;
        }
    }
}

