/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import net.mcft.copy.betterstorage.api.ICrateWatcher;
import net.mcft.copy.betterstorage.inventory.InventoryBetterStorage;
import net.mcft.copy.betterstorage.misc.ItemIdentifier;
import net.mcft.copy.betterstorage.tile.crate.CratePileData;
import net.mcft.copy.betterstorage.tile.crate.TileEntityCrate;
import net.mcft.copy.betterstorage.utils.RandomUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class InventoryCratePlayerView
extends InventoryBetterStorage
implements ICrateWatcher {
    private static final int inventoryMaxSize = 54;
    public final CratePileData data;
    public final TileEntityCrate crate;
    private ItemStack[] tempContents;
    private Map<ItemIdentifier, MapData> countData = new HashMap<ItemIdentifier, MapData>();
    private boolean ignoreModifiedItems = false;

    public InventoryCratePlayerView(TileEntityCrate crate) {
        super("container.betterstorage.crate");
        this.data = crate.getPileData();
        this.crate = crate;
        int size = Math.min(this.data.getCapacity(), 54);
        this.tempContents = new ItemStack[size];
        int totalStacks = this.data.getOccupiedSlots();
        LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
        for (ItemStack contentsStack : this.data) {
            stacks.add(contentsStack.func_77946_l());
        }
        ArrayList<Integer> slotAccess = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            slotAccess.add(i);
        }
        if (totalStacks < size) {
            Collections.shuffle(slotAccess);
        }
        block2: for (int slot = 0; totalStacks > 0 && slot < size; ++slot) {
            int randomStack = RandomUtils.getInt(totalStacks--);
            ListIterator iter = stacks.listIterator();
            while (iter.hasNext()) {
                ItemStack contentsStack = (ItemStack)iter.next();
                int numStacks = StackUtils.calcNumStacks(contentsStack);
                if (randomStack < numStacks) {
                    ItemStack stack = contentsStack.func_77946_l();
                    stack.field_77994_a = Math.min(stack.field_77994_a, stack.func_77976_d());
                    this.getMapData((ItemStack)stack).itemCount += stack.field_77994_a;
                    this.tempContents[((Integer)slotAccess.get((int)slot)).intValue()] = stack;
                    if ((contentsStack.field_77994_a -= stack.field_77994_a) > 0) continue block2;
                    iter.remove();
                    continue block2;
                }
                randomStack -= numStacks;
            }
        }
    }

    private MapData getMapData(ItemIdentifier item) {
        MapData data = this.countData.get(item);
        if (data != null) {
            return data;
        }
        data = new MapData();
        this.countData.put(item, data);
        return data;
    }

    private MapData getMapData(ItemStack item) {
        return this.getMapData(new ItemIdentifier(item));
    }

    public int func_70302_i_() {
        return this.tempContents.length;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < 0 || slot >= this.func_70302_i_()) {
            return null;
        }
        return this.tempContents[slot];
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot < 0 || slot >= this.func_70302_i_()) {
            return;
        }
        ItemStack oldStack = this.func_70301_a(slot);
        this.ignoreModifiedItems = true;
        if (oldStack != null) {
            this.getMapData((ItemStack)oldStack).itemCount -= oldStack.field_77994_a;
            this.data.removeItems(oldStack);
        }
        if (stack != null) {
            int amount = Math.min(stack.field_77994_a, Math.min(this.data.spaceForItem(stack), stack.func_77976_d()));
            if (amount <= 0) {
                return;
            }
            stack = StackUtils.copyStack(stack.func_77946_l(), amount);
            this.getMapData((ItemStack)stack).itemCount += amount;
            this.data.addItems(stack);
        }
        this.ignoreModifiedItems = false;
        this.tempContents[slot] = stack;
        if (stack == null) {
            this.onSlotEmptied(slot);
        }
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack == null) {
            return null;
        }
        amount = Math.min(amount, stack.field_77994_a);
        ItemIdentifier item = new ItemIdentifier(stack);
        this.getMapData((ItemIdentifier)item).itemCount -= amount;
        stack.field_77994_a -= amount;
        if (stack.field_77994_a <= 0) {
            this.tempContents[slot] = null;
        }
        this.ignoreModifiedItems = true;
        ItemStack result = this.data.removeItems(item, amount);
        this.ignoreModifiedItems = false;
        if (this.tempContents[slot] == null) {
            this.onSlotEmptied(slot);
        }
        return result;
    }

    public boolean func_70300_a(EntityPlayer player) {
        int x = this.crate.field_70329_l;
        int y = this.crate.field_70330_m;
        int z = this.crate.field_70327_n;
        return player.field_70170_p.func_72796_p(x, y, z) == this.crate && player.func_70092_e((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) < 64.0 && this.func_70302_i_() <= this.data.getCapacity();
    }

    public void func_70296_d() {
    }

    public void func_70295_k_() {
        this.data.addWatcher(this);
    }

    public void func_70305_f() {
        this.data.removeWatcher(this);
    }

    @Override
    public void onCrateItemsModified(ItemStack changed) {
        if (this.ignoreModifiedItems) {
            return;
        }
        ItemIdentifier item = new ItemIdentifier(changed);
        int amount = changed.field_77994_a;
        MapData itemData = this.getMapData(item);
        LinkedList<Integer> emptySlots = new LinkedList<Integer>();
        for (int slot = 0; slot < this.tempContents.length; ++slot) {
            ItemStack stack = this.tempContents[slot];
            if (stack == null) {
                emptySlots.add(slot);
                continue;
            }
            if (!item.matches(stack) || (amount -= this.modifyItemsInSlot(slot, stack, itemData, amount)) != 0) continue;
            return;
        }
        while (amount > 0 && emptySlots.size() > 0) {
            amount -= this.setItemsInSlot((Integer)emptySlots.poll(), item, itemData, amount);
        }
    }

    public boolean canFitSome(ItemStack item) {
        for (ItemStack stack : this.tempContents) {
            if (stack != null && (!StackUtils.matches(stack, item) || stack.field_77994_a >= stack.func_77976_d())) continue;
            return true;
        }
        return false;
    }

    private void onSlotEmptied(int slot) {
        int emptySlots = 0;
        for (int s = 0; s < this.tempContents.length; ++s) {
            if (this.tempContents[s] != null) continue;
            ++emptySlots;
        }
        if (emptySlots <= this.data.getFreeSlots()) {
            return;
        }
        int size = this.data.getNumItems();
        ArrayList<Integer> randomIndexList = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            randomIndexList.add(i);
        }
        while (emptySlots > this.data.getFreeSlots() && randomIndexList.size() > 0) {
            int randomIndex = RandomUtils.getInt(randomIndexList.size());
            int index = (Integer)randomIndexList.get(randomIndex);
            ItemStack stack = this.data.getItemStack(index);
            ItemIdentifier item = new ItemIdentifier(stack);
            MapData itemData = this.getMapData(item);
            int count = stack.field_77994_a - itemData.itemCount;
            if (count <= 0) continue;
            this.setItemsInSlot(slot, item, itemData, count);
            break;
        }
    }

    private int modifyItemsInSlot(int slot, ItemStack stack, MapData itemData, int amount) {
        int count = Math.max(-stack.field_77994_a, Math.min(amount, stack.func_77976_d() - stack.field_77994_a));
        if ((stack.field_77994_a += count) <= 0) {
            this.tempContents[slot] = null;
        }
        itemData.itemCount += count;
        return count;
    }

    private int setItemsInSlot(int slot, ItemIdentifier item, MapData itemData, int maxAmount) {
        int size = Math.min(maxAmount, item.getItem().func_77639_j());
        this.tempContents[slot] = item.createStack(size);
        itemData.itemCount += size;
        return size;
    }

    private static class MapData {
        public int itemCount = 0;

        private MapData() {
        }
    }
}

