/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.inventory;

import net.mcft.copy.betterstorage.inventory.InventoryBetterStorage;
import net.mcft.copy.betterstorage.inventory.InventoryStacks;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryTileEntity
extends InventoryBetterStorage {
    public final TileEntityContainer mainTileEntity;
    public final TileEntityContainer[] tileEntities;
    public final IInventory inventory;
    public final int columns;
    public final int rows;

    public InventoryTileEntity(TileEntityContainer mainTileEntity, TileEntityContainer[] tileEntities, IInventory inventory) {
        this.mainTileEntity = mainTileEntity;
        this.tileEntities = tileEntities;
        this.inventory = inventory;
        this.columns = mainTileEntity.getColumns();
        this.rows = inventory.func_70302_i_() / this.columns;
    }

    public InventoryTileEntity(TileEntityContainer mainTileEntity, TileEntityContainer ... tileEntities) {
        this(mainTileEntity, tileEntities, new InventoryStacks(InventoryTileEntity.getAllContents(tileEntities)));
    }

    public InventoryTileEntity(TileEntityContainer tileEntity, IInventory inventory) {
        this(tileEntity, new TileEntityContainer[]{tileEntity}, inventory);
    }

    public InventoryTileEntity(TileEntityContainer tileEntity) {
        this(tileEntity, new InventoryStacks(new ItemStack[][]{tileEntity.contents}));
    }

    private static ItemStack[][] getAllContents(TileEntityContainer ... tileEntities) {
        ItemStack[][] allContents = new ItemStack[tileEntities.length][];
        for (int i = 0; i < tileEntities.length; ++i) {
            allContents[i] = tileEntities[i].contents;
        }
        return allContents;
    }

    @Override
    public String func_70303_b() {
        return this.mainTileEntity.getContainerTitle();
    }

    @Override
    public boolean func_94042_c() {
        return !this.mainTileEntity.shouldLocalizeTitle();
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    public boolean func_70300_a(EntityPlayer player) {
        for (TileEntityContainer tileEntity : this.tileEntities) {
            if (tileEntity.canPlayerUseContainer(player)) continue;
            return false;
        }
        return true;
    }

    public void func_70295_k_() {
        this.mainTileEntity.onContainerOpened();
    }

    public void func_70305_f() {
        this.mainTileEntity.onContainerClosed();
    }

    public void func_70296_d() {
        this.inventory.func_70296_d();
        for (TileEntityContainer te : this.tileEntities) {
            te.func_70296_d();
        }
    }
}

