/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.client.model.ModelBackpack;
import net.mcft.copy.betterstorage.client.model.ModelBackpackArmor;
import net.mcft.copy.betterstorage.container.ContainerBetterStorage;
import net.mcft.copy.betterstorage.container.SlotArmorBackpack;
import net.mcft.copy.betterstorage.inventory.InventoryBackpackEquipped;
import net.mcft.copy.betterstorage.inventory.InventoryStacks;
import net.mcft.copy.betterstorage.item.IDyeableItem;
import net.mcft.copy.betterstorage.item.ItemArmorBetterStorage;
import net.mcft.copy.betterstorage.misc.PropertiesBackpack;
import net.mcft.copy.betterstorage.misc.Resources;
import net.mcft.copy.betterstorage.misc.handlers.KeyBindingHandler;
import net.mcft.copy.betterstorage.misc.handlers.PacketHandler;
import net.mcft.copy.betterstorage.tile.entity.TileEntityBackpack;
import net.mcft.copy.betterstorage.utils.DirectionUtils;
import net.mcft.copy.betterstorage.utils.EntityUtils;
import net.mcft.copy.betterstorage.utils.LanguageUtils;
import net.mcft.copy.betterstorage.utils.PlayerUtils;
import net.mcft.copy.betterstorage.utils.RandomUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet103SetSlot;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumHelper;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISpecialArmor;

public class ItemBackpack
extends ItemArmorBetterStorage
implements ISpecialArmor,
IDyeableItem {
    public static final EnumArmorMaterial material = EnumHelper.addArmorMaterial((String)"backpack", (int)14, (int[])new int[]{0, 2, 0, 0}, (int)15);
    @SideOnly(value=Side.CLIENT)
    private ModelBackpack model;
    @SideOnly(value=Side.CLIENT)
    private ModelBackpackArmor modelArmor;
    private static final String[] immuneToDamageType;

    protected ItemBackpack(int id, EnumArmorMaterial material) {
        super(id - 256, material, 0, 1);
    }

    public ItemBackpack(int id) {
        this(id, material);
    }

    @Override
    public boolean isItemBlock() {
        return true;
    }

    public String getBackpackName() {
        return "container.betterstorage.backpack";
    }

    public int getBackpackColumns() {
        return 9;
    }

    public int getBackpackRows() {
        return BetterStorage.globalConfig.getInteger("settings.backpackRows");
    }

    protected int getDefaultColor() {
        return 10511680;
    }

    protected IInventory getBackpackItemsInternal(EntityLivingBase carrier, EntityPlayer player) {
        PropertiesBackpack backpackData = ItemBackpack.getBackpackData(carrier);
        int size = this.getBackpackColumns() * this.getBackpackRows();
        if (backpackData.contents == null) {
            backpackData.contents = new ItemStack[size];
        } else if (backpackData.contents.length != size) {
            ItemStack[] newContents = new ItemStack[size];
            System.arraycopy(backpackData.contents, 0, newContents, 0, Math.min(size, backpackData.contents.length));
            backpackData.contents = newContents;
        }
        return new InventoryStacks(this.getBackpackName(), (ItemStack[][])new ItemStack[][]{backpackData.contents});
    }

    public boolean containsItems(PropertiesBackpack backpackData) {
        return backpackData.hasItems || backpackData.contents != null && !StackUtils.isEmpty(backpackData.contents);
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends ModelBackpack> getModelClass() {
        return ModelBackpack.class;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBackpack getModel() {
        if (this.model == null) {
            try {
                this.model = this.getModelClass().getConstructor(Boolean.TYPE).newInstance(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.model;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entity, ItemStack stack, int slot) {
        if (this.modelArmor == null) {
            try {
                ModelBackpack model = this.getModelClass().getConstructor(Boolean.TYPE).newInstance(false);
                this.modelArmor = new ModelBackpackArmor(model);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.modelArmor;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return (type == "overlay" ? Resources.textureBackpackOverlay : Resources.textureBackpack).toString();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
    }

    public String func_77658_a() {
        return Block.field_71973_m[this.field_77779_bT].func_71917_a();
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_77640_w() {
        return Block.field_71973_m[this.field_77779_bT].func_71882_w();
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return false;
    }

    public int func_82814_b(ItemStack stack) {
        int color = this.getDefaultColor();
        return color >= 0 ? StackUtils.get(stack, color, "display", "color") : color;
    }

    public int getRenderPasses(int metadata) {
        return this.getDefaultColor() >= 0 ? 2 : 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        boolean enableHelpTooltips = BetterStorage.globalConfig.getBoolean("settings.enableHelpTooltips");
        if (ItemBackpack.getBackpack((EntityLivingBase)player) == stack) {
            String info = LanguageUtils.translateTooltip(this.getAdditionalInfo(stack, player), new String[0]);
            if (ItemBackpack.isBackpackOpen((EntityLivingBase)player)) {
                if (info != null) {
                    list.add(info);
                }
                LanguageUtils.translateTooltip(list, "backpack.used", new String[0]);
            } else if (enableHelpTooltips) {
                String[] stringArray;
                String string = info != null ? "backpack.unequipHint.extended" : "backpack.unequipHint";
                if (info != null) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = "%INFO%";
                    stringArray = stringArray2;
                    stringArray2[1] = info;
                } else {
                    stringArray = new String[]{};
                }
                LanguageUtils.translateTooltip(list, string, stringArray);
            } else if (info != null) {
                list.add(info);
            }
            if (BetterStorage.globalConfig.getBoolean("settings.enableBackpackOpen")) {
                String str = GameSettings.func_74298_c((int)KeyBindingHandler.backpackOpen.field_74512_d);
                LanguageUtils.translateTooltip(list, "backpack.openHint", "%KEY%", str);
            }
        } else if (enableHelpTooltips) {
            boolean chestplate = BetterStorage.globalConfig.getBoolean("settings.backpackChestplate");
            LanguageUtils.translateTooltip(list, chestplate ? "backpack.equipHint" : "backpack.equipHint.extended", new String[0]);
            if (!chestplate) {
                String str = GameSettings.func_74298_c((int)KeyBindingHandler.backpackOpen.field_74512_d);
                LanguageUtils.translateTooltip(list, "backpack.openHint", "%KEY%", str);
            }
        }
    }

    protected String getAdditionalInfo(ItemStack stack, EntityPlayer player) {
        return this.containsItems(ItemBackpack.getBackpackData((EntityLivingBase)player)) ? "backpack.containsItems" : null;
    }

    public void onArmorTickUpdate(World world, EntityPlayer player, ItemStack itemStack) {
        int index = 5 + this.field_77881_a;
        Slot slotBefore = player.field_71069_bz.func_75139_a(index);
        if (slotBefore instanceof SlotArmorBackpack) {
            return;
        }
        int slotIndex = player.field_71071_by.func_70302_i_() - this.getChestSlotOffset(player) - this.field_77881_a;
        SlotArmorBackpack slot = new SlotArmorBackpack((IInventory)player.field_71071_by, slotIndex, 8, 8 + this.field_77881_a * 18);
        slot.field_75222_d = index;
        player.field_71069_bz.field_75151_b.set(index, slot);
    }

    private int getChestSlotOffset(EntityPlayer player) {
        return ItemBackpack.isExact(player.field_71071_by, "micdoodle8.mods.galacticraft.core.inventory.GCCoreInventoryPlayer") ? 6 : 1;
    }

    private static boolean isExact(Object obj, String str) {
        try {
            return obj.getClass().getName().equals(str);
        }
        catch (Exception e) {
            return false;
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        return stack;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        ForgeDirection orientation = DirectionUtils.getOrientation((Entity)player).getOpposite();
        return ItemBackpack.placeBackpack((EntityLivingBase)player, player, stack, x, y, z, side, orientation, false, false);
    }

    public void onEquippedUpdate(EntityLivingBase player, ItemStack backpack) {
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase entity, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, 0.08, armor.func_77958_k() + 1 - armor.func_77960_j());
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 2;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (!this.takesDamage(stack, source)) {
            return;
        }
        stack.func_77972_a(damage, entity);
        if (stack.field_77994_a > 0) {
            return;
        }
        PropertiesBackpack backpackData = ItemBackpack.getBackpackData(entity);
        if (backpackData.contents != null) {
            for (ItemStack s : backpackData.contents) {
                WorldUtils.dropStackFromEntity((Entity)entity, s, 2.0f);
            }
        }
        entity.func_70669_a(stack);
    }

    protected boolean takesDamage(ItemStack stack, DamageSource source) {
        if (source.func_82725_o()) {
            return false;
        }
        for (String immune : immuneToDamageType) {
            if (!immune.equals(source.func_76355_l())) continue;
            return false;
        }
        return !(this.enchantmentProtection(stack, Enchantment.field_77332_c, 0.3, 0.35, 0.4, 0.45) || source.func_76352_a() && this.enchantmentProtection(stack, Enchantment.field_77328_g, 0.4, 0.5, 0.6, 0.7) || source.func_76347_k() && this.enchantmentProtection(stack, Enchantment.field_77329_d, 0.55, 0.65, 0.75, 0.85) || source.func_94541_c() && this.enchantmentProtection(stack, Enchantment.field_77327_f, 0.65, 0.75, 0.85, 0.95));
    }

    private boolean enchantmentProtection(ItemStack stack, Enchantment ench, double ... chance) {
        int level = EnchantmentHelper.func_77506_a((int)ench.field_77352_x, (ItemStack)stack);
        return (level = Math.min(level - 1, chance.length - 1)) >= 0 && RandomUtils.getBoolean(chance[level]);
    }

    @Override
    public boolean canDye(ItemStack stack) {
        return this.getDefaultColor() >= 0;
    }

    public static ItemStack getBackpack(EntityLivingBase entity) {
        ItemStack backpack = entity.func_71124_b(3);
        if (backpack != null && backpack.func_77973_b() instanceof ItemBackpack) {
            return backpack;
        }
        return ItemBackpack.getBackpackData((EntityLivingBase)entity).backpack;
    }

    public static void setBackpack(EntityLivingBase entity, ItemStack backpack, ItemStack[] contents) {
        boolean setChestplate = BetterStorage.globalConfig.getBoolean("settings.backpackChestplate") || !(entity instanceof EntityPlayer) || ItemBackpack.hasChestplateBackpackEquipped(entity);
        PropertiesBackpack backpackData = ItemBackpack.getBackpackData(entity);
        if (!setChestplate) {
            backpackData.backpack = backpack;
        } else {
            entity.func_70062_b(3, backpack);
        }
        backpackData.contents = contents;
        ItemBackpack.updateHasItems(entity, backpackData);
    }

    public static boolean hasChestplateBackpackEquipped(EntityLivingBase entity) {
        ItemStack backpack = ItemBackpack.getBackpack(entity);
        return backpack != null ? backpack == entity.func_71124_b(3) : false;
    }

    public static boolean canEquipBackpack(EntityPlayer player) {
        return ItemBackpack.getBackpack((EntityLivingBase)player) == null && (!BetterStorage.globalConfig.getBoolean("settings.backpackChestplate") || player.func_71124_b(3) == null);
    }

    public static IInventory getBackpackItems(EntityLivingBase carrier, EntityPlayer player) {
        ItemStack backpack = ItemBackpack.getBackpack(carrier);
        if (backpack == null) {
            return null;
        }
        return ((ItemBackpack)backpack.func_77973_b()).getBackpackItemsInternal(carrier, player);
    }

    public static IInventory getBackpackItems(EntityLivingBase carrier) {
        return ItemBackpack.getBackpackItems(carrier, null);
    }

    public static void initBackpackData(EntityLivingBase entity) {
        EntityUtils.createProperties((Entity)entity, PropertiesBackpack.class);
    }

    public static PropertiesBackpack getBackpackData(EntityLivingBase entity) {
        PropertiesBackpack backpackData = EntityUtils.getOrCreateProperties((Entity)entity, PropertiesBackpack.class);
        if (!backpackData.initialized) {
            ItemBackpack.updateHasItems(entity, backpackData);
            backpackData.initialized = true;
        }
        return backpackData;
    }

    public static void updateHasItems(EntityLivingBase entity, PropertiesBackpack backpackData) {
        boolean hasItems;
        if (entity.field_70170_p.field_72995_K || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        boolean bl = hasItems = backpackData.contents != null && !StackUtils.isEmpty(backpackData.contents);
        if (backpackData.hasItems == hasItems) {
            return;
        }
        Packet packet = PacketHandler.makePacket((byte)2, hasItems);
        PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)((Player)player));
        backpackData.hasItems = hasItems;
    }

    public static boolean isBackpackOpen(EntityLivingBase entity) {
        return ItemBackpack.getBackpackData((EntityLivingBase)entity).playersUsing > 0;
    }

    public static boolean openBackpack(EntityPlayer player, EntityLivingBase carrier) {
        ItemStack backpack = ItemBackpack.getBackpack(carrier);
        if (backpack == null) {
            return false;
        }
        ItemBackpack backpackType = (ItemBackpack)backpack.func_77973_b();
        IInventory inventory = ItemBackpack.getBackpackItems(carrier, player);
        if (!(inventory = new InventoryBackpackEquipped(carrier, player, inventory)).func_70300_a(player)) {
            return false;
        }
        int columns = backpackType.getBackpackColumns();
        int rows = backpackType.getBackpackRows();
        ContainerBetterStorage container = new ContainerBetterStorage(player, inventory, columns, rows);
        String title = StackUtils.get(backpack, "", "display", "Name");
        PlayerUtils.openGui(player, inventory.func_70303_b(), columns, rows, title, container);
        return true;
    }

    public static boolean onPlaceBackpack(EntityPlayer player, int x, int y, int z, int side) {
        if (player.func_71045_bC() != null || !player.func_70093_af()) {
            return false;
        }
        ItemStack backpack = ItemBackpack.getBackpack((EntityLivingBase)player);
        if (backpack == null) {
            return false;
        }
        boolean hasChestplateBackpack = ItemBackpack.hasChestplateBackpackEquipped((EntityLivingBase)player);
        boolean success = false;
        if (!ItemBackpack.isBackpackOpen((EntityLivingBase)player)) {
            success = backpack.func_77973_b().func_77648_a(backpack, player, player.field_70170_p, x, y, z, side, 0.0f, 0.0f, 0.0f);
            if (backpack.field_77994_a <= 0) {
                ItemBackpack.setBackpack((EntityLivingBase)player, null, null);
                backpack = null;
            }
        }
        if (!player.field_70170_p.field_72995_K) {
            PacketDispatcher.sendPacketToPlayer((Packet)(hasChestplateBackpack ? new Packet103SetSlot(0, 6, backpack) : PacketHandler.makePacket((byte)9, player.field_70157_k, backpack)), (Player)((Player)player));
        }
        if (success) {
            player.func_71038_i();
        }
        return success;
    }

    public static boolean placeBackpack(EntityLivingBase carrier, EntityPlayer player, ItemStack backpack, int x, int y, int z, int side, ForgeDirection orientation, boolean despawn, boolean deathDrop) {
        if (backpack.field_77994_a == 0) {
            return false;
        }
        World world = carrier.field_70170_p;
        Block blockBackpack = Block.field_71973_m[backpack.field_77993_c];
        if (y <= 0 || y >= world.func_72800_K() - 1) {
            return false;
        }
        if (!WorldUtils.isBlockReplacable(world, x, y, z)) {
            if (side != 1) {
                return false;
            }
            ++y;
        }
        Block blockBelow = Block.field_71973_m[world.func_72798_a(x, y - 1, z)];
        if (deathDrop ? WorldUtils.isBlockReplacable(blockBelow, world, x, y - 1, z) : blockBelow == null || !blockBelow.isBlockSolidOnSide(world, x, y - 1, z, ForgeDirection.UP)) {
            return false;
        }
        if (!world.func_72931_a(blockBackpack.field_71990_ca, x, y, z, deathDrop, side, (Entity)carrier, backpack)) {
            return false;
        }
        if (!(player == null || world.func_72962_a(player, x, y, z) && player.func_82247_a(x, y, z, side, backpack))) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        if (!world.func_72832_d(x, y, z, blockBackpack.field_71990_ca, orientation.ordinal(), 3)) {
            return false;
        }
        if (world.func_72798_a(x, y, z) != blockBackpack.field_71990_ca) {
            return false;
        }
        blockBackpack.func_71860_a(world, x, y, z, carrier, backpack);
        blockBackpack.func_85105_g(world, x, y, z, orientation.ordinal());
        TileEntityBackpack te = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityBackpack.class);
        te.stack = backpack.func_77946_l();
        if (ItemBackpack.getBackpack(carrier) == backpack) {
            te.unequip(carrier, despawn);
        }
        String sound = blockBackpack.field_72020_cn.func_82593_b();
        float volume = (blockBackpack.field_72020_cn.func_72677_b() + 1.0f) / 2.0f;
        float pitch = blockBackpack.field_72020_cn.func_72678_c() * 0.8f;
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)((float)z + 0.5f), sound, volume, pitch);
        --backpack.field_77994_a;
        return true;
    }

    static {
        ItemBackpack.material.customCraftingMaterial = Item.field_77770_aF;
        immuneToDamageType = new String[]{"inWall", "drown", "starve", "cactus", "fall", "outOfWorld", "generic", "wither", "anvil", "fallingBlock", "thrown"};
    }
}

