/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.client.model.ModelDrinkingHelmet;
import net.mcft.copy.betterstorage.item.ItemArmorBetterStorage;
import net.mcft.copy.betterstorage.misc.Resources;
import net.mcft.copy.betterstorage.misc.SmallPotionEffect;
import net.mcft.copy.betterstorage.misc.handlers.KeyBindingHandler;
import net.mcft.copy.betterstorage.utils.LanguageUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Icon;
import net.minecraftforge.common.EnumHelper;

public class ItemDrinkingHelmet
extends ItemArmorBetterStorage {
    private Icon iconPotions;
    public static final int maxUses = 12;
    public static final EnumArmorMaterial material = EnumHelper.addArmorMaterial((String)"drinkingHelmet", (int)11, (int[])new int[]{3, 0, 0, 0}, (int)15);

    public ItemDrinkingHelmet(int id) {
        super(id - 256, material, 0, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("betterstorage:" + this.getItemName());
        this.iconPotions = iconRegister.func_94245_a("betterstorage:" + this.getItemName() + "_potions");
    }

    public Icon getIcon(ItemStack stack, int pass) {
        return StackUtils.get(stack, 0, "uses") > 0 ? this.iconPotions : this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77650_f(ItemStack stack) {
        return this.getIcon(stack, 0);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return Resources.textureDrinkingHelmet.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entity, ItemStack stack, int slot) {
        return ModelDrinkingHelmet.instance;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return StackUtils.has(stack, "display", "Lore") ? EnumRarity.epic : EnumRarity.rare;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        int uses = StackUtils.get(stack, 0, "uses");
        if (uses > 0 && ItemDrinkingHelmet.getDrinkingHelmet((EntityLivingBase)player) == stack) {
            String str = GameSettings.func_74298_c((int)KeyBindingHandler.drinkingHelmet.field_74512_d);
            LanguageUtils.translateTooltip(list, "drinkingHelmet.useHint", "%KEY%", str);
        }
        for (ItemStack potion : ItemDrinkingHelmet.getPotions(stack)) {
            if (potion == null) continue;
            String name = potion.func_82833_r();
            if (list.size() > 0 && list.get(list.size() - 1).equals(EnumChatFormatting.DARK_AQUA + name)) {
                list.set(list.size() - 1, EnumChatFormatting.DARK_AQUA + "2x " + name);
                continue;
            }
            list.add(EnumChatFormatting.DARK_AQUA + name);
        }
        if (uses > 0) {
            list.add(EnumChatFormatting.DARK_GRAY.toString() + EnumChatFormatting.ITALIC + LanguageUtils.translateTooltip("drinkingHelmet.uses", "%USES%", Integer.toString(uses)));
        } else if (BetterStorage.globalConfig.getBoolean("settings.enableHelpTooltips")) {
            list.add(LanguageUtils.translateTooltip("drinkingHelmet.craftHint", new String[0]));
        }
    }

    public static ItemStack[] getPotions(ItemStack drinkingHelmet) {
        return StackUtils.getStackContents(drinkingHelmet, 2);
    }

    public static void setPotions(ItemStack drinkingHelmet, ItemStack[] potions) {
        if (potions != null) {
            StackUtils.setStackContents(drinkingHelmet, potions);
            StackUtils.set(drinkingHelmet, 12, "uses");
        } else {
            StackUtils.remove(drinkingHelmet, "Items");
            StackUtils.remove(drinkingHelmet, "uses");
        }
    }

    public static ItemStack getDrinkingHelmet(EntityLivingBase entity) {
        ItemStack drinkingHelmet = entity.func_71124_b(4);
        if (drinkingHelmet != null && drinkingHelmet.func_77973_b() instanceof ItemDrinkingHelmet) {
            return drinkingHelmet;
        }
        return null;
    }

    public static void use(EntityPlayer player) {
        ItemStack drinkingHelmet = ItemDrinkingHelmet.getDrinkingHelmet((EntityLivingBase)player);
        if (drinkingHelmet == null) {
            return;
        }
        int uses = StackUtils.get(drinkingHelmet, 0, "uses");
        if (uses <= 0) {
            return;
        }
        ItemStack[] potions = StackUtils.getStackContents(drinkingHelmet, 2);
        ArrayList potionEffects = new ArrayList();
        for (ItemStack item : potions) {
            List effects;
            if (!(item.func_77973_b() instanceof ItemPotion) || (effects = ((ItemPotion)item.func_77973_b()).func_77832_l(item)) == null) continue;
            potionEffects.addAll(effects);
        }
        for (PotionEffect effect : potionEffects) {
            Potion potion = Potion.field_76425_a[(effect = new SmallPotionEffect(effect)).func_76456_a()];
            PotionEffect active = player.func_70660_b(potion);
            if (active != null) {
                effect.field_76460_b += active.field_76460_b;
            }
            player.func_70690_d(effect);
        }
        player.field_70170_p.func_72956_a((Entity)player, "random.drink", 0.5f, 0.9f + player.field_70170_p.field_73012_v.nextFloat() * 0.1f);
        if (--uses <= 0) {
            ItemDrinkingHelmet.setPotions(drinkingHelmet, null);
        } else {
            StackUtils.set(drinkingHelmet, uses, "uses");
        }
    }

    static {
        ItemDrinkingHelmet.material.customCraftingMaterial = Item.field_77698_e[Block.field_94341_cq.field_71990_ca];
    }
}

