/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item.cardboard;

import java.util.Collection;
import java.util.Map;
import net.mcft.copy.betterstorage.api.crafting.IRecipeInput;
import net.mcft.copy.betterstorage.api.crafting.IStationRecipe;
import net.mcft.copy.betterstorage.api.crafting.RecipeInputItemStack;
import net.mcft.copy.betterstorage.api.crafting.StationCrafting;
import net.mcft.copy.betterstorage.item.cardboard.CardboardRecipeHelper;
import net.mcft.copy.betterstorage.item.cardboard.ICardboardItem;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CardboardEnchantmentRecipe
implements IStationRecipe {
    @Override
    public StationCrafting checkMatch(ItemStack[] input) {
        boolean hasCardboardItems = false;
        int bookIndex = -1;
        ItemStack book = null;
        for (int i = 0; i < input.length; ++i) {
            ItemStack stack = input[i];
            if (stack == null) continue;
            if (stack.func_77973_b() instanceof ICardboardItem) {
                hasCardboardItems = true;
                continue;
            }
            if (book == null && stack.func_77973_b() == Item.field_92105_bW) {
                bookIndex = i;
                book = stack;
                continue;
            }
            return null;
        }
        if (book == null || !hasCardboardItems) {
            return null;
        }
        ItemStack[] output = new ItemStack[9];
        int experienceCost = 0;
        IRecipeInput[] requiredInput = new IRecipeInput[9];
        Collection<StackUtils.StackEnchantment> bookEnchantments = StackUtils.getEnchantments(book).values();
        for (int i = 0; i < input.length; ++i) {
            ItemStack stack = input[i];
            if (stack == null || !(stack.func_77973_b() instanceof ICardboardItem)) continue;
            ItemStack outputStack = stack.func_77946_l();
            boolean canApply = false;
            Map<Integer, StackUtils.StackEnchantment> stackEnchants = StackUtils.getEnchantments(outputStack);
            int numEnchants = stackEnchants.size();
            for (StackUtils.StackEnchantment bookEnch : bookEnchantments) {
                if (!StackUtils.isEnchantmentCompatible(outputStack, stackEnchants.values(), bookEnch)) continue;
                StackUtils.StackEnchantment stackEnch = stackEnchants.get(bookEnch.ench.field_77352_x);
                int level = bookEnch.getLevel() - (stackEnch != null ? stackEnch.getLevel() : 0);
                experienceCost += this.calculateCost(bookEnch, stackEnch == null, numEnchants);
                if (stackEnch != null) {
                    stackEnch.setLevel(bookEnch.getLevel());
                } else {
                    outputStack.func_77966_a(bookEnch.ench, bookEnch.getLevel());
                }
                canApply = true;
            }
            if (!canApply) {
                return null;
            }
            output[i] = outputStack;
            requiredInput[i] = new RecipeInputItemStack(StackUtils.copyStack(stack, 1), true);
        }
        requiredInput[bookIndex] = new RecipeInputItemStack(StackUtils.copyStack(book, 0, false));
        return new StationCrafting(output, requiredInput, experienceCost);
    }

    private int calculateCost(StackUtils.StackEnchantment ench, boolean hasEnchantment, int numEnchants) {
        int weight = ench.ench.func_77324_c();
        int costPerLevel = weight > 8 ? 1 : (weight > 6 ? 2 : (weight > 3 ? 3 : (weight > 1 ? 4 : 6)));
        int cost = costPerLevel * ench.getLevel() - 1;
        cost += CardboardRecipeHelper.getAdditionalEnchantmentCost(ench);
        if (hasEnchantment) {
            cost += (numEnchants + 1) / 2;
        }
        return cost;
    }
}

