/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item.locking;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.api.IContainerItem;
import net.mcft.copy.betterstorage.api.lock.IKey;
import net.mcft.copy.betterstorage.container.ContainerKeyring;
import net.mcft.copy.betterstorage.item.ItemBetterStorage;
import net.mcft.copy.betterstorage.utils.PlayerUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class ItemKeyring
extends ItemBetterStorage
implements IKey,
IContainerItem {
    private Icon[] icons = new Icon[4];

    public ItemKeyring(int id) {
        super(id);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("betterstorage:keyring_" + i);
        }
        this.field_77791_bV = this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77617_a(int damage) {
        return this.icons[Math.min(damage, this.icons.length - 1)];
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K || !player.func_70093_af()) {
            return stack;
        }
        String title = StackUtils.get(stack, "", "display", "Name");
        int protectedSlot = player.field_71071_by.field_70461_c;
        ContainerKeyring container = new ContainerKeyring(player, title, protectedSlot);
        PlayerUtils.openGui(player, "container.betterstorage.keyring", protectedSlot, 1, title, container);
        return stack;
    }

    @Override
    public boolean isNormalKey() {
        return false;
    }

    @Override
    public boolean unlock(ItemStack keyring, ItemStack lock, boolean useAbility) {
        ItemStack[] items;
        for (ItemStack key : items = StackUtils.getStackContents(keyring, 9)) {
            IKey keyType;
            if (key == null || !(keyType = (IKey)key.func_77973_b()).unlock(key, lock, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canApplyEnchantment(ItemStack key, Enchantment enchantment) {
        return false;
    }

    @Override
    public ItemStack[] getContainerItemContents(ItemStack container) {
        return StackUtils.getStackContents(container, 9);
    }

    @Override
    public boolean canBeStoredInContainerItem(ItemStack item) {
        return true;
    }
}

