/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item.recipe;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.api.crafting.ICraftingSource;
import net.mcft.copy.betterstorage.api.crafting.IRecipeInput;
import net.mcft.copy.betterstorage.api.crafting.RecipeInputBase;
import net.mcft.copy.betterstorage.api.crafting.StationCrafting;
import net.mcft.copy.betterstorage.config.GlobalConfig;
import net.mcft.copy.betterstorage.inventory.InventoryCraftingStation;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class VanillaStationCrafting
extends StationCrafting {
    private final boolean onCreatedOverridden;
    private static Map<Class, Boolean> isOverriddenMap = new HashMap<Class, Boolean>();

    public VanillaStationCrafting(World world, IRecipe recipe, ItemStack[] input, ItemStack output) {
        super(new ItemStack[]{null, null, null, null, output}, VanillaStationCrafting.createRecipeInput(world, recipe, input));
        this.onCreatedOverridden = (Boolean)GlobalConfig.enableStationAutoCraftingSetting.getValue() != false ? VanillaStationCrafting.isOnCreatedOverridden(output) : false;
    }

    private static IRecipeInput[] createRecipeInput(World world, IRecipe recipe, ItemStack[] input) {
        IRecipeInput[] requiredInput = new IRecipeInput[9];
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == null) continue;
            requiredInput[i] = new VanillaRecipeInput(world, recipe, input, i);
        }
        return requiredInput;
    }

    @Override
    public boolean canCraft(ICraftingSource source) {
        return source.getPlayer() != null || !this.onCreatedOverridden;
    }

    private static boolean isOnCreatedOverridden(ItemStack output) {
        Class<?> itemClass = output.func_77973_b().getClass();
        Boolean overridden = isOverriddenMap.get(itemClass);
        if (overridden != null) {
            return overridden;
        }
        for (String name : new String[]{"onCreated", "func_77622_d"}) {
            try {
                Method onCreatedMethod = itemClass.getMethod(name, ItemStack.class, World.class, EntityPlayer.class);
                overridden = onCreatedMethod.getDeclaringClass() != Item.class;
                break;
            }
            catch (NoSuchMethodException e) {
            }
            catch (Throwable e) {
                BetterStorage.log.severe("Failed to check if onCreated is overridden for " + itemClass.getName() + ".");
                BetterStorage.log.severe("Please report this to the author who made the mod this item is from.");
                BetterStorage.log.severe("Tell them to contact copygirl if anything is unclear. Thanks!");
                e.printStackTrace();
                overridden = true;
                break;
            }
        }
        if (overridden == null) {
            throw new Error("The item's onCreated method could not be found.");
        }
        isOverriddenMap.put(itemClass, overridden);
        return overridden;
    }

    public static VanillaStationCrafting findVanillaRecipe(InventoryCraftingStation inv) {
        World world = inv.entity != null ? inv.entity.field_70331_k : VanillaStationCrafting.getClientWorld();
        InventoryCrafting crafting = new InventoryCrafting(null, 3, 3);
        crafting.field_70466_a = inv.crafting;
        IRecipe recipe = VanillaStationCrafting.findRecipe(crafting, world);
        if (recipe == null) {
            return null;
        }
        return new VanillaStationCrafting(world, recipe, inv.crafting, recipe.func_77572_b(crafting));
    }

    @SideOnly(value=Side.CLIENT)
    private static World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    private static IRecipe findRecipe(InventoryCrafting crafting, World world) {
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (!recipe.func_77569_a(crafting, world)) continue;
            return recipe;
        }
        return null;
    }

    private static class VanillaRecipeInput
    extends RecipeInputBase {
        private final World world;
        private final IRecipe recipe;
        private final int slot;
        private final InventoryCrafting crafting;
        private final ItemStack expectedOutput;

        public VanillaRecipeInput(World world, IRecipe recipe, ItemStack[] input, int slot) {
            this.world = world;
            this.recipe = recipe;
            this.slot = slot;
            ItemStack[] craftingStacks = new ItemStack[input.length];
            for (int i = 0; i < input.length; ++i) {
                craftingStacks[i] = ItemStack.func_77944_b((ItemStack)input[i]);
            }
            this.crafting = new InventoryCrafting(null, 3, 3);
            this.crafting.field_70466_a = craftingStacks;
            this.expectedOutput = recipe.func_77572_b(this.crafting).func_77946_l();
        }

        @Override
        public int getAmount() {
            return 1;
        }

        @Override
        public boolean matches(ItemStack stack) {
            ItemStack stackBefore = this.crafting.field_70466_a[this.slot];
            this.crafting.field_70466_a[this.slot] = stack;
            boolean matches = this.recipe.func_77569_a(this.crafting, this.world) && StackUtils.matches(this.expectedOutput, this.recipe.func_77572_b(this.crafting));
            this.crafting.field_70466_a[this.slot] = stackBefore;
            return matches;
        }
    }
}

