/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.misc;

import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemIdentifier {
    private final int id;
    private final int damage;
    private final NBTTagCompound data;

    public ItemIdentifier(int id, int damage, NBTTagCompound data) {
        this.id = id;
        this.damage = damage;
        this.data = data;
    }

    public ItemIdentifier(ItemStack stack) {
        this(stack.field_77993_c, stack.func_77960_j(), stack.func_77942_o() ? (NBTTagCompound)stack.func_77978_p().func_74737_b() : null);
    }

    public Item getItem() {
        return Item.field_77698_e[this.id];
    }

    public ItemStack createStack(int size) {
        ItemStack stack = new ItemStack(this.id, size, this.damage);
        if (this.data != null) {
            stack.field_77990_d = (NBTTagCompound)this.data.func_74737_b();
        }
        return stack;
    }

    public boolean matches(int id, int damage, NBTTagCompound data) {
        return StackUtils.matches(this.id, this.damage, this.data, id, damage, data);
    }

    public boolean matches(ItemStack stack) {
        return this.matches(stack.field_77993_c, stack.func_77960_j(), stack.field_77990_d);
    }

    public int hashCode() {
        return this.id << 16 ^ this.damage;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ItemIdentifier)) {
            return false;
        }
        ItemIdentifier other = (ItemIdentifier)obj;
        return this.matches(other.id, other.damage, other.data);
    }

    public String toString() {
        return this.getItem().func_77635_s() + ":" + this.damage;
    }
}

