/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.misc;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import net.mcft.copy.betterstorage.misc.handlers.PacketHandler;
import net.mcft.copy.betterstorage.utils.NbtUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class PropertiesBackpack
implements IExtendedEntityProperties {
    public static final String identifier = "betterstorage.backpack";
    public ItemStack backpack = null;
    public ItemStack[] contents = null;
    public boolean initialized = false;
    public boolean spawnsWithBackpack = false;
    public int playersUsing = 0;
    public boolean hasItems = false;
    public float lidAngle = 0.0f;
    public float prevLidAngle = 0.0f;
    private ItemStack prevBackpack = null;
    private int prevPlayersUsing = 0;

    public void init(Entity entity, World world) {
    }

    public void saveNBTData(NBTTagCompound compound) {
        if (this.contents == null) {
            return;
        }
        NBTTagCompound backpackCompound = new NBTTagCompound();
        backpackCompound.func_74768_a("count", this.contents.length);
        backpackCompound.func_74782_a("Items", (NBTBase)NbtUtils.writeItems(this.contents));
        if (this.backpack != null) {
            backpackCompound.func_74766_a("Stack", this.backpack.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74782_a("Backpack", (NBTBase)backpackCompound);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.backpack = null;
        this.contents = null;
        if (compound.func_74764_b("Backpack")) {
            NBTTagCompound backpackCompound = compound.func_74775_l("Backpack");
            this.backpack = ItemStack.func_77949_a((NBTTagCompound)backpackCompound.func_74775_l("Stack"));
            this.contents = new ItemStack[backpackCompound.func_74762_e("count")];
            NbtUtils.readItems(this.contents, backpackCompound.func_74761_m("Items"));
        }
    }

    public void update(EntityLivingBase entity) {
        this.prevLidAngle = this.lidAngle;
        float lidSpeed = 0.2f;
        this.lidAngle = this.playersUsing > 0 ? Math.min(1.0f, this.lidAngle + lidSpeed) : Math.max(0.0f, this.lidAngle - lidSpeed);
        if (!entity.field_70170_p.field_72995_K) {
            Packet packet;
            boolean isOpen;
            String sound = Block.field_82509_m.func_72675_d();
            if (this.lidAngle > 0.0f && this.prevLidAngle <= 0.0f) {
                entity.field_70170_p.func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, sound, 1.0f, 0.6f);
            }
            if (this.lidAngle < 0.2f && this.prevLidAngle >= 0.2f) {
                entity.field_70170_p.func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, sound, 0.8f, 0.4f);
            }
            if ((isOpen = this.playersUsing > 0) != this.prevPlayersUsing > 0) {
                packet = PacketHandler.makePacket((byte)8, entity.field_70157_k, isOpen);
                PacketHandler.sendToEveryoneTracking((Entity)entity, packet);
                this.prevPlayersUsing = this.playersUsing;
            }
            if (!ItemStack.func_77989_b((ItemStack)this.backpack, (ItemStack)this.prevBackpack)) {
                packet = PacketHandler.makePacket((byte)9, entity.field_70157_k, this.backpack);
                PacketHandler.sendToEveryoneTracking((Entity)entity, packet);
                this.prevBackpack = ItemStack.func_77944_b((ItemStack)this.backpack);
            }
        }
    }

    public void sendDataToPlayer(EntityLivingBase entity, EntityPlayer player) {
        Packet packet;
        if (this.playersUsing > 0) {
            packet = PacketHandler.makePacket((byte)8, entity.field_70157_k, true);
            PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)((Player)player));
        }
        if (this.backpack != null) {
            packet = PacketHandler.makePacket((byte)9, entity.field_70157_k, this.backpack);
            PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)((Player)player));
        }
    }
}

