/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.misc;

import cpw.mods.fml.common.registry.GameRegistry;
import net.mcft.copy.betterstorage.addon.Addon;
import net.mcft.copy.betterstorage.api.crafting.BetterStorageCrafting;
import net.mcft.copy.betterstorage.content.Items;
import net.mcft.copy.betterstorage.content.Tiles;
import net.mcft.copy.betterstorage.item.cardboard.CardboardEnchantmentRecipe;
import net.mcft.copy.betterstorage.item.cardboard.CardboardRepairRecipe;
import net.mcft.copy.betterstorage.item.recipe.DrinkingHelmetRecipe;
import net.mcft.copy.betterstorage.item.recipe.DyeRecipe;
import net.mcft.copy.betterstorage.item.recipe.KeyRecipe;
import net.mcft.copy.betterstorage.item.recipe.LockColorRecipe;
import net.mcft.copy.betterstorage.item.recipe.LockRecipe;
import net.mcft.copy.betterstorage.tile.ContainerMaterial;
import net.mcft.copy.betterstorage.utils.MiscUtils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;

public final class Recipes {
    private Recipes() {
    }

    public static void add() {
        Recipes.registerRecipeSorter();
        Recipes.addTileRecipes();
        Recipes.addItemRecipes();
        Recipes.addCardboardRecipes();
        GameRegistry.addRecipe((IRecipe)new DyeRecipe());
        Addon.addRecipesAll();
    }

    private static void registerRecipeSorter() {
        RecipeSorter.register((String)"betterstorage:drinkinghelmetrecipe", DrinkingHelmetRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        RecipeSorter.register((String)"betterstorage:keyrecipe", KeyRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        RecipeSorter.register((String)"betterstorage:lockrecipe", LockRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        RecipeSorter.register((String)"betterstorage:dyerecipe", DyeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        RecipeSorter.register((String)"betterstorage:lockcolorrecipe", LockColorRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
    }

    private static void addTileRecipes() {
        ShapedOreRecipe recipe;
        if (MiscUtils.isEnabled(new Object[]{Tiles.crate})) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)Tiles.crate), new Object[]{"o/o", "/ /", "o/o", Character.valueOf('o'), "plankWood", Character.valueOf('/'), "stickWood"}));
        }
        if (MiscUtils.isEnabled(new Object[]{Tiles.reinforcedChest})) {
            for (ContainerMaterial material : ContainerMaterial.getMaterials()) {
                recipe = material.getReinforcedRecipe((Block)Block.field_72077_au, Tiles.reinforcedChest);
                if (recipe == null) continue;
                GameRegistry.addRecipe((IRecipe)recipe);
            }
        }
        if (MiscUtils.isEnabled(new Object[]{Tiles.locker})) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)Tiles.locker), new Object[]{"ooo", "o |", "ooo", Character.valueOf('o'), "plankWood", Character.valueOf('|'), Block.field_72005_bk}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)Tiles.locker), new Object[]{"ooo", "| o", "ooo", Character.valueOf('o'), "plankWood", Character.valueOf('|'), Block.field_72005_bk}));
            if (MiscUtils.isEnabled(new Object[]{Tiles.reinforcedLocker})) {
                for (ContainerMaterial material : ContainerMaterial.getMaterials()) {
                    recipe = material.getReinforcedRecipe(Tiles.locker, Tiles.reinforcedLocker);
                    if (recipe == null) continue;
                    GameRegistry.addRecipe((IRecipe)recipe);
                }
            }
        }
        if (MiscUtils.isEnabled(new Object[]{Tiles.armorStand})) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)Tiles.armorStand), (Object[])new Object[]{" i ", "/i/", " s ", Character.valueOf('s'), new ItemStack((Block)Block.field_72079_ak, 1, 0), Character.valueOf('i'), Item.field_77703_o, Character.valueOf('/'), Item.field_77669_D});
        }
        if (MiscUtils.isEnabled(new Object[]{Tiles.backpack})) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)Tiles.backpack), (Object[])new Object[]{"#i#", "#O#", "###", Character.valueOf('#'), Item.field_77770_aF, Character.valueOf('O'), Block.field_72101_ab, Character.valueOf('i'), Item.field_77717_p});
        }
        if (MiscUtils.isEnabled(new Object[]{Tiles.cardboardBox, Items.cardboardSheet})) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)Tiles.cardboardBox), new Object[]{"ooo", "o o", "ooo", Character.valueOf('o'), "sheetCardboard"}));
        }
        if (MiscUtils.isEnabled(new Object[]{Tiles.craftingStation})) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)Tiles.craftingStation), new Object[]{"B-B", "PTP", "WCW", Character.valueOf('B'), Block.field_72007_bm, Character.valueOf('-'), Block.field_94348_cl, Character.valueOf('P'), Block.field_71963_Z, Character.valueOf('T'), Block.field_72060_ay, Character.valueOf('W'), "plankWood", Character.valueOf('C'), MiscUtils.isEnabled(new Object[]{Tiles.crate}) ? Tiles.crate : Block.field_72077_au}));
        }
        if (MiscUtils.isEnabled(new Object[]{Tiles.flintBlock})) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)Tiles.flintBlock), (Object[])new Object[]{"ooo", "ooo", "ooo", Character.valueOf('o'), Item.field_77804_ap});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Item.field_77804_ap, 9), (Object[])new Object[]{Tiles.flintBlock});
        }
    }

    private static void addItemRecipes() {
        if (MiscUtils.isEnabled(Items.key)) {
            GameRegistry.addRecipe((IRecipe)KeyRecipe.createKeyRecipe(".o", ".o", " o", Character.valueOf('o'), Item.field_77717_p, Character.valueOf('.'), Item.field_77733_bq));
            GameRegistry.addRecipe((IRecipe)KeyRecipe.createKeyRecipe("k", Character.valueOf('k'), new ItemStack((Item)Items.key, 1, Short.MAX_VALUE)));
        }
        if (MiscUtils.isEnabled(Items.lock)) {
            if (MiscUtils.isEnabled(Items.key)) {
                GameRegistry.addRecipe((IRecipe)LockRecipe.createLockRecipe());
            }
            GameRegistry.addRecipe((IRecipe)LockColorRecipe.createLockColorRecipe());
        }
        if (MiscUtils.isEnabled(Items.keyring)) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)Items.keyring), (Object[])new Object[]{"...", ". .", "...", Character.valueOf('.'), Item.field_77733_bq});
        }
        if (MiscUtils.isEnabled(new Object[]{Items.drinkingHelmet})) {
            GameRegistry.addRecipe((IRecipe)new DrinkingHelmetRecipe((Item)Items.drinkingHelmet));
        }
    }

    private static void addCardboardRecipes() {
        if (MiscUtils.isEnabled(new Object[]{Items.cardboardSheet})) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)Items.cardboardSheet, 4), (Object[])new Object[]{Item.field_77759_aK, Item.field_77759_aK, Item.field_77759_aK, Item.field_77759_aK, Item.field_77759_aK, Item.field_77759_aK, Item.field_77759_aK, Item.field_77759_aK, Item.field_77761_aM});
        }
        if (MiscUtils.isEnabled(Items.cardboardHelmet)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Items.cardboardHelmet), new Object[]{"ooo", "o o", Character.valueOf('o'), "sheetCardboard"}));
        }
        if (MiscUtils.isEnabled(Items.cardboardChestplate)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Items.cardboardChestplate), new Object[]{"o o", "ooo", "ooo", Character.valueOf('o'), "sheetCardboard"}));
        }
        if (MiscUtils.isEnabled(Items.cardboardLeggings)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Items.cardboardLeggings), new Object[]{"ooo", "o o", "o o", Character.valueOf('o'), "sheetCardboard"}));
        }
        if (MiscUtils.isEnabled(Items.cardboardBoots)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Items.cardboardBoots), new Object[]{"o o", "o o", Character.valueOf('o'), "sheetCardboard"}));
        }
        if (MiscUtils.isEnabled(Items.cardboardSword)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Items.cardboardSword), new Object[]{"o", "o", "/", Character.valueOf('o'), "sheetCardboard", Character.valueOf('/'), Item.field_77669_D}));
        }
        if (MiscUtils.isEnabled(Items.cardboardPickaxe)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Items.cardboardPickaxe), new Object[]{"ooo", " / ", " / ", Character.valueOf('o'), "sheetCardboard", Character.valueOf('/'), Item.field_77669_D}));
        }
        if (MiscUtils.isEnabled(Items.cardboardShovel)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Items.cardboardShovel), new Object[]{"o", "/", "/", Character.valueOf('o'), "sheetCardboard", Character.valueOf('/'), Item.field_77669_D}));
        }
        if (MiscUtils.isEnabled(Items.cardboardAxe)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Items.cardboardAxe), new Object[]{"oo", "o/", " /", Character.valueOf('o'), "sheetCardboard", Character.valueOf('/'), Item.field_77669_D}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Items.cardboardAxe), new Object[]{"oo", "/o", "/ ", Character.valueOf('o'), "sheetCardboard", Character.valueOf('/'), Item.field_77669_D}));
        }
        if (MiscUtils.isEnabled(Items.cardboardHoe)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Items.cardboardHoe), new Object[]{"oo", " /", " /", Character.valueOf('o'), "sheetCardboard", Character.valueOf('/'), Item.field_77669_D}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Items.cardboardHoe), new Object[]{"oo", "/ ", "/ ", Character.valueOf('o'), "sheetCardboard", Character.valueOf('/'), Item.field_77669_D}));
        }
        BetterStorageCrafting.addStationRecipe(new CardboardEnchantmentRecipe());
        if (MiscUtils.isEnabled(new Object[]{Items.cardboardSheet})) {
            BetterStorageCrafting.addStationRecipe(new CardboardRepairRecipe());
        }
    }
}

