/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.misc.handlers;

import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.api.BetterStorageBackpack;
import net.mcft.copy.betterstorage.content.Tiles;
import net.mcft.copy.betterstorage.entity.EntityFrienderman;
import net.mcft.copy.betterstorage.inventory.InventoryStacks;
import net.mcft.copy.betterstorage.item.ItemBackpack;
import net.mcft.copy.betterstorage.item.ItemEnderBackpack;
import net.mcft.copy.betterstorage.misc.PropertiesBackpack;
import net.mcft.copy.betterstorage.misc.handlers.PacketHandler;
import net.mcft.copy.betterstorage.tile.TileEnderBackpack;
import net.mcft.copy.betterstorage.utils.DirectionUtils;
import net.mcft.copy.betterstorage.utils.EntityUtils;
import net.mcft.copy.betterstorage.utils.MiscUtils;
import net.mcft.copy.betterstorage.utils.NbtUtils;
import net.mcft.copy.betterstorage.utils.RandomUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class BackpackHandler
implements IPlayerTracker {
    private static final WeightedRandomChestContent[] randomBackpackItems = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Item.field_77669_D.field_77779_bT, 0, 8, 20, 100), new WeightedRandomChestContent(Block.field_71988_x.field_71990_ca, 0, 2, 10, 100), new WeightedRandomChestContent(Block.field_71951_J.field_71990_ca, 0, 1, 8, 40), new WeightedRandomChestContent(Block.field_71978_w.field_71990_ca, 0, 6, 16, 80), new WeightedRandomChestContent(Item.field_77713_t.field_77779_bT, 50, 1, 1, 35), new WeightedRandomChestContent(Item.field_77713_t.field_77779_bT, 20, 1, 1, 10), new WeightedRandomChestContent(Item.field_77720_x.field_77779_bT, 120, 1, 1, 10), new WeightedRandomChestContent(Item.field_77720_x.field_77779_bT, 80, 1, 1, 5), new WeightedRandomChestContent(Item.field_77696_g.field_77779_bT, 220, 1, 1, 2), new WeightedRandomChestContent(Item.field_77715_r.field_77779_bT, 40, 1, 1, 30), new WeightedRandomChestContent(Item.field_77711_v.field_77779_bT, 60, 1, 1, 5), new WeightedRandomChestContent(Item.field_77707_k.field_77779_bT, 200, 1, 1, 10), new WeightedRandomChestContent(Item.field_77707_k.field_77779_bT, 50, 1, 1, 3), new WeightedRandomChestContent(Item.field_77749_aR.field_77779_bT, 20, 1, 1, 4), new WeightedRandomChestContent(Item.field_77750_aQ.field_77779_bT, 0, 1, 1, 6), new WeightedRandomChestContent(Item.field_77752_aS.field_77779_bT, 0, 1, 1, 5), new WeightedRandomChestContent(Block.field_72069_aq.field_71990_ca, 0, 6, 24, 30), new WeightedRandomChestContent(Item.field_77704_l.field_77779_bT, 0, 2, 12, 10), new WeightedRandomChestContent(Item.field_77737_bm.field_77779_bT, 0, 3, 6, 15), new WeightedRandomChestContent(Item.field_77755_aX.field_77779_bT, 0, 2, 5, 20), new WeightedRandomChestContent(Item.field_77683_K.field_77779_bT, 0, 3, 10, 15), new WeightedRandomChestContent(Item.field_77706_j.field_77779_bT, 0, 2, 5, 15), new WeightedRandomChestContent(Item.field_77684_U.field_77779_bT, 0, 2, 4, 10), new WeightedRandomChestContent(Item.field_77685_T.field_77779_bT, 0, 3, 6, 10), new WeightedRandomChestContent(Item.field_82797_bK.field_77779_bT, 0, 1, 2, 8), new WeightedRandomChestContent(Item.field_82794_bL.field_77779_bT, 0, 1, 2, 5), new WeightedRandomChestContent(Item.field_77754_aU.field_77779_bT, 0, 1, 4, 5), new WeightedRandomChestContent(Item.field_77753_aV.field_77779_bT, 0, 1, 2, 4), new WeightedRandomChestContent(Item.field_77705_m.field_77779_bT, 0, 3, 9, 20), new WeightedRandomChestContent(Item.field_77705_m.field_77779_bT, 0, 20, 32, 5), new WeightedRandomChestContent(Block.field_71949_H.field_71990_ca, 0, 2, 5, 15), new WeightedRandomChestContent(Block.field_71949_H.field_71990_ca, 0, 10, 20, 2), new WeightedRandomChestContent(Block.field_71941_G.field_71990_ca, 0, 2, 7, 8), new WeightedRandomChestContent(Item.field_77702_n.field_77779_bT, 0, 1, 2, 1), new WeightedRandomChestContent(Item.field_77817_bH.field_77779_bT, 0, 1, 1, 1)};
    private static Comparator<BlockCoordinate> blockDistanceComparator = new Comparator<BlockCoordinate>(){

        @Override
        public int compare(BlockCoordinate o1, BlockCoordinate o2) {
            if (o1.distance < o2.distance) {
                return -1;
            }
            if (o1.distance > o2.distance) {
                return 1;
            }
            return 0;
        }
    };

    public BackpackHandler() {
        BetterStorageBackpack.spawnWithBackpack(EntityZombie.class, 0.00125);
        BetterStorageBackpack.spawnWithBackpack(EntitySkeleton.class, 8.333333333333334E-4);
        BetterStorageBackpack.spawnWithBackpack(EntityPigZombie.class, 0.001);
        BetterStorageBackpack.spawnWithBackpack(EntityEnderman.class, 0.0125);
    }

    @ForgeSubscribe
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityLivingBase) {
            ItemBackpack.initBackpackData((EntityLivingBase)event.entity);
        }
    }

    @ForgeSubscribe
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && ItemBackpack.onPlaceBackpack(event.entityPlayer, event.x, event.y, event.z, event.face)) {
            event.useBlock = Event.Result.DENY;
            event.useItem = Event.Result.DENY;
        }
    }

    @ForgeSubscribe
    public void onEntityInteract(EntityInteractEvent event) {
        if (event.entity.field_70170_p.field_72995_K || !(event.entity instanceof EntityPlayerMP) || !(event.target instanceof EntityLivingBase) || event.target instanceof EntityPlayer && !BetterStorage.globalConfig.getBoolean("settings.enableBackpackInteraction")) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.entity;
        EntityLivingBase target = (EntityLivingBase)event.target;
        if (ItemBackpack.openBackpack((EntityPlayer)player, target)) {
            player.func_71038_i();
        }
    }

    @ForgeSubscribe
    public void onSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        EntityLivingBase entity = event.entityLiving;
        double probability = 0.0;
        for (BetterStorageBackpack.BackpackSpawnEntry entry : BetterStorageBackpack.spawnWithBackpack) {
            if (!entity.getClass().equals(entry.entityClass)) continue;
            probability = entry.probability;
            break;
        }
        if (!RandomUtils.getBoolean(probability)) {
            return;
        }
        if (entity.getClass().equals(EntityEnderman.class)) {
            if (MiscUtils.isEnabled(new Object[]{Tiles.enderBackpack}) && entity.field_70170_p.func_72807_a((int)entity.field_70165_t, (int)entity.field_70161_v) != BiomeGenBase.field_76779_k) {
                EntityFrienderman frienderman = new EntityFrienderman(entity.field_70170_p);
                frienderman.func_70080_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, 0.0f);
                entity.field_70170_p.func_72838_d((Entity)frienderman);
                ItemBackpack.getBackpackData((EntityLivingBase)frienderman).spawnsWithBackpack = true;
                entity.func_70106_y();
            }
        } else if (MiscUtils.isEnabled(new Object[]{Tiles.backpack})) {
            ItemBackpack.getBackpackData((EntityLivingBase)entity).spawnsWithBackpack = true;
        }
    }

    @ForgeSubscribe
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.entityLiving;
        EntityPlayer player = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        ItemStack backpack = ItemBackpack.getBackpack(entity);
        if (backpack == null) {
            PropertiesBackpack backpackData = EntityUtils.getProperties((Entity)entity, PropertiesBackpack.class);
            if (backpackData == null) {
                return;
            }
            if (backpackData.spawnsWithBackpack) {
                ItemStack[] contents = null;
                if (entity instanceof EntityFrienderman) {
                    backpack = new ItemStack((Block)Tiles.enderBackpack);
                    ((EntityLiving)entity).func_96120_a(3, 0.0f);
                } else {
                    backpack = new ItemStack((Block)Tiles.backpack, 1, RandomUtils.getInt(120, 240));
                    ItemBackpack backpackType = (ItemBackpack)Item.field_77698_e[backpack.field_77993_c];
                    if (RandomUtils.getBoolean(0.15)) {
                        int r = RandomUtils.getInt(32, 224);
                        int g = RandomUtils.getInt(32, 224);
                        int b = RandomUtils.getInt(32, 224);
                        int color = r << 16 | g << 8 | b;
                        StackUtils.set(backpack, color, "display", "color");
                    }
                    contents = new ItemStack[backpackType.getBackpackColumns() * backpackType.getBackpackRows()];
                    ((EntityLiving)entity).func_96120_a(3, 1.0f);
                }
                ItemStack armor = entity.func_71124_b(3);
                if (armor != null && armor.func_77948_v()) {
                    NBTTagCompound compound = new NBTTagCompound();
                    compound.func_74782_a("ench", armor.func_77978_p().func_74781_a("ench"));
                    backpack.func_77982_d(compound);
                }
                if (contents != null) {
                    InventoryStacks inventory = new InventoryStacks(new ItemStack[][]{contents});
                    WeightedRandomChestContent.func_76293_a((Random)RandomUtils.random, (WeightedRandomChestContent[])randomBackpackItems, (IInventory)inventory, (int)20);
                    if (RandomUtils.getDouble() < 0.1) {
                        ChestGenHooks info = ChestGenHooks.getInfo((String)"dungeonChest");
                        WeightedRandomChestContent.func_76293_a((Random)RandomUtils.random, (WeightedRandomChestContent[])info.getItems(RandomUtils.random), (IInventory)inventory, (int)5);
                    }
                }
                ItemBackpack.setBackpack(entity, backpack, contents);
                backpackData.spawnsWithBackpack = false;
            } else if (backpackData.contents != null) {
                for (ItemStack stack : backpackData.contents) {
                    WorldUtils.dropStackFromEntity((Entity)entity, stack, 1.5f);
                }
                backpackData.contents = null;
            }
        }
        ItemBackpack.getBackpackData(entity).update(entity);
        if (backpack != null) {
            ((ItemBackpack)backpack.func_77973_b()).onEquippedUpdate(entity, backpack);
        }
    }

    @ForgeSubscribe
    public void onLivingDeath(LivingDeathEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        ItemStack backpack = ItemBackpack.getBackpack(entity);
        if (backpack == null) {
            return;
        }
        PropertiesBackpack backpackData = ItemBackpack.getBackpackData(entity);
        if (backpackData.contents == null) {
            return;
        }
        boolean keepInventory = entity.field_70170_p.func_82736_K().func_82766_b("keepInventory");
        if (player != null && keepInventory) {
            NBTTagCompound persistent;
            NBTTagCompound compound = player.getEntityData();
            if (!compound.func_74764_b("PlayerPersisted")) {
                persistent = new NBTTagCompound();
                compound.func_74782_a("PlayerPersisted", (NBTBase)persistent);
            } else {
                persistent = compound.func_74775_l("PlayerPersisted");
            }
            NBTTagCompound backpackCompound = new NBTTagCompound();
            backpackCompound.func_74768_a("count", backpackData.contents.length);
            backpackCompound.func_74782_a("Items", (NBTBase)NbtUtils.writeItems(backpackData.contents));
            if (!ItemBackpack.hasChestplateBackpackEquipped(entity)) {
                backpackCompound.func_74782_a("Stack", (NBTBase)backpack.func_77955_b(new NBTTagCompound()));
            }
            persistent.func_74782_a("Backpack", (NBTBase)backpackCompound);
        } else {
            if (BetterStorage.globalConfig.getBoolean("settings.dropBackpackOnDeath")) {
                ForgeDirection orientation = DirectionUtils.getOrientation((Entity)entity);
                boolean despawn = player == null && entity.field_70718_bc <= 0;
                ArrayList<BlockCoordinate> coords = new ArrayList<BlockCoordinate>();
                for (int x = -2; x <= 2; ++x) {
                    for (int z = -2; z <= 2; ++z) {
                        coords.add(new BlockCoordinate(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, x, 0, z));
                    }
                }
                Collections.sort(coords, blockDistanceComparator);
                while (!coords.isEmpty()) {
                    Iterator iter = coords.iterator();
                    while (iter.hasNext()) {
                        BlockCoordinate coord = (BlockCoordinate)iter.next();
                        if (ItemBackpack.placeBackpack(entity, player, backpack, coord.x, coord.y, coord.z, 1, orientation, despawn, true)) {
                            ItemBackpack.setBackpack(entity, null, null);
                            return;
                        }
                        boolean replacable = WorldUtils.isBlockReplacable(entity.field_70170_p, coord.x, coord.y, coord.z);
                        coord.y = coord.y + (replacable ? -1 : 1);
                        coord.moved = coord.moved + (replacable ? 1 : 5);
                        if (coord.y > 0 && coord.y <= entity.field_70170_p.func_72800_K() && !((double)coord.moved > 24.0 - coord.distance * 4.0)) continue;
                        iter.remove();
                    }
                }
                if (backpackData.backpack != null) {
                    WorldUtils.dropStackFromEntity((Entity)entity, backpack, 4.0f);
                }
            }
            for (ItemStack stack : backpackData.contents) {
                WorldUtils.dropStackFromEntity((Entity)entity, stack, 4.0f);
            }
            backpackData.contents = null;
        }
    }

    @ForgeSubscribe
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.world.field_72995_K) {
            if (!(event.entity instanceof EntityLivingBase)) {
                return;
            }
            Packet packet = PacketHandler.makePacket((byte)7, event.entity.field_70157_k);
            PacketDispatcher.sendPacketToServer((Packet)packet);
        } else {
            if (!(event.entity instanceof EntityItem)) {
                return;
            }
            EntityItem entity = (EntityItem)event.entity;
            ItemStack stack = entity.func_70096_w().func_82710_f(10);
            if (stack == null || !(stack.func_77973_b() instanceof ItemEnderBackpack)) {
                return;
            }
            event.setCanceled(true);
            for (int i = 0; i < 64 && !TileEnderBackpack.teleportRandomly(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, i > 48, stack); ++i) {
            }
        }
    }

    public void onPlayerLogin(EntityPlayer player) {
        NBTTagCompound compound = new NBTTagCompound();
        BetterStorage.globalConfig.write(compound);
        Packet packet = PacketHandler.makePacket((byte)4, compound);
        PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)((Player)player));
    }

    public void onPlayerLogout(EntityPlayer player) {
    }

    public void onPlayerChangedDimension(EntityPlayer player) {
    }

    public void onPlayerRespawn(EntityPlayer player) {
        NBTTagCompound entityData = player.getEntityData();
        if (!entityData.func_74764_b("PlayerPersisted")) {
            return;
        }
        NBTTagCompound persistent = entityData.func_74775_l("PlayerPersisted");
        if (!persistent.func_74764_b("Backpack")) {
            return;
        }
        NBTTagCompound compound = persistent.func_74775_l("Backpack");
        PropertiesBackpack backpackData = ItemBackpack.getBackpackData((EntityLivingBase)player);
        int size = compound.func_74762_e("count");
        ItemStack[] contents = new ItemStack[size];
        NbtUtils.readItems(contents, compound.func_74761_m("Items"));
        backpackData.contents = contents;
        if (compound.func_74764_b("Stack")) {
            backpackData.backpack = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("Stack"));
        }
        persistent.func_82580_o("Backpack");
        if (persistent.func_82582_d()) {
            entityData.func_82580_o("PlayerPersisted");
        }
    }

    private static class BlockCoordinate {
        public int x;
        public int y;
        public int z;
        public double distance;
        public int moved = 0;

        public BlockCoordinate(double ex, double ey, double ez, int x, int y, int z) {
            this.x = (int)ex + x;
            this.y = (int)ey + y;
            this.z = (int)ez + z;
            this.distance = Math.sqrt(Math.pow((double)this.x + 0.5 - ex, 2.0) + Math.pow((double)this.y + 0.5 - ey, 2.0) + Math.pow((double)this.z + 0.5 - ez, 2.0));
        }
    }
}

