/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.misc.handlers;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.item.ItemBackpack;
import net.mcft.copy.betterstorage.item.ItemDrinkingHelmet;
import net.mcft.copy.betterstorage.tile.entity.TileEntityLockable;
import net.mcft.copy.betterstorage.utils.PlayerUtils;
import net.mcft.copy.betterstorage.utils.RandomUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class PacketHandler
implements IPacketHandler {
    public static final byte openGui = 0;
    public static final byte backpackTeleport = 1;
    public static final byte backpackHasItems = 2;
    public static final byte backpackOpen = 3;
    public static final byte syncSettings = 4;
    public static final byte drinkingHelmet = 5;
    public static final byte lockHit = 6;
    public static final byte clientSpawn = 7;
    public static final byte backpackIsOpen = 8;
    public static final byte backpackStack = 9;

    public static Packet makePacket(Object ... args) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        for (Object obj : args) {
            PacketHandler.writeObject(dataStream, obj);
        }
        return new Packet250CustomPayload("betterstorage", byteStream.toByteArray());
    }

    private static void writeObject(DataOutputStream stream, Object object) {
        try {
            if (object instanceof Byte) {
                stream.writeByte(((Byte)object).byteValue());
            } else if (object instanceof Short) {
                stream.writeShort(((Short)object).shortValue());
            } else if (object instanceof Integer) {
                stream.writeInt((Integer)object);
            } else if (object instanceof Float) {
                stream.writeFloat(((Float)object).floatValue());
            } else if (object instanceof Double) {
                stream.writeDouble((Double)object);
            } else if (object instanceof String) {
                stream.writeUTF((String)object);
            } else if (object instanceof Boolean) {
                stream.writeBoolean((Boolean)object);
            } else if (object instanceof byte[]) {
                stream.write((byte[])object);
            } else if (object instanceof NBTTagCompound) {
                NBTBase.func_74731_a((NBTBase)((NBTTagCompound)object), (DataOutput)stream);
            } else if (object instanceof ItemStack) {
                PacketHandler.writeItemStack(stream, (ItemStack)object);
            } else if (object == null) {
                NBTBase.func_74731_a((NBTBase)new NBTTagCompound(), (DataOutput)stream);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeItemStack(DataOutputStream stream, ItemStack stack) throws IOException {
        NBTBase.func_74731_a((NBTBase)stack.func_77955_b(new NBTTagCompound()), (DataOutput)stream);
    }

    public static ItemStack readItemStack(DataInputStream stream) throws IOException {
        return ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)NBTBase.func_74739_b((DataInput)stream)));
    }

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player pl) {
        EntityPlayer player = (EntityPlayer)pl;
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            byte id = stream.readByte();
            switch (id) {
                case 0: {
                    this.checkSide(id, side, Side.CLIENT);
                    this.handleOpenGui(player, stream);
                    break;
                }
                case 1: {
                    this.checkSide(id, side, Side.CLIENT);
                    this.handleBackpackTeleport(player, stream);
                    break;
                }
                case 2: {
                    this.checkSide(id, side, Side.CLIENT);
                    this.handleBackpackHasItems(player, stream);
                    break;
                }
                case 3: {
                    this.checkSide(id, side, Side.SERVER);
                    this.handleBackpackOpen(player, stream);
                    break;
                }
                case 4: {
                    this.checkSide(id, side, Side.CLIENT);
                    this.handleSyncSetting(player, stream);
                    break;
                }
                case 5: {
                    this.checkSide(id, side, Side.SERVER);
                    this.handleDrinkingHelmet(player, stream);
                    break;
                }
                case 6: {
                    this.checkSide(id, side, Side.CLIENT);
                    this.handleLockHit(player, stream);
                    break;
                }
                case 7: {
                    this.checkSide(id, side, Side.SERVER);
                    this.handleClientSpawn(player, stream);
                    break;
                }
                case 8: {
                    this.checkSide(id, side, Side.CLIENT);
                    this.handleBackpackIsOpen(player, stream);
                    break;
                }
                case 9: {
                    this.checkSide(id, side, Side.CLIENT);
                    this.handleBackpackStack(player, stream);
                    break;
                }
                default: {
                    throw new Exception("Received BetterStorage packet for unhandled ID " + id + " on side " + side + ".");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkSide(int id, Side side, Side allowed) throws Exception {
        if (side == allowed) {
            return;
        }
        throw new Exception("Received BetterStorage packet for ID " + id + " on invalid side " + side + ".");
    }

    @SideOnly(value=Side.CLIENT)
    private void handleOpenGui(EntityPlayer player, DataInputStream stream) throws IOException {
        int windowId = stream.readInt();
        String name = stream.readUTF();
        byte columns = stream.readByte();
        byte rows = stream.readByte();
        String title = stream.readUTF();
        PlayerUtils.openGui(player, name, columns, rows, title);
        player.field_71070_bA.field_75152_c = windowId;
    }

    @SideOnly(value=Side.CLIENT)
    private void handleBackpackTeleport(EntityPlayer player, DataInputStream stream) throws IOException {
        double sourceX = stream.readDouble();
        double sourceY = stream.readDouble();
        double sourceZ = stream.readDouble();
        int x = stream.readInt();
        int y = stream.readInt();
        int z = stream.readInt();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        int amount = 128;
        for (int i = 0; i < amount; ++i) {
            double a = (double)i / (double)(amount - 1);
            double vX = RandomUtils.getDouble(-0.3, 0.3);
            double vY = RandomUtils.getDouble(-0.3, 0.3);
            double vZ = RandomUtils.getDouble(-0.3, 0.3);
            double pX = sourceX + ((double)x - sourceX) * a + RandomUtils.getDouble(0.3, 0.7);
            double pY = sourceY + ((double)y - sourceY) * a + RandomUtils.getDouble(-0.5, 0.0) + a / 2.0;
            double pZ = sourceZ + ((double)z - sourceZ) * a + RandomUtils.getDouble(0.3, 0.7);
            world.func_72869_a("portal", pX, pY, pZ, vX, vY, vZ);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void handleBackpackHasItems(EntityPlayer player, DataInputStream stream) throws IOException {
        boolean hasItems;
        ItemBackpack.getBackpackData((EntityLivingBase)player).hasItems = hasItems = stream.readBoolean();
    }

    private void handleBackpackOpen(EntityPlayer player, DataInputStream stream) {
        if (BetterStorage.globalConfig.getBoolean("settings.enableBackpackOpen")) {
            ItemBackpack.openBackpack(player, (EntityLivingBase)player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void handleSyncSetting(EntityPlayer player, DataInputStream stream) throws IOException {
        NBTTagCompound compound = (NBTTagCompound)NBTBase.func_74739_b((DataInput)stream);
        BetterStorage.globalConfig.read(compound);
    }

    private void handleDrinkingHelmet(EntityPlayer player, DataInputStream stream) {
        ItemDrinkingHelmet.use(player);
    }

    @SideOnly(value=Side.CLIENT)
    private void handleLockHit(EntityPlayer player, DataInputStream stream) throws IOException {
        int x = stream.readInt();
        int y = stream.readInt();
        int z = stream.readInt();
        boolean damage = stream.readBoolean();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        TileEntityLockable lockable = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityLockable.class);
        if (lockable != null) {
            lockable.lockAttachment.hit(damage);
        }
    }

    private void handleClientSpawn(EntityPlayer player, DataInputStream stream) throws IOException {
        int entityID = stream.readInt();
        Entity entity = player.field_70170_p.func_73045_a(entityID);
        if (entity == null || !(entity instanceof EntityLivingBase)) {
            return;
        }
        ItemBackpack.getBackpackData((EntityLivingBase)entity).sendDataToPlayer((EntityLivingBase)entity, player);
    }

    @SideOnly(value=Side.CLIENT)
    private void handleBackpackIsOpen(EntityPlayer player, DataInputStream stream) throws IOException {
        int entityID = stream.readInt();
        boolean isOpen = stream.readBoolean();
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(entityID);
        if (entity == null) {
            return;
        }
        ItemBackpack.getBackpackData((EntityLivingBase)((EntityLivingBase)entity)).playersUsing = isOpen ? 1 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    private void handleBackpackStack(EntityPlayer player, DataInputStream stream) throws IOException {
        int entityID = stream.readInt();
        ItemStack stack = PacketHandler.readItemStack(stream);
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(entityID);
        if (entity == null) {
            return;
        }
        ItemBackpack.getBackpackData((EntityLivingBase)((EntityLivingBase)entity)).backpack = stack;
    }

    public static void sendToEveryoneNear(World world, double x, double y, double z, double distance, EntityPlayer except, Packet packet) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        server.func_71203_ab().func_72397_a(except, x, y, z, distance, world.field_73011_w.field_76574_g, packet);
    }

    public static void sendToEveryoneTracking(Entity entity, Packet packet) {
        ((WorldServer)entity.field_70170_p).func_73039_n().func_72789_b(entity, packet);
    }
}

