/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.proxy;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.mcft.copy.betterstorage.addon.Addon;
import net.mcft.copy.betterstorage.attachment.Attachment;
import net.mcft.copy.betterstorage.attachment.Attachments;
import net.mcft.copy.betterstorage.attachment.IHasAttachments;
import net.mcft.copy.betterstorage.client.model.ModelBackpackArmor;
import net.mcft.copy.betterstorage.client.model.ModelCluckington;
import net.mcft.copy.betterstorage.client.renderer.BetterStorageRenderingHandler;
import net.mcft.copy.betterstorage.client.renderer.ItemRendererBackpack;
import net.mcft.copy.betterstorage.client.renderer.ItemRendererContainer;
import net.mcft.copy.betterstorage.client.renderer.RenderFrienderman;
import net.mcft.copy.betterstorage.client.renderer.TileEntityArmorStandRenderer;
import net.mcft.copy.betterstorage.client.renderer.TileEntityBackpackRenderer;
import net.mcft.copy.betterstorage.client.renderer.TileEntityLockerRenderer;
import net.mcft.copy.betterstorage.client.renderer.TileEntityReinforcedChestRenderer;
import net.mcft.copy.betterstorage.content.Tiles;
import net.mcft.copy.betterstorage.entity.EntityCluckington;
import net.mcft.copy.betterstorage.entity.EntityFrienderman;
import net.mcft.copy.betterstorage.item.ItemBackpack;
import net.mcft.copy.betterstorage.misc.handlers.KeyBindingHandler;
import net.mcft.copy.betterstorage.proxy.CommonProxy;
import net.mcft.copy.betterstorage.tile.TileArmorStand;
import net.mcft.copy.betterstorage.tile.entity.TileEntityArmorStand;
import net.mcft.copy.betterstorage.tile.entity.TileEntityBackpack;
import net.mcft.copy.betterstorage.tile.entity.TileEntityLocker;
import net.mcft.copy.betterstorage.tile.entity.TileEntityReinforcedChest;
import net.mcft.copy.betterstorage.tile.entity.TileEntityReinforcedLocker;
import net.mcft.copy.betterstorage.utils.MiscUtils;
import net.mcft.copy.betterstorage.utils.RenderUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderChicken;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static int reinforcedChestRenderId;
    public static int lockerRenderId;
    public static int armorStandRenderId;
    public static int backpackRenderId;
    public static int reinforcedLockerRenderId;
    public static final Map<Class<? extends TileEntity>, BetterStorageRenderingHandler> renderingHandlers;

    @Override
    public void initialize() {
        super.initialize();
        KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)new KeyBindingHandler());
        this.registerRenderers();
    }

    private void registerRenderers() {
        ClientProxy.registerItemRenderer(Tiles.backpack, ItemRendererBackpack.instance);
        ClientProxy.registerItemRenderer(Tiles.enderBackpack, ItemRendererBackpack.instance);
        ClientProxy.registerItemRenderer(Tiles.reinforcedChest, new ItemRendererContainer(TileEntityReinforcedChest.class));
        ClientProxy.registerItemRenderer(Tiles.reinforcedLocker, new ItemRendererContainer(TileEntityReinforcedLocker.class));
        RenderingRegistry.registerEntityRenderingHandler(EntityFrienderman.class, (Render)new RenderFrienderman());
        RenderingRegistry.registerEntityRenderingHandler(EntityCluckington.class, (Render)new RenderChicken((ModelBase)new ModelCluckington(), 0.4f));
        reinforcedChestRenderId = ClientProxy.registerTileEntityRenderer(TileEntityReinforcedChest.class, new TileEntityReinforcedChestRenderer());
        lockerRenderId = ClientProxy.registerTileEntityRenderer(TileEntityLocker.class, new TileEntityLockerRenderer());
        armorStandRenderId = ClientProxy.registerTileEntityRenderer(TileEntityArmorStand.class, new TileEntityArmorStandRenderer(), false, 0.0f, 1.0f, 0.0f);
        backpackRenderId = ClientProxy.registerTileEntityRenderer(TileEntityBackpack.class, new TileEntityBackpackRenderer(), true, -160.0f, 1.5f, 0.14f);
        reinforcedLockerRenderId = ClientProxy.registerTileEntityRenderer(TileEntityReinforcedLocker.class, new TileEntityLockerRenderer());
        Addon.registerRenderersAll();
    }

    public static void registerItemRenderer(Block block, IItemRenderer renderer) {
        if (MiscUtils.isEnabled(block)) {
            MinecraftForgeClient.registerItemRenderer((int)block.field_71990_ca, (IItemRenderer)renderer);
        }
    }

    public static int registerTileEntityRenderer(Class<? extends TileEntity> tileEntityClass, TileEntitySpecialRenderer renderer, boolean render3dInInventory, float rotation, float scale, float yOffset) {
        ClientRegistry.bindTileEntitySpecialRenderer(tileEntityClass, (TileEntitySpecialRenderer)renderer);
        BetterStorageRenderingHandler renderingHandler = new BetterStorageRenderingHandler(tileEntityClass, renderer, render3dInInventory, rotation, scale, yOffset);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)renderingHandler);
        renderingHandlers.put(tileEntityClass, renderingHandler);
        return renderingHandler.getRenderId();
    }

    public static int registerTileEntityRenderer(Class<? extends TileEntity> tileEntityClass, TileEntitySpecialRenderer renderer) {
        return ClientProxy.registerTileEntityRenderer(tileEntityClass, renderer, true, 90.0f, 1.0f, 0.0f);
    }

    @ForgeSubscribe
    public void drawBlockHighlight(DrawBlockHighlightEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        MovingObjectPosition target = WorldUtils.rayTrace(player, event.partialTicks);
        if (target == null || target.field_72313_a != EnumMovingObjectType.TILE) {
            return;
        }
        int x = target.field_72311_b;
        int y = target.field_72312_c;
        int z = target.field_72309_d;
        AxisAlignedBB box = null;
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (block instanceof TileArmorStand) {
            box = this.getArmorStandHighlightBox(player, world, x, y, z, target.field_72307_f);
        } else if (tileEntity instanceof IHasAttachments) {
            box = this.getAttachmentPointsHighlightBox(player, tileEntity, target);
        }
        if (box == null) {
            return;
        }
        double xOff = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.partialTicks;
        double yOff = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.partialTicks;
        double zOff = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.partialTicks;
        box.func_72317_d(-xOff, -yOff, -zOff);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        GL11.glLineWidth((float)2.0f);
        GL11.glDisable((int)3553);
        GL11.glDepthMask((boolean)false);
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78371_b(3);
        tes.func_78377_a(box.field_72340_a, box.field_72338_b, box.field_72339_c);
        tes.func_78377_a(box.field_72336_d, box.field_72338_b, box.field_72339_c);
        tes.func_78377_a(box.field_72336_d, box.field_72338_b, box.field_72334_f);
        tes.func_78377_a(box.field_72340_a, box.field_72338_b, box.field_72334_f);
        tes.func_78377_a(box.field_72340_a, box.field_72338_b, box.field_72339_c);
        tes.func_78381_a();
        tes.func_78371_b(3);
        tes.func_78377_a(box.field_72340_a, box.field_72337_e, box.field_72339_c);
        tes.func_78377_a(box.field_72336_d, box.field_72337_e, box.field_72339_c);
        tes.func_78377_a(box.field_72336_d, box.field_72337_e, box.field_72334_f);
        tes.func_78377_a(box.field_72340_a, box.field_72337_e, box.field_72334_f);
        tes.func_78377_a(box.field_72340_a, box.field_72337_e, box.field_72339_c);
        tes.func_78381_a();
        tes.func_78371_b(1);
        tes.func_78377_a(box.field_72340_a, box.field_72338_b, box.field_72339_c);
        tes.func_78377_a(box.field_72340_a, box.field_72337_e, box.field_72339_c);
        tes.func_78377_a(box.field_72336_d, box.field_72338_b, box.field_72339_c);
        tes.func_78377_a(box.field_72336_d, box.field_72337_e, box.field_72339_c);
        tes.func_78377_a(box.field_72336_d, box.field_72338_b, box.field_72334_f);
        tes.func_78377_a(box.field_72336_d, box.field_72337_e, box.field_72334_f);
        tes.func_78377_a(box.field_72340_a, box.field_72338_b, box.field_72334_f);
        tes.func_78377_a(box.field_72340_a, box.field_72337_e, box.field_72334_f);
        tes.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        event.setCanceled(true);
    }

    private AxisAlignedBB getArmorStandHighlightBox(EntityPlayer player, World world, int x, int y, int z, Vec3 hitVec) {
        TileEntityArmorStand armorStand;
        int metadata = world.func_72805_g(x, y, z);
        if (metadata > 0) {
            --y;
        }
        if ((armorStand = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityArmorStand.class)) == null) {
            return null;
        }
        int slot = Math.min(3, (int)((hitVec.field_72448_b - (double)y) * 2.0));
        ItemStack item = armorStand.armor[slot];
        ItemStack holding = player.func_71045_bC();
        ItemStack armor = player.field_71071_by.field_70460_b[slot];
        if (player.func_70093_af() ? holding != null || item == null && armor == null || armor != null && !armor.func_77973_b().isValidArmor(armor, 3 - slot, (Entity)player) : !(item != null && holding == null || holding != null && holding.func_77973_b().isValidArmor(holding, 3 - slot, (Entity)player))) {
            return null;
        }
        double minX = (double)x + 0.125;
        double minY = (double)y + (double)slot / 2.0;
        double minZ = (double)z + 0.125;
        double maxX = (double)x + 0.875;
        double maxY = (double)y + (double)slot / 2.0 + 0.5;
        double maxZ = (double)z + 0.875;
        return AxisAlignedBB.func_72332_a().func_72299_a(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private AxisAlignedBB getAttachmentPointsHighlightBox(EntityPlayer player, TileEntity tileEntity, MovingObjectPosition target) {
        Attachments attachments = ((IHasAttachments)tileEntity).getAttachments();
        Attachment attachment = attachments.get(target.subHit);
        if (attachment == null) {
            return null;
        }
        return attachment.getHighlightBox();
    }

    @ForgeSubscribe
    public void onRenderPlayerSpecialsPre(RenderPlayerEvent.Specials.Pre event) {
        ItemStack backpack = ItemBackpack.getBackpackData((EntityLivingBase)event.entityPlayer).backpack;
        if (backpack != null) {
            EntityPlayer player = event.entityPlayer;
            float partial = event.partialRenderTick;
            ItemBackpack backpackType = (ItemBackpack)backpack.func_77973_b();
            int color = backpackType.func_82814_b(backpack);
            ModelBackpackArmor model = (ModelBackpackArmor)backpackType.getArmorModel((EntityLivingBase)player, backpack, 0);
            model.field_78095_p = event.renderer.func_77040_d((EntityLivingBase)player, partial);
            model.func_78086_a((EntityLivingBase)player, 0.0f, 0.0f, partial);
            event.renderer.func_110776_a(new ResourceLocation(backpackType.getArmorTexture(backpack, (Entity)player, 0, null)));
            RenderUtils.setColorFromInt(color >= 0 ? color : 0xFFFFFF);
            model.func_78088_a((Entity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            if (color >= 0) {
                event.renderer.func_110776_a(new ResourceLocation(backpackType.getArmorTexture(backpack, (Entity)player, 0, "overlay")));
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                model.func_78088_a((Entity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            }
            if (backpack.func_77948_v()) {
                float f9 = (float)player.field_70173_aa + partial;
                event.renderer.func_110776_a(RendererLivingEntity.field_110814_a);
                GL11.glEnable((int)3042);
                GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
                GL11.glDepthFunc((int)514);
                GL11.glDepthMask((boolean)false);
                for (int k = 0; k < 2; ++k) {
                    GL11.glDisable((int)2896);
                    float f11 = 0.76f;
                    GL11.glColor4f((float)(0.5f * f11), (float)(0.25f * f11), (float)(0.8f * f11), (float)1.0f);
                    GL11.glBlendFunc((int)768, (int)1);
                    GL11.glMatrixMode((int)5890);
                    GL11.glLoadIdentity();
                    float f12 = f9 * (0.001f + (float)k * 0.003f) * 20.0f;
                    float f13 = 0.33333334f;
                    GL11.glScalef((float)f13, (float)f13, (float)f13);
                    GL11.glRotatef((float)(30.0f - (float)k * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)f12, (float)0.0f);
                    GL11.glMatrixMode((int)5888);
                    model.func_78088_a((Entity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glMatrixMode((int)5890);
                GL11.glDepthMask((boolean)true);
                GL11.glLoadIdentity();
                GL11.glMatrixMode((int)5888);
                GL11.glEnable((int)2896);
                GL11.glDisable((int)3042);
                GL11.glDepthFunc((int)515);
            }
        } else {
            backpack = ItemBackpack.getBackpack((EntityLivingBase)event.entityPlayer);
        }
        if (backpack != null) {
            event.renderCape = false;
        }
    }

    static {
        renderingHandlers = new HashMap<Class<? extends TileEntity>, BetterStorageRenderingHandler>();
    }
}

