/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.proxy;

import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import net.mcft.copy.betterstorage.attachment.EnumAttachmentInteraction;
import net.mcft.copy.betterstorage.attachment.IHasAttachments;
import net.mcft.copy.betterstorage.content.Items;
import net.mcft.copy.betterstorage.entity.EntityCluckington;
import net.mcft.copy.betterstorage.item.IDyeableItem;
import net.mcft.copy.betterstorage.item.ItemBucketSlime;
import net.mcft.copy.betterstorage.item.cardboard.ICardboardItem;
import net.mcft.copy.betterstorage.item.cardboard.ItemCardboardSheet;
import net.mcft.copy.betterstorage.misc.handlers.BackpackHandler;
import net.mcft.copy.betterstorage.tile.crate.CratePileCollection;
import net.mcft.copy.betterstorage.utils.MiscUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;

public class CommonProxy
implements ITickHandler {
    public void initialize() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        BackpackHandler backpacks = new BackpackHandler();
        MinecraftForge.EVENT_BUS.register((Object)backpacks);
        GameRegistry.registerPlayerTracker((IPlayerTracker)backpacks);
        TickRegistry.registerTickHandler((ITickHandler)this, (Side)Side.SERVER);
    }

    @ForgeSubscribe
    public void onWorldSave(WorldEvent.Save event) {
        CratePileCollection.saveAll(event.world);
    }

    @ForgeSubscribe
    public void onWorldUnload(WorldEvent.Unload event) {
        CratePileCollection.unload(event.world);
    }

    @ForgeSubscribe
    public void onPlayerInteract(PlayerInteractEvent event) {
        int metadata;
        IHasAttachments hasAttachments;
        boolean rightClick;
        if (event.isCanceled()) {
            return;
        }
        World world = event.entity.field_70170_p;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        EntityPlayer player = event.entityPlayer;
        ItemStack holding = player.func_71045_bC();
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        boolean leftClick = event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK;
        boolean bl = rightClick = event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK;
        if ((leftClick || rightClick) && (hasAttachments = WorldUtils.get((IBlockAccess)world, x, y, z, IHasAttachments.class)) != null) {
            EnumAttachmentInteraction interactionType;
            EnumAttachmentInteraction enumAttachmentInteraction = interactionType = event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK ? EnumAttachmentInteraction.attack : EnumAttachmentInteraction.use;
            if (hasAttachments.getAttachments().interact(WorldUtils.rayTrace(player, 1.0f), player, interactionType)) {
                event.useBlock = Event.Result.DENY;
                event.useItem = Event.Result.DENY;
            }
        }
        if (rightClick && block == Block.field_72108_bG && (metadata = world.func_72805_g(x, y, z)) > 0) {
            IDyeableItem dyeable;
            IDyeableItem iDyeableItem = dyeable = holding != null && holding.func_77973_b() instanceof IDyeableItem ? (IDyeableItem)holding.func_77973_b() : null;
            if (dyeable != null && dyeable.canDye(holding)) {
                StackUtils.remove(holding, "display", "color");
                world.func_72921_c(x, y, z, metadata - 1, 2);
                world.func_96440_m(x, y, z, block.field_71990_ca);
                event.useBlock = Event.Result.DENY;
                event.useItem = Event.Result.DENY;
            }
        }
        if (leftClick && holding != null && holding.func_77973_b() instanceof ICardboardItem && !ItemCardboardSheet.isEffective(holding)) {
            event.useItem = Event.Result.DENY;
        }
    }

    @ForgeSubscribe
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.entityPlayer;
        ItemStack holding = player.func_71045_bC();
        if (holding != null && holding.func_77973_b() instanceof ICardboardItem && !ItemCardboardSheet.isEffective(holding)) {
            event.newSpeed = -1.0f;
        }
    }

    @ForgeSubscribe
    public void onEntityInteract(EntityInteractEvent event) {
        if (event.entity.field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        Entity target = event.target;
        ItemStack holding = player.func_71045_bC();
        if (target.getClass() == EntityChicken.class && holding != null && holding.func_77973_b() == Item.field_111212_ci) {
            EntityChicken chicken = (EntityChicken)target;
            if (!chicken.field_70128_L && !chicken.func_70631_g_() && "Cluckington".equals(holding.func_82833_r())) {
                EntityCluckington.spawn(chicken);
            }
        }
        if (MiscUtils.isEnabled(new Object[]{Items.slimeBucket}) && target instanceof EntityLiving && holding != null && holding.func_77973_b() == Item.field_77788_aw) {
            ItemBucketSlime.pickUpSlime(player, (EntityLiving)target);
        }
    }

    public String getLabel() {
        return "BetterStorage";
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.WORLD);
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        CratePileCollection.getCollection((World)tickData[0]).onTick();
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
    }
}

