/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.container.ContainerBetterStorage;
import net.mcft.copy.betterstorage.inventory.InventoryTileEntity;
import net.mcft.copy.betterstorage.item.ItemEnderBackpack;
import net.mcft.copy.betterstorage.misc.handlers.PacketHandler;
import net.mcft.copy.betterstorage.tile.TileBackpack;
import net.mcft.copy.betterstorage.tile.entity.TileEntityBackpack;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.mcft.copy.betterstorage.utils.PlayerUtils;
import net.mcft.copy.betterstorage.utils.RandomUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TileEnderBackpack
extends TileBackpack {
    public TileEnderBackpack(int id) {
        super(id);
        this.func_71848_c(3.0f);
    }

    @Override
    public Class<? extends Item> getItemClass() {
        return ItemEnderBackpack.class;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.field_94336_cN = iconRegister.func_94245_a("obsidian");
    }

    @Override
    public TileEntity func_72274_a(World world) {
        return new TileEntityBackpack();
    }

    @Override
    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (player.field_71075_bZ.field_75098_d) {
            WorldUtils.get((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityBackpack.class).equipped = true;
        }
        return super.removeBlockByPlayer(world, player, x, y, z);
    }

    public void func_71852_a(World world, int x, int y, int z, int id, int meta) {
        TileEntityBackpack backpack = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityBackpack.class);
        if (!world.field_72995_K && backpack != null && !backpack.equipped) {
            for (int i = 0; i < 64 && !TileEnderBackpack.teleportRandomly(world, x, y, z, i > 48, backpack.stack); ++i) {
            }
        }
        world.func_72932_q(x, y, z);
    }

    public static boolean teleportRandomly(World world, double sourceX, double sourceY, double sourceZ, boolean canFloat, ItemStack stack) {
        Block blockBelow;
        int x = (int)sourceX + RandomUtils.getInt(-12, 13);
        int y = (int)sourceY + RandomUtils.getInt(-8, 9);
        int z = (int)sourceZ + RandomUtils.getInt(-12, 13);
        y = Math.max(1, Math.min(world.func_72800_K() - 1, y));
        if (!world.func_72899_e(x, y, z)) {
            return false;
        }
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        if (block != null && !block.isAirBlock(world, x, y, z) && !block.isBlockReplaceable(world, x, y, z)) {
            return false;
        }
        if (!(canFloat || (blockBelow = Block.field_71973_m[world.func_72798_a(x, y - 1, z)]) != null && blockBelow.isBlockSolidOnSide(world, x, y - 1, z, ForgeDirection.UP))) {
            return false;
        }
        Packet packet = PacketHandler.makePacket((byte)1, sourceX, sourceY, sourceZ, x, y, z);
        PacketDispatcher.sendPacketToAllAround((double)(sourceX + 0.5), (double)(sourceY + 0.5), (double)(sourceZ + 0.5), (double)512.0, (int)world.field_73011_w.field_76574_g, (Packet)packet);
        world.func_72908_a(sourceX + 0.5, sourceY + 0.5, sourceZ + 0.5, "mob.endermen.portal", 1.0f, 1.0f);
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.endermen.portal", 1.0f, 1.0f);
        world.func_72832_d(x, y, z, stack.field_77993_c, RandomUtils.getInt(2, 6), 3);
        TileEntityBackpack newBackpack = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityBackpack.class);
        newBackpack.stack = stack;
        return true;
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntityBackpack backpack = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityBackpack.class);
            InventoryTileEntity inventory = new InventoryTileEntity((TileEntityContainer)backpack, (IInventory)player.func_71005_bN());
            ContainerBetterStorage container = new ContainerBetterStorage(player, inventory, 9, 3);
            String name = "container.betterstorage.enderBackpack";
            PlayerUtils.openGui(player, name, 9, 3, backpack.getCustomTitle(), container);
        }
        return true;
    }
}

