/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.crate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mcft.copy.betterstorage.api.ICrateWatcher;
import net.mcft.copy.betterstorage.inventory.InventoryCrateBlockView;
import net.mcft.copy.betterstorage.misc.ItemIdentifier;
import net.mcft.copy.betterstorage.misc.Region;
import net.mcft.copy.betterstorage.tile.crate.CratePileCollection;
import net.mcft.copy.betterstorage.tile.crate.CratePileMap;
import net.mcft.copy.betterstorage.tile.crate.TileEntityCrate;
import net.mcft.copy.betterstorage.utils.RandomUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CratePileData
implements Iterable<ItemStack> {
    private static final int maxCratePileSize = 8192;
    public final CratePileCollection collection;
    public final int id;
    private Map<ItemIdentifier, ItemStack> contents = new HashMap<ItemIdentifier, ItemStack>();
    private ItemStack[] contentsArray = new ItemStack[0];
    private int numCrates = 0;
    private int numSlots = 0;
    private boolean destroyed = false;
    private CratePileMap map;
    private Set<ICrateWatcher> watchers = new HashSet<ICrateWatcher>();
    public final InventoryCrateBlockView blockView = new InventoryCrateBlockView(this);

    public int getNumCrates() {
        return this.numCrates;
    }

    public List<ItemStack> getContents() {
        return Arrays.asList(this.contentsArray);
    }

    public int getCapacity() {
        return this.numCrates * 18;
    }

    public int getNumItems() {
        return this.contents.size();
    }

    public int getOccupiedSlots() {
        return this.numSlots;
    }

    public int getFreeSlots() {
        return this.getCapacity() - this.getOccupiedSlots();
    }

    public Region getRegion() {
        return this.map.region;
    }

    public int getCenterX() {
        return (this.map.region.minX + this.map.region.maxX) / 2;
    }

    public int getCenterY() {
        return (this.map.region.minY + this.map.region.maxY) / 2;
    }

    public int getCenterZ() {
        return (this.map.region.minZ + this.map.region.maxZ) / 2;
    }

    public CratePileData(CratePileCollection collection, int id, int numCrates) {
        this.collection = collection;
        this.id = id;
        this.numCrates = numCrates;
    }

    public boolean canAdd(TileEntityCrate crate) {
        return !(this.map == null || this.numCrates >= 8192 || !this.map.region.contains(crate) && !this.canExpand(crate) || !this.map.get(crate.field_70329_l, crate.field_70330_m - 1, crate.field_70327_n) && crate.field_70330_m != this.map.region.minY);
    }

    private boolean canExpand(TileEntityCrate crate) {
        int volume = this.map.region.volume();
        if (this.numCrates < Math.min((int)((double)volume * 0.8), volume - 5)) {
            return false;
        }
        if (crate.field_70329_l < this.map.region.minX || crate.field_70329_l > this.map.region.maxX) {
            int maxDiff;
            int n = maxDiff = this.map.region.height() == 1 ? 1 : 3;
            if (this.map.region.width() >= maxDiff + Math.min(this.map.region.height(), this.map.region.depth())) {
                return false;
            }
        } else if (crate.field_70327_n < this.map.region.minZ || crate.field_70327_n > this.map.region.maxZ) {
            int maxDiff;
            int n = maxDiff = this.map.region.width() == 1 ? 1 : 3;
            if (this.map.region.height() >= maxDiff + Math.min(this.map.region.width(), this.map.region.depth())) {
                return false;
            }
        } else if (crate.field_70330_m < this.map.region.minY || crate.field_70330_m > this.map.region.maxY) {
            int maxDiff;
            int n = maxDiff = this.map.region.width() == 1 || this.map.region.height() == 1 ? 1 : 4;
            if (this.map.region.depth() >= maxDiff + Math.min(this.map.region.width(), this.map.region.height())) {
                return false;
            }
        }
        return true;
    }

    public void trimMap() {
        if (this.map != null) {
            this.map.trim();
        }
    }

    public void addCrate(TileEntityCrate crate) {
        if (this.numCrates == 0) {
            this.map = new CratePileMap(crate);
        }
        this.map.add(crate);
        ++this.numCrates;
        this.markDirty();
    }

    public void removeCrate(TileEntityCrate crate) {
        if (--this.numCrates <= 0) {
            this.collection.removeCratePile(this);
            this.destroyed = true;
        } else {
            if (this.map != null) {
                this.map.remove(crate);
            }
            this.markDirty();
        }
    }

    public boolean hasCrate(int x, int y, int z) {
        return this.map.get(x, y, z);
    }

    private ItemStack getItemStack(ItemIdentifier item, boolean copy) {
        if (item == null) {
            return null;
        }
        ItemStack stack = this.contents.get(item);
        return copy ? ItemStack.func_77944_b((ItemStack)stack) : stack;
    }

    public ItemStack getItemStack(ItemIdentifier item) {
        return this.getItemStack(item, true);
    }

    private ItemStack getItemStack(ItemStack item, boolean copy) {
        if (item == null) {
            return null;
        }
        return this.getItemStack(new ItemIdentifier(item), copy);
    }

    public ItemStack getItemStack(ItemStack item) {
        return this.getItemStack(item, true);
    }

    public ItemStack getItemStack(int index) {
        if (index < 0 || index >= this.getNumItems()) {
            return null;
        }
        return this.contentsArray[index];
    }

    public int getItemCount(ItemIdentifier item) {
        ItemStack stack = this.getItemStack(item, false);
        return stack != null ? stack.field_77994_a : 0;
    }

    public int getItemCount(ItemStack item) {
        return this.getItemCount(new ItemIdentifier(item));
    }

    private ItemStack addItems(ItemStack stack, boolean dirty) {
        if (stack == null) {
            return null;
        }
        ItemStack overflow = null;
        int space = this.spaceForItem(stack);
        if (space > 0) {
            int stacksBefore;
            ItemIdentifier item;
            ItemStack contentsStack;
            if (space < stack.field_77994_a) {
                overflow = stack.func_77979_a(stack.field_77994_a - space);
            }
            if ((contentsStack = this.getItemStack(item = new ItemIdentifier(stack), false)) == null) {
                stacksBefore = 0;
                contentsStack = item.createStack(stack.field_77994_a);
                this.contents.put(item, contentsStack);
                this.updateContentsArray();
            } else {
                stacksBefore = StackUtils.calcNumStacks(contentsStack);
                contentsStack.field_77994_a += stack.field_77994_a;
            }
            int stacksAfter = StackUtils.calcNumStacks(contentsStack);
            this.numSlots += stacksAfter - stacksBefore;
            for (ICrateWatcher watcher : this.watchers) {
                watcher.onCrateItemsModified(stack);
            }
        } else {
            overflow = stack;
        }
        if (dirty) {
            this.markDirty();
        }
        return overflow;
    }

    public ItemStack addItems(ItemStack stack) {
        return this.addItems(stack, true);
    }

    public List<ItemStack> addItems(Collection<ItemStack> stacks) {
        ArrayList<ItemStack> overflow = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            ItemStack overflowStack = this.addItems(stack);
            if (overflowStack == null) continue;
            overflow.add(overflowStack);
        }
        return overflow;
    }

    public ItemStack removeItems(ItemIdentifier item, int amount) {
        int stacksAfter;
        ItemStack stack = this.getItemStack(item, false);
        if (stack == null || amount <= 0) {
            return null;
        }
        int stacksBefore = StackUtils.calcNumStacks(stack);
        if (amount < stack.field_77994_a) {
            stack.field_77994_a -= amount;
            stacksAfter = StackUtils.calcNumStacks(stack);
            stack = StackUtils.copyStack(stack, amount);
        } else {
            this.contents.remove(item);
            this.updateContentsArray();
            stacksAfter = 0;
        }
        this.numSlots -= stacksBefore - stacksAfter;
        ItemStack removedStack = StackUtils.copyStack(stack, -stack.field_77994_a, false);
        for (ICrateWatcher watcher : this.watchers) {
            watcher.onCrateItemsModified(removedStack);
        }
        this.markDirty();
        return stack;
    }

    public ItemStack removeItems(ItemStack item, int amount) {
        if (item == null) {
            return null;
        }
        return this.removeItems(new ItemIdentifier(item), amount);
    }

    public ItemStack removeItems(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return this.removeItems(stack, stack.field_77994_a);
    }

    public int spaceForItem(ItemIdentifier item) {
        if (item == null) {
            return 0;
        }
        int maxStackSize = item.createStack(1).func_77976_d();
        int space = this.getFreeSlots() * maxStackSize;
        ItemStack stack = this.getItemStack(item);
        if (stack != null) {
            space += StackUtils.calcNumStacks(stack) * maxStackSize - stack.field_77994_a;
        }
        return space;
    }

    public int spaceForItem(ItemStack item) {
        if (item == null) {
            return 0;
        }
        return this.spaceForItem(new ItemIdentifier(item));
    }

    public List<ItemStack> pickItemStacks(int amount) {
        if ((amount = Math.min(amount, this.getOccupiedSlots())) <= 0) {
            return new ArrayList<ItemStack>();
        }
        int totalStacks = 0;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack contentsStack : this) {
            int numStacks = StackUtils.calcNumStacks(contentsStack);
            for (int i = 0; i < numStacks; ++i) {
                int maxStackSize = contentsStack.func_77976_d();
                int max = Math.min(contentsStack.field_77994_a - maxStackSize * i, maxStackSize);
                stacks.add(StackUtils.copyStack(contentsStack, Math.min(contentsStack.field_77994_a, max)));
            }
            totalStacks += numStacks;
        }
        ArrayList<ItemStack> resultStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < amount; ++i) {
            resultStacks.add((ItemStack)stacks.remove(RandomUtils.getInt(stacks.size())));
        }
        return resultStacks;
    }

    public List<ItemStack> pickAndRemoveItemStacks(int amount) {
        List<ItemStack> stacks = this.pickItemStacks(amount);
        for (ItemStack stack : stacks) {
            this.removeItems(stack);
        }
        return stacks;
    }

    public void addWatcher(ICrateWatcher watcher) {
        this.watchers.add(watcher);
    }

    public void removeWatcher(ICrateWatcher watcher) {
        this.watchers.remove(watcher);
    }

    private void updateContentsArray() {
        if (this.contentsArray == null || this.contentsArray.length > this.getNumItems() * 2 + 16) {
            this.contentsArray = new ItemStack[this.getNumItems() + 16];
        }
        this.contentsArray = this.contents.values().toArray(this.contentsArray);
    }

    private void markDirty() {
        if (this.destroyed) {
            return;
        }
        this.collection.markDirty(this);
    }

    public NBTTagCompound toCompound() {
        NBTTagCompound compound = new NBTTagCompound("");
        compound.func_74777_a("numCrates", (short)this.getNumCrates());
        NBTTagList stacks = new NBTTagList("stacks");
        for (ItemStack stack : this) {
            NBTTagCompound stackCompound = new NBTTagCompound("");
            stackCompound.func_74777_a("id", (short)stack.field_77993_c);
            stackCompound.func_74768_a("Count", stack.field_77994_a);
            stackCompound.func_74777_a("Damage", (short)stack.func_77960_j());
            if (stack.func_77942_o()) {
                stackCompound.func_74766_a("tag", stack.func_77978_p());
            }
            stacks.func_74742_a((NBTBase)stackCompound);
        }
        compound.func_74782_a("stacks", (NBTBase)stacks);
        if (this.map != null) {
            compound.func_74766_a("map", this.map.toCompound());
        }
        return compound;
    }

    public static CratePileData fromCompound(CratePileCollection collection, int crateId, NBTTagCompound compound) {
        short numCrates = compound.func_74765_d("numCrates");
        CratePileData pileData = new CratePileData(collection, crateId, numCrates);
        NBTTagList stacks = compound.func_74761_m("stacks");
        for (int j = 0; j < stacks.func_74745_c(); ++j) {
            NBTTagCompound stackCompound = (NBTTagCompound)stacks.func_74743_b(j);
            short id = stackCompound.func_74765_d("id");
            int count = stackCompound.func_74762_e("Count");
            short damage = stackCompound.func_74765_d("Damage");
            ItemStack stack = new ItemStack((int)id, count, (int)damage);
            if (stackCompound.func_74764_b("tag")) {
                stack.field_77990_d = stackCompound.func_74775_l("tag");
            }
            if (stack.func_77973_b() == null) continue;
            pileData.addItems(stack, false);
        }
        if (compound.func_74764_b("map")) {
            pileData.map = CratePileMap.fromCompound(compound.func_74775_l("map"));
        }
        return pileData;
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return this.contents.values().iterator();
    }
}

