/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.crate;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.item.tile.ItemTileBetterStorage;
import net.mcft.copy.betterstorage.misc.ConnectedTexture;
import net.mcft.copy.betterstorage.tile.TileContainerBetterStorage;
import net.mcft.copy.betterstorage.tile.crate.TileEntityCrate;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;

public class TileCrate
extends TileContainerBetterStorage {
    private ConnectedTexture texture = new ConnectedTextureCrate();

    public TileCrate(int id) {
        super(id, Material.field_76245_d);
        this.func_71848_c(2.0f);
        this.func_71884_a(Block.field_71967_e);
        MinecraftForge.setBlockHarvestLevel((Block)this, (String)"axe", (int)0);
    }

    @Override
    public Class<? extends Item> getItemClass() {
        return ItemTileBetterStorage.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.texture.registerIcons(iconRegister, "betterstorage:crate/%s");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        return this.texture.getIcon("all");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        return this.texture.getConnectedIcon(world, x, y, z, ForgeDirection.getOrientation((int)side));
    }

    public TileEntity func_72274_a(World world) {
        return new TileEntityCrate();
    }

    public void onBlockPlacedExtended(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, EntityLivingBase entity, ItemStack stack) {
        TileEntityCrate crate = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityCrate.class);
        if (stack.func_82837_s()) {
            crate.setCustomTitle(stack.func_82833_r());
        }
        crate.attemptConnect(ForgeDirection.getOrientation((int)side).getOpposite());
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityCrate.class).openGui(player);
        return true;
    }

    public boolean func_96468_q_() {
        return true;
    }

    private class ConnectedTextureCrate
    extends ConnectedTexture {
        private ConnectedTextureCrate() {
        }

        @Override
        public boolean canConnect(IBlockAccess world, int x, int y, int z, ForgeDirection side, ForgeDirection connected) {
            if (world.func_72798_a(x, y, z) != TileCrate.this.field_71990_ca) {
                return false;
            }
            int offX = x + connected.offsetX;
            int offY = y + connected.offsetY;
            int offZ = z + connected.offsetZ;
            TileEntityCrate connectedCrate = WorldUtils.get(world, offX, offY, offZ, TileEntityCrate.class);
            if (connectedCrate == null) {
                return false;
            }
            TileEntityCrate crate = WorldUtils.get(world, x, y, z, TileEntityCrate.class);
            return crate.getID() == connectedCrate.getID();
        }
    }
}

