/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.crate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.mcft.copy.betterstorage.api.ICrateStorage;
import net.mcft.copy.betterstorage.api.ICrateWatcher;
import net.mcft.copy.betterstorage.config.GlobalConfig;
import net.mcft.copy.betterstorage.container.ContainerBetterStorage;
import net.mcft.copy.betterstorage.container.ContainerCrate;
import net.mcft.copy.betterstorage.content.Tiles;
import net.mcft.copy.betterstorage.inventory.InventoryCratePlayerView;
import net.mcft.copy.betterstorage.tile.crate.CratePileCollection;
import net.mcft.copy.betterstorage.tile.crate.CratePileData;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.mcft.copy.betterstorage.utils.PlayerUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityCrate
extends TileEntityContainer
implements IInventory,
ICrateStorage,
ICrateWatcher {
    private static final ForgeDirection[] sideDirections = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};
    public static final int slotsPerCrate = 18;
    private CratePileData data;
    private int id = -1;
    private boolean watcherRegistered = false;

    public int getID() {
        return this.id;
    }

    public CratePileData getPileData() {
        if (this.field_70331_k.field_72995_K) {
            throw new IllegalStateException("Can't be called client-side.");
        }
        if (this.data == null) {
            CratePileCollection collection = CratePileCollection.getCollection(this.field_70331_k);
            if (this.id == -1) {
                this.setPileData(collection.createCratePile(), true);
            } else {
                this.setPileData(collection.getCratePile(this.id), false);
            }
        }
        return this.data;
    }

    private void setPileData(CratePileData data, boolean addCrate) {
        if (this.data != null) {
            this.data.removeCrate(this);
        }
        this.data = data;
        if (data != null) {
            this.id = data.id;
            this.markForUpdate();
            if (addCrate) {
                data.addCrate(this);
            }
        } else {
            this.id = -1;
        }
    }

    private void checkPileConnections(CratePileData data) {
        int x = this.field_70329_l;
        int y = this.field_70330_m;
        int z = this.field_70327_n;
        TileEntityCrate crateAbove = WorldUtils.get((IBlockAccess)this.field_70331_k, x, y + 1, z, TileEntityCrate.class);
        if (crateAbove != null && crateAbove.data == data) {
            this.field_70331_k.func_94571_i(x, y + 1, z);
            crateAbove.dropItem(new ItemStack((Block)Tiles.crate));
        }
        if (data.getNumCrates() > 0 && y == data.getRegion().minY) {
            ArrayList<HashSet<TileEntityCrate>> crateSets = new ArrayList<HashSet<TileEntityCrate>>();
            int checkedChecks = 0;
            block0: for (ForgeDirection dir : sideDirections) {
                int nx = x + dir.offsetX;
                int nz = z + dir.offsetZ;
                TileEntityCrate neighborCrate = WorldUtils.get((IBlockAccess)this.field_70331_k, nx, y, nz, TileEntityCrate.class);
                if (neighborCrate == null || neighborCrate.id != this.id) continue;
                for (HashSet hashSet : crateSets) {
                    if (!hashSet.contains(neighborCrate)) continue;
                    continue block0;
                }
                HashSet<TileEntityCrate> set = new HashSet<TileEntityCrate>();
                set.add(neighborCrate);
                for (ForgeDirection ndir : sideDirections) {
                    this.checkConnections(nx + ndir.offsetX, y, nz + ndir.offsetZ, set);
                }
                crateSets.add(set);
                if ((checkedChecks += set.size()) == data.getNumCrates()) break;
            }
            if (crateSets.size() > 0) {
                for (int i = 1; i < crateSets.size(); ++i) {
                    HashSet set = (HashSet)crateSets.get(i);
                    CratePileData newPileData = data.collection.createCratePile();
                    int numCrates = set.size();
                    for (TileEntityCrate newPileCrate : set) {
                        newPileCrate.setPileData(newPileData, true);
                        while ((newPileCrate = WorldUtils.get((IBlockAccess)this.field_70331_k, newPileCrate.field_70329_l, newPileCrate.field_70330_m + 1, newPileCrate.field_70327_n, TileEntityCrate.class)) != null) {
                            newPileCrate.setPileData(newPileData, true);
                            ++numCrates;
                        }
                    }
                    int count = numCrates * data.getOccupiedSlots() / (data.getNumCrates() + numCrates);
                    List<ItemStack> stacks = data.pickAndRemoveItemStacks(count);
                    stacks = newPileData.addItems(stacks);
                }
                data.trimMap();
            }
        }
    }

    private void checkConnections(int x, int y, int z, HashSet<TileEntityCrate> set) {
        TileEntityCrate crate = WorldUtils.get((IBlockAccess)this.field_70331_k, x, y, z, TileEntityCrate.class);
        if (crate == null || set.contains(crate)) {
            return;
        }
        set.add(crate);
        for (ForgeDirection ndir : sideDirections) {
            this.checkConnections(x + ndir.offsetX, y, z + ndir.offsetZ, set);
        }
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.field_70331_k.field_72995_K || this.data != null) {
            return;
        }
        if (!this.func_70320_p()) {
            this.getPileData();
        }
    }

    public void attemptConnect(ForgeDirection side) {
        if (this.field_70331_k.field_72995_K || side == ForgeDirection.UP) {
            return;
        }
        int x = this.field_70329_l + side.offsetX;
        int y = this.field_70330_m + side.offsetY;
        int z = this.field_70327_n + side.offsetZ;
        TileEntityCrate crateClicked = WorldUtils.get((IBlockAccess)this.field_70331_k, x, y, z, TileEntityCrate.class);
        if (crateClicked == null) {
            return;
        }
        CratePileData pileData = crateClicked.getPileData();
        if (pileData.canAdd(this)) {
            this.setPileData(pileData, true);
        }
    }

    public void func_70313_j() {
        super.func_70313_j();
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        CratePileData data = this.getPileData();
        if (this.watcherRegistered) {
            data.removeWatcher(this);
        }
        this.setPileData(null, false);
        this.dropOverflowContents(data);
        this.checkPileConnections(data);
    }

    private void dropItem(ItemStack stack) {
        WorldUtils.dropStackFromBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, stack);
    }

    private void dropItems(List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            this.dropItem(stack);
        }
    }

    private void dropOverflowContents(CratePileData data) {
        int amount = -data.getFreeSlots();
        this.dropItems(data.pickAndRemoveItemStacks(amount));
    }

    @Override
    protected int getSizeContents() {
        return 0;
    }

    @Override
    public String getName() {
        return "container.betterstorage.crate";
    }

    @Override
    public void openGui(EntityPlayer player) {
        if (!this.canPlayerUseContainer(player)) {
            return;
        }
        PlayerUtils.openGui(player, this.getName(), this.getColumns(), 2 * Math.min(this.data.getNumCrates(), 3), this.getContainerTitle(), this.createContainer(player));
    }

    @Override
    public ContainerBetterStorage createContainer(EntityPlayer player) {
        return new ContainerCrate(player, new InventoryCratePlayerView(this));
    }

    @Override
    protected int getComparatorSignalStengthInternal() {
        if (this.field_70331_k.field_72995_K) {
            return 0;
        }
        CratePileData data = this.getPileData();
        return data.getOccupiedSlots() > 0 ? 1 + data.getOccupiedSlots() * 14 / data.getCapacity() : 0;
    }

    @Override
    protected void markComparatorAccessed() {
        super.markComparatorAccessed();
        if (!this.watcherRegistered && !this.field_70331_k.field_72995_K) {
            this.getPileData().addWatcher(this);
            this.watcherRegistered = true;
        }
    }

    @Override
    protected void comparatorUpdateAndReset() {
        super.comparatorUpdateAndReset();
        if (this.watcherRegistered && !this.hasComparatorAccessed()) {
            this.getPileData().removeWatcher(this);
            this.watcherRegistered = false;
        }
    }

    @Override
    public void onCrateItemsModified(ItemStack stack) {
        this.markContentsChanged();
    }

    public String func_70303_b() {
        return this.getName();
    }

    public int func_70297_j_() {
        return 64;
    }

    public int func_70302_i_() {
        if (!((Boolean)GlobalConfig.enableCrateInventoryInterfaceSetting.getValue()).booleanValue()) {
            return 0;
        }
        if (this.field_70331_k.field_72995_K) {
            return 1;
        }
        return this.getPileData().blockView.func_70302_i_();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (!((Boolean)GlobalConfig.enableCrateInventoryInterfaceSetting.getValue()).booleanValue()) {
            return false;
        }
        return this.getPileData().blockView.func_94041_b(slot, stack);
    }

    public ItemStack func_70301_a(int slot) {
        if (!((Boolean)GlobalConfig.enableCrateInventoryInterfaceSetting.getValue()).booleanValue()) {
            return null;
        }
        return this.getPileData().blockView.func_70301_a(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (((Boolean)GlobalConfig.enableCrateInventoryInterfaceSetting.getValue()).booleanValue()) {
            this.getPileData().blockView.func_70299_a(slot, stack);
        }
    }

    public ItemStack func_70304_b(int slot) {
        if (!((Boolean)GlobalConfig.enableCrateInventoryInterfaceSetting.getValue()).booleanValue()) {
            return null;
        }
        return this.getPileData().blockView.func_70304_b(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (!((Boolean)GlobalConfig.enableCrateInventoryInterfaceSetting.getValue()).booleanValue()) {
            return null;
        }
        return this.getPileData().blockView.func_70298_a(slot, amount);
    }

    @Override
    public void func_70296_d() {
        if (((Boolean)GlobalConfig.enableCrateInventoryInterfaceSetting.getValue()).booleanValue()) {
            this.getPileData().blockView.func_70296_d();
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public boolean func_94042_c() {
        return false;
    }

    public void func_70295_k_() {
        this.getPileData().blockView.func_70295_k_();
    }

    public void func_70305_f() {
        this.getPileData().blockView.func_70305_f();
    }

    @Override
    public Object getInventoryIdentifier(ForgeDirection side) {
        return this.getPileData();
    }

    @Override
    public List<ItemStack> getContents(ForgeDirection side) {
        if (!((Boolean)GlobalConfig.enableCrateStorageInterfaceSetting.getValue()).booleanValue()) {
            return Collections.EMPTY_LIST;
        }
        return this.getPileData().getContents();
    }

    @Override
    public int getItemCount(ForgeDirection side, ItemStack identifier) {
        if (!((Boolean)GlobalConfig.enableCrateStorageInterfaceSetting.getValue()).booleanValue()) {
            return 0;
        }
        return this.getPileData().getItemCount(identifier);
    }

    @Override
    public int spaceForItem(ForgeDirection side, ItemStack identifier) {
        if (!((Boolean)GlobalConfig.enableCrateStorageInterfaceSetting.getValue()).booleanValue()) {
            return 0;
        }
        return this.getPileData().spaceForItem(identifier);
    }

    @Override
    public ItemStack insertItems(ForgeDirection side, ItemStack stack) {
        if (!((Boolean)GlobalConfig.enableCrateStorageInterfaceSetting.getValue()).booleanValue()) {
            return stack;
        }
        return this.getPileData().addItems(stack);
    }

    @Override
    public ItemStack extractItems(ForgeDirection side, ItemStack stack) {
        if (!((Boolean)GlobalConfig.enableCrateStorageInterfaceSetting.getValue()).booleanValue()) {
            return null;
        }
        return this.getPileData().removeItems(stack);
    }

    @Override
    public void registerCrateWatcher(ICrateWatcher watcher) {
        if (((Boolean)GlobalConfig.enableCrateStorageInterfaceSetting.getValue()).booleanValue()) {
            this.getPileData().addWatcher(watcher);
        }
    }

    @Override
    public void unregisterCrateWatcher(ICrateWatcher watcher) {
        if (((Boolean)GlobalConfig.enableCrateStorageInterfaceSetting.getValue()).booleanValue()) {
            this.getPileData().removeWatcher(watcher);
        }
    }

    public Packet func_70319_e() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("crateId", this.id);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, compound);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.id = packet.field_73331_e.func_74762_e("crateId");
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void func_70307_a(NBTTagCompound compound) {
        super.func_70307_a(compound);
        this.id = compound.func_74762_e("crateId");
    }

    @Override
    public void func_70310_b(NBTTagCompound compound) {
        super.func_70310_b(compound);
        compound.func_74768_a("crateId", this.id);
        CratePileData data = this.getPileData();
        CratePileCollection collection = CratePileCollection.getCollection(this.field_70331_k);
        if (collection.getDirtyPiles().remove(data)) {
            collection.save(data);
        }
    }
}

