/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet103SetSlot;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;

public class TileEntityArmorStand
extends TileEntityContainer {
    public ItemStack[] armor = new ItemStack[4];
    public int rotation = 0;

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return WorldUtils.getAABB(this, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    @Override
    public String getName() {
        return "container.betterstorage.armorStand";
    }

    @Override
    public boolean canSetCustomTitle() {
        return false;
    }

    @Override
    protected int getSizeContents() {
        return 0;
    }

    @Override
    public void onBlockPlaced(EntityLivingBase player, ItemStack stack) {
        super.onBlockPlaced(player, stack);
        this.rotation = Math.round((player.field_70759_as + 180.0f) * 16.0f / 360.0f);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int slot = Math.min(3, (int)(hitY * 2.0f));
        ItemStack item = this.armor[slot];
        ItemStack holding = player.func_71045_bC();
        ItemStack playerArmor = player.field_71071_by.field_70460_b[slot];
        if (player.func_70093_af()) {
            if (!(item == null && playerArmor == null || playerArmor != null && !playerArmor.func_77973_b().isValidArmor(playerArmor, 3 - slot, (Entity)player))) {
                this.armor[slot] = playerArmor;
                player.field_71071_by.field_70460_b[slot] = item;
                PacketDispatcher.sendPacketToPlayer((Packet)new Packet103SetSlot(0, 8 - slot, item), (Player)((Player)player));
                this.markForUpdate();
                this.func_70296_d();
            }
        } else if (item != null && holding == null || holding != null && holding.func_77973_b().isValidArmor(holding, 3 - slot, (Entity)player)) {
            this.armor[slot] = holding;
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = item;
            this.markForUpdate();
            this.func_70296_d();
        }
        return true;
    }

    @Override
    public ItemStack onPickBlock(ItemStack block, MovingObjectPosition target) {
        int y = (int)((target.field_72307_f.field_72448_b - (double)this.field_70330_m) * 2.0);
        ItemStack result = y >= 0 && y < 4 ? this.armor[y] : null;
        return result != null ? result.func_77946_l() : block;
    }

    @Override
    public void dropContents() {
        for (ItemStack stack : this.armor) {
            WorldUtils.dropStackFromBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, stack);
        }
    }

    @Override
    protected int getComparatorSignalStengthInternal() {
        int count = 0;
        for (ItemStack stack : this.armor) {
            if (stack == null) continue;
            ++count;
        }
        return count;
    }

    public Packet func_70319_e() {
        NBTTagCompound compound = new NBTTagCompound();
        this.write(compound);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, compound);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        NBTTagCompound compound = packet.field_73331_e;
        this.read(compound);
    }

    @Override
    public void func_70307_a(NBTTagCompound compound) {
        super.func_70307_a(compound);
        this.read(compound);
    }

    @Override
    public void func_70310_b(NBTTagCompound compound) {
        super.func_70310_b(compound);
        this.write(compound);
    }

    public void read(NBTTagCompound compound) {
        this.rotation = compound.func_74771_c("rotation");
        NBTTagList items = compound.func_74761_m("Items");
        this.armor = new ItemStack[this.armor.length];
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = (NBTTagCompound)items.func_74743_b(i);
            int slot = item.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.armor.length) continue;
            this.armor[slot] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
    }

    public void write(NBTTagCompound compound) {
        compound.func_74774_a("rotation", (byte)this.rotation);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.armor.length; ++i) {
            if (this.armor[i] == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            this.armor[i].func_77955_b(item);
            list.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("Items", (NBTBase)list);
    }
}

