/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.item.ItemBackpack;
import net.mcft.copy.betterstorage.misc.PropertiesBackpack;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.util.MovingObjectPosition;

public class TileEntityBackpack
extends TileEntityContainer {
    private int despawnTime = -1;
    public ItemStack stack;
    public boolean equipped = false;

    public void equip(EntityLivingBase carrier) {
        this.equipped = true;
        ItemBackpack.setBackpack(carrier, this.stack, this.contents);
    }

    public void unequip(EntityLivingBase carrier, boolean despawn) {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        PropertiesBackpack backpackData = ItemBackpack.getBackpackData(carrier);
        if (backpackData.contents != null) {
            System.arraycopy(backpackData.contents, 0, this.contents, 0, Math.min(this.contents.length, backpackData.contents.length));
            backpackData.contents = null;
        }
        if (despawn) {
            this.despawnTime = 0;
        }
    }

    @Override
    public String getName() {
        return "container.betterstorage.backpack";
    }

    @Override
    public int getRows() {
        return BetterStorage.globalConfig.getInteger("settings.backpackRows");
    }

    @Override
    protected boolean doesSyncPlayers() {
        return true;
    }

    @Override
    public boolean onBlockBreak(EntityPlayer player) {
        if (!this.field_70331_k.field_72995_K && player.func_70093_af() && ItemBackpack.canEquipBackpack(player)) {
            this.equip((EntityLivingBase)player);
        }
        return super.onBlockBreak(player);
    }

    @Override
    public void dropContents() {
        if (this.equipped) {
            return;
        }
        if (!this.brokenInCreative) {
            WorldUtils.dropStackFromBlock(this, this.stack);
        }
        super.dropContents();
    }

    @Override
    public ItemStack onPickBlock(ItemStack block, MovingObjectPosition target) {
        return ItemStack.func_77944_b((ItemStack)this.stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onBlockRenderAsItem(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    protected float getLidSpeed() {
        return 0.2f;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        double x = (double)this.field_70329_l + 0.5;
        double y = (double)this.field_70330_m + 0.5;
        double z = (double)this.field_70327_n + 0.5;
        String sound = Block.field_82509_m.func_72675_d();
        if (this.lidAngle > 0.0f && this.prevLidAngle <= 0.0f) {
            this.field_70331_k.func_72908_a(x, y, z, sound, 1.0f, 0.6f);
        }
        if (this.lidAngle < 0.2f && this.prevLidAngle >= 0.2f) {
            this.field_70331_k.func_72908_a(x, y, z, sound, 0.8f, 0.4f);
        }
        if (this.despawnTime < 0) {
            return;
        }
        if (this.despawnTime++ > 6000) {
            this.equipped = true;
            this.field_70331_k.func_94571_i(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        } else if (this.despawnTime % 40 == 0 && this.field_70331_k.func_72977_a(x, y, z, 24.0) != null) {
            this.despawnTime = -1;
        }
    }

    public Packet func_70319_e() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74766_a("stack", this.stack.func_77955_b(new NBTTagCompound()));
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, compound);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        NBTTagCompound compound = packet.field_73331_e;
        this.stack = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("stack"));
    }

    @Override
    public void func_70307_a(NBTTagCompound compound) {
        super.func_70307_a(compound);
        this.stack = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("stack"));
        this.despawnTime = compound.func_74762_e("despawnTime");
        if (this.despawnTime == 0) {
            this.despawnTime = -1;
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound compound) {
        super.func_70310_b(compound);
        compound.func_74766_a("stack", this.stack.func_77955_b(new NBTTagCompound()));
        compound.func_74768_a("despawnTime", this.despawnTime);
    }
}

