/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import net.mcft.copy.betterstorage.config.GlobalConfig;
import net.mcft.copy.betterstorage.container.ContainerBetterStorage;
import net.mcft.copy.betterstorage.container.ContainerCraftingStation;
import net.mcft.copy.betterstorage.inventory.InventoryCraftingStation;
import net.mcft.copy.betterstorage.inventory.InventoryTileEntity;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.mcft.copy.betterstorage.utils.NbtUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityCraftingStation
extends TileEntityContainer
implements IInventory,
ISidedInventory {
    public ItemStack[] crafting;
    public ItemStack[] output;
    private InventoryCraftingStation stationInventory;
    private static int[] slotsAny = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
    private static int[] slotsBottom = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};

    @Override
    protected int getSizeContents() {
        return 18;
    }

    @Override
    public String getName() {
        return "container.betterstorage.craftingStation";
    }

    @Override
    public InventoryTileEntity makePlayerInventory() {
        this.crafting = new ItemStack[9];
        this.output = new ItemStack[9];
        this.stationInventory = new InventoryCraftingStation(this);
        return new InventoryTileEntity((TileEntityContainer)this, this.stationInventory);
    }

    @Override
    public ContainerBetterStorage createContainer(EntityPlayer player) {
        return new ContainerCraftingStation(player, (IInventory)this.getPlayerInventory());
    }

    @Override
    public void func_70316_g() {
        this.stationInventory.update();
    }

    @Override
    public void dropContents() {
        for (ItemStack stack : this.crafting) {
            WorldUtils.dropStackFromBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, stack);
        }
        if (this.stationInventory.outputIsReal) {
            for (ItemStack stack : this.output) {
                WorldUtils.dropStackFromBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, stack);
            }
        }
        super.dropContents();
    }

    public String func_70303_b() {
        return this.getName();
    }

    public boolean func_94042_c() {
        return !this.shouldLocalizeTitle();
    }

    public int func_70297_j_() {
        return 64;
    }

    public int func_70302_i_() {
        return this.getPlayerInventory().func_70302_i_() - 9;
    }

    public ItemStack func_70301_a(int slot) {
        return this.getPlayerInventory().func_70301_a(slot + 9);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.getPlayerInventory().func_70299_a(slot + 9, stack);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.getPlayerInventory().func_70298_a(slot + 9, amount);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.getPlayerInventory().func_94041_b(slot + 9, stack);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.getPlayerInventory().func_70300_a(player);
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        this.stationInventory.func_70296_d();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int[] func_94128_d(int side) {
        return side == 0 ? slotsBottom : slotsAny;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return side != 0;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return side != 0 || (Boolean)GlobalConfig.enableStationAutoCraftingSetting.getValue() != false && this.stationInventory.canTake(null);
    }

    @Override
    public void func_70307_a(NBTTagCompound compound) {
        super.func_70307_a(compound);
        NbtUtils.readItems(this.crafting, compound.func_74761_m("Crafting"));
        if (compound.func_74764_b("Output")) {
            NbtUtils.readItems(this.output, compound.func_74761_m("Output"));
        }
        this.stationInventory.progress = compound.func_74762_e("progress");
        this.stationInventory.outputIsReal = compound.func_74764_b("Output");
        this.stationInventory.inputChanged();
        this.stationInventory.func_70296_d();
    }

    @Override
    public void func_70310_b(NBTTagCompound compound) {
        super.func_70310_b(compound);
        compound.func_74782_a("Crafting", (NBTBase)NbtUtils.writeItems(this.crafting));
        if (this.stationInventory.outputIsReal) {
            compound.func_74782_a("Output", (NBTBase)NbtUtils.writeItems(this.output));
        }
        compound.func_74768_a("progress", this.stationInventory.progress);
    }
}

