/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.utils;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.addon.thaumcraft.GuiThaumiumChest;
import net.mcft.copy.betterstorage.client.gui.GuiBetterStorage;
import net.mcft.copy.betterstorage.client.gui.GuiCraftingStation;
import net.mcft.copy.betterstorage.client.gui.GuiCrate;
import net.mcft.copy.betterstorage.container.ContainerKeyring;
import net.mcft.copy.betterstorage.inventory.InventoryCardboardBox;
import net.mcft.copy.betterstorage.inventory.InventoryWrapper;
import net.mcft.copy.betterstorage.misc.handlers.PacketHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;

public final class PlayerUtils {
    private PlayerUtils() {
    }

    public static void openGui(EntityPlayer pl, String name, int columns, int rows, String title, Container container) {
        EntityPlayerMP player = (EntityPlayerMP)pl;
        if (title == null) {
            title = "";
        }
        player.func_71128_l();
        player.func_71117_bO();
        Packet packet = PacketHandler.makePacket((byte)0, player.field_71139_cq, name, (byte)columns, (byte)rows, title);
        PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)((Player)player));
        player.field_71070_bA = container;
        player.field_71070_bA.field_75152_c = player.field_71139_cq;
        player.field_71070_bA.func_75132_a((ICrafting)player);
    }

    @SideOnly(value=Side.CLIENT)
    public static void openGui(EntityPlayer player, String name, int columns, int rows, String title) {
        GuiScreen gui = PlayerUtils.createGuiFromName(player, name, columns, rows, title);
        Minecraft.func_71410_x().func_71373_a(gui);
    }

    @SideOnly(value=Side.CLIENT)
    private static GuiScreen createGuiFromName(EntityPlayer player, String name, int columns, int rows, String title) {
        boolean localized;
        boolean bl = localized = !title.isEmpty();
        if (!localized) {
            title = name;
        }
        if (name.equals("container.betterstorage.crate")) {
            return new GuiCrate(player, rows, title, localized);
        }
        if (name.equals("container.betterstorage.keyring")) {
            return new GuiBetterStorage(new ContainerKeyring(player, title, columns));
        }
        if (name.startsWith("container.betterstorage.thaumiumChest")) {
            return new GuiThaumiumChest(player, columns, rows, title, localized);
        }
        if (name.equals("container.betterstorage.cardboardBox")) {
            return new GuiBetterStorage(player, columns, rows, new InventoryWrapper(new InventoryCardboardBox(new ItemStack[columns * rows]), title, localized));
        }
        if (name.equals("container.betterstorage.craftingStation")) {
            return new GuiCraftingStation(player, title, localized);
        }
        return new GuiBetterStorage(player, columns, rows, title, localized);
    }
}

