/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.mcft.copy.betterstorage.api.IContainerItem;
import net.mcft.copy.betterstorage.api.lock.IKey;
import net.mcft.copy.betterstorage.api.lock.ILock;
import net.mcft.copy.betterstorage.utils.NbtUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class StackUtils {
    private StackUtils() {
    }

    public static NBTBase getTag(ItemStack stack, String ... tags) {
        if (!stack.func_77942_o()) {
            return null;
        }
        String tag = null;
        NBTTagCompound compound = stack.func_77978_p();
        for (int i = 0; i < tags.length; ++i) {
            tag = tags[i];
            if (!compound.func_74764_b(tag)) {
                return null;
            }
            if (i == tags.length - 1) break;
            compound = compound.func_74775_l(tag);
        }
        return compound.func_74781_a(tag);
    }

    public static String getType(ItemStack stack, String ... tags) {
        NBTBase tag = StackUtils.getTag(stack, tags);
        return tag != null ? NBTBase.field_82578_b[tag.func_74732_a()] : null;
    }

    public static <T> T get(ItemStack stack, T defaultValue, String ... tags) {
        NBTBase tag = StackUtils.getTag(stack, tags);
        return tag != null ? NbtUtils.getTagValue(tag) : defaultValue;
    }

    public static void set(ItemStack stack, NBTBase nbtTag, String ... tags) {
        NBTTagCompound compound;
        String tag = null;
        if (!stack.func_77942_o()) {
            compound = new NBTTagCompound();
            stack.func_77982_d(compound);
        } else {
            compound = stack.func_77978_p();
        }
        for (int i = 0; i < tags.length; ++i) {
            tag = tags[i];
            if (i == tags.length - 1) break;
            if (!compound.func_74764_b(tag)) {
                NBTTagCompound newCompound = new NBTTagCompound(tag);
                compound.func_74766_a(tag, newCompound);
                compound = newCompound;
                continue;
            }
            compound = compound.func_74775_l(tag);
        }
        compound.func_74782_a(tag, nbtTag);
    }

    public static <T> void set(ItemStack stack, T value, String ... tags) {
        StackUtils.set(stack, NbtUtils.createTag(null, value), tags);
    }

    public static boolean has(ItemStack stack, String ... tags) {
        if (!stack.func_77942_o()) {
            return false;
        }
        String tag = null;
        NBTTagCompound compound = stack.func_77978_p();
        for (int i = 0; i < tags.length; ++i) {
            tag = tags[i];
            if (!compound.func_74764_b(tag)) {
                return false;
            }
            if (i == tags.length - 1) break;
            compound = compound.func_74775_l(tag);
        }
        return compound.func_74764_b(tag);
    }

    public static void remove(ItemStack stack, String ... tags) {
        if (!stack.func_77942_o()) {
            return;
        }
        String tag = null;
        NBTTagCompound compound = stack.func_77978_p();
        for (int i = 0; i < tags.length; ++i) {
            tag = tags[i];
            if (!compound.func_74764_b(tag)) {
                return;
            }
            if (i == tags.length - 1) break;
            compound = compound.func_74775_l(tag);
        }
        compound.func_82580_o(tag);
    }

    public static ItemStack copyStack(ItemStack stack, int stackSize) {
        return StackUtils.copyStack(stack, stackSize, true);
    }

    public static ItemStack copyStack(ItemStack stack, int stackSize, boolean checkSize) {
        if (stack == null || checkSize && stackSize <= 0) {
            return null;
        }
        ItemStack copy = new ItemStack(stack.field_77993_c, stackSize, stack.func_77960_j());
        if (stack.field_77990_d != null) {
            copy.field_77990_d = (NBTTagCompound)stack.field_77990_d.func_74737_b();
        }
        return copy;
    }

    public static boolean matches(int id1, int damage1, NBTTagCompound data1, int id2, int damage2, NBTTagCompound data2) {
        return id1 == id2 && damage1 == damage2 && StackUtils.nbtEquals(data1, data2);
    }

    public static boolean nbtEquals(NBTTagCompound nbt1, NBTTagCompound nbt2) {
        return nbt1 == nbt2 || nbt1 != null && nbt2 != null && nbt1.func_74738_o("tag").equals((Object)nbt2.func_74738_o("tag"));
    }

    public static boolean matches(ItemStack stack1, ItemStack stack2, boolean matchNBT) {
        return stack1 == null ? stack2 == null : stack2 != null && StackUtils.matches(stack1.field_77993_c, stack1.func_77960_j(), matchNBT ? stack1.func_77978_p() : null, stack2.field_77993_c, stack2.func_77960_j(), matchNBT ? stack2.func_77978_p() : null);
    }

    public static boolean matches(ItemStack stack1, ItemStack stack2) {
        return StackUtils.matches(stack1, stack2, true);
    }

    public static Map<Integer, StackEnchantment> getEnchantments(ItemStack stack) {
        NBTTagList list;
        HashMap<Integer, StackEnchantment> enchantments = new HashMap<Integer, StackEnchantment>();
        NBTTagList nBTTagList = list = stack.func_77973_b() == Item.field_92105_bW ? Item.field_92105_bW.func_92110_g(stack) : stack.func_77986_q();
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                StackEnchantment ench = new StackEnchantment(stack, (NBTTagCompound)list.func_74743_b(i));
                enchantments.put(ench.ench.field_77352_x, ench);
            }
        }
        return enchantments;
    }

    public static boolean isEnchantmentCompatible(ItemStack stack, Collection<StackEnchantment> stackEnchants, StackEnchantment newEnchant) {
        if (!newEnchant.ench.func_92089_a(stack)) {
            return false;
        }
        for (StackEnchantment stackEnch : stackEnchants) {
            if (!(newEnchant.ench == stackEnch.ench ? newEnchant.getLevel() <= stackEnch.getLevel() : !newEnchant.ench.func_77326_a(stackEnch.ench) || !stackEnch.ench.func_77326_a(newEnchant.ench))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEnchantmentCompatible(ItemStack stack, StackEnchantment newEnchant) {
        return StackUtils.isEnchantmentCompatible(stack, StackUtils.getEnchantments(stack).values(), newEnchant);
    }

    public static int calcNumStacks(ItemStack stack, int count) {
        int maxStackSize = stack.func_77976_d();
        return (count + maxStackSize - 1) / maxStackSize;
    }

    public static int calcNumStacks(ItemStack stack) {
        return StackUtils.calcNumStacks(stack, stack.field_77994_a);
    }

    public static ItemStack[] getStackContents(ItemStack stack, int size) {
        ItemStack[] contents = new ItemStack[size];
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_74764_b("Items")) {
            NbtUtils.readItems(contents, compound.func_74761_m("Items"));
        }
        return contents;
    }

    public static void setStackContents(ItemStack stack, ItemStack[] contents) {
        StackUtils.set(stack, (NBTBase)NbtUtils.writeItems(contents), "Items");
    }

    public static boolean isEmpty(ItemStack[] items) {
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isKey(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof IKey;
    }

    public static boolean isLock(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ILock;
    }

    public static boolean canBeStoredInContainerItem(ItemStack item) {
        return item != null && item.func_77973_b() instanceof IContainerItem ? ((IContainerItem)item.func_77973_b()).canBeStoredInContainerItem(item) : true;
    }

    public static class StackEnchantment {
        public final ItemStack stack;
        public final Enchantment ench;
        private final NBTTagCompound entry;

        public int getLevel() {
            return this.entry.func_74765_d("lvl");
        }

        public void setLevel(int level) {
            this.entry.func_74777_a("lvl", (short)level);
        }

        public StackEnchantment(ItemStack stack, NBTTagCompound entry) {
            this.stack = stack;
            this.entry = entry;
            this.ench = Enchantment.field_77331_b[entry.func_74765_d("id")];
        }
    }
}

