/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.gui;

import openblocks.common.container.ContainerDigitalFuse;
import openblocks.common.tileentity.TileEntityDigitalFuse;
import openmods.container.ContainerBase;
import openmods.gui.BaseGuiContainer;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.GuiComponentSlider;
import openmods.sync.SyncableInt;

public class GuiDigitalFuse
extends BaseGuiContainer<ContainerDigitalFuse> {
    private GuiComponentSlider sliderTimer;
    private GuiComponentSlider sliderReset;
    private GuiComponentLabel timerLabel;
    private GuiComponentLabel resetLabel;
    private SyncableInt fauxClientTimer;

    public GuiDigitalFuse(ContainerDigitalFuse container) {
        super((ContainerBase)container, 176, 177, "openblocks.gui.digitalfuse");
        TileEntityDigitalFuse fuse = (TileEntityDigitalFuse)((Object)container.getOwner());
        SyncableInt resetTime = fuse.getResetTime();
        final SyncableInt timeLeft = fuse.getTimeLeft();
        this.fauxClientTimer = new SyncableInt(timeLeft.getValue());
        this.sliderTimer = new GuiComponentSlider(45, 25, 115, 0, 800, this.fauxClientTimer){

            public void onMouseUp() {
                timeLeft.setValue(GuiDigitalFuse.this.fauxClientTimer.getValue());
            }

            public String formatValue(int value) {
                return String.format("%02d:%02d", value % 3600 / 60, value % 60);
            }
        };
        this.sliderReset = new GuiComponentSlider(45, 57, 115, 0, 800, resetTime){

            public String formatValue(int value) {
                return String.format("%02d:%02d", value % 3600 / 60, value % 60);
            }
        };
        this.timerLabel = new GuiComponentLabel(10, 27, "Timer:");
        this.resetLabel = new GuiComponentLabel(10, 59, "Reset:");
        this.root.addComponent((BaseComponent)this.sliderTimer);
        this.root.addComponent((BaseComponent)this.sliderReset);
        this.root.addComponent((BaseComponent)this.timerLabel);
        this.root.addComponent((BaseComponent)this.resetLabel);
    }

    public void preRender(float mouseX, float mouseY) {
        super.preRender(mouseX, mouseY);
        SyncableInt timeLeft = ((TileEntityDigitalFuse)((Object)((ContainerDigitalFuse)this.getContainer()).getOwner())).getTimeLeft();
        if (!this.sliderTimer.isDragging()) {
            this.fauxClientTimer.setValue(timeLeft.getValue());
        }
    }
}

