/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatMessageComponent;
import openblocks.common.PlayerInventoryStore;
import openmods.Log;
import openmods.utils.CommandUtils;

public class CommandInventory
implements ICommand {
    private static final String COMMAND_RESTORE = "restore";
    private static final String COMMAND_STORE = "store";
    private static final String NAME = "ob_inventory";
    private static final List<String> SUB_COMMANDS = Lists.newArrayList((Object[])new String[]{"store", "restore"});

    public int compareTo(Object o) {
        return NAME.compareTo(((ICommand)o).func_71517_b());
    }

    public String func_71517_b() {
        return NAME;
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "ob_inventory store <player> OR ob_inventory restore <player> <file>";
    }

    public List func_71514_a() {
        return null;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length < 2) {
            throw new SyntaxErrorException();
        }
        String subCommand = args[0];
        String playerName = args[1];
        EntityPlayerMP player = CommandUtils.getPlayer((ICommandSender)sender, (String)playerName);
        if (subCommand.equalsIgnoreCase(COMMAND_RESTORE)) {
            if (args.length != 3) {
                throw new SyntaxErrorException();
            }
            String id = args[2];
            try {
                if (!PlayerInventoryStore.instance.restoreInventory((EntityPlayer)player, id)) {
                    throw new CommandException("openblocks.misc.cant_restore", new Object[]{playerName});
                }
                sender.func_70006_a(ChatMessageComponent.func_111082_b((String)"openblocks.misc.restored_inventory", (Object[])new Object[]{playerName}));
            }
            catch (Exception e) {
                Log.warn((Throwable)e, (String)"Failed to restore inventory, player %s, file %s", (Object[])new Object[]{playerName, id});
                throw new CommandException("openblocks.misc.cant_restore", new Object[]{playerName});
            }
        } else if (subCommand.equalsIgnoreCase(COMMAND_STORE)) {
            try {
                File result = PlayerInventoryStore.instance.storePlayerInventory((EntityPlayer)player);
                sender.func_70006_a(ChatMessageComponent.func_111082_b((String)"openblocks.misc.stored_inventory", (Object[])new Object[]{result.getAbsolutePath()}));
            }
            catch (Exception e) {
                Log.warn((Throwable)e, (String)"Failed to store inventory, player %s, file %s", (Object[])new Object[]{playerName});
                throw new CommandException("openblocks.misc.cant_Store", new Object[]{playerName});
            }
        } else {
            throw new SyntaxErrorException();
        }
    }

    public boolean func_71519_b(ICommandSender sender) {
        return sender.func_70003_b(4, NAME);
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandUtils.filterPrefixes((String)args[0], SUB_COMMANDS);
        }
        if (args.length == 2) {
            return CommandUtils.fiterPlayerNames((String)args[1]);
        }
        if (args.length == 3) {
            String subCommand = args[0];
            String prefix = args[2];
            if (subCommand.equalsIgnoreCase(COMMAND_RESTORE)) {
                return PlayerInventoryStore.instance.getMatchedDumps(sender.func_130014_f_(), prefix);
            }
        }
        return null;
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 1;
    }
}

