/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import openblocks.Config;
import openblocks.OpenBlocks;
import openmods.Log;
import openmods.config.ConfigurationChange;
import openmods.utils.BlockUtils;
import openmods.utils.PlayerUtils;

public class EntityEventHandler {
    public static final String OPENBLOCKS_PERSIST_TAG = "OpenBlocks";
    public static final String GIVEN_MANUAL_TAG = "givenManual";
    public static final String LATEST_CHANGELOG_TAG = "latestChangelog";
    private Set<Class<?>> entityBlacklist;

    private Set<Class<?>> getBlacklist() {
        if (this.entityBlacklist == null) {
            this.entityBlacklist = Sets.newIdentityHashSet();
            HashSet unknownNames = Sets.newHashSet();
            for (String name : Config.disableMobNames) {
                Class cls = (Class)EntityList.field_75625_b.get(name);
                if (cls != null) {
                    this.entityBlacklist.add(cls);
                    continue;
                }
                unknownNames.add(name);
            }
            for (Class cls : EntityList.field_75626_c.keySet()) {
                if (unknownNames.isEmpty()) break;
                if (!unknownNames.remove(cls.getName())) continue;
                this.entityBlacklist.add(cls);
            }
            if (!unknownNames.isEmpty()) {
                Log.warn((String)"Can't identify mobs for blacklist: %s", (Object[])new Object[]{unknownNames});
            }
        }
        return this.entityBlacklist;
    }

    @ForgeSubscribe
    public void onReconfigure(ConfigurationChange.Post evt) {
        if (evt.check("additional", "disableMobNames")) {
            this.entityBlacklist = null;
        }
    }

    @ForgeSubscribe
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Set<Class<?>> blacklist;
        Entity entity = event.entity;
        if (entity != null && (blacklist = this.getBlacklist()).contains(entity.getClass())) {
            entity.func_70106_y();
            return;
        }
        if (!event.world.field_72995_K && entity instanceof EntityPlayer) {
            boolean shouldGiveChangelog;
            boolean shouldGiveManual;
            EntityPlayer player = (EntityPlayer)entity;
            NBTTagCompound persistTag = PlayerUtils.getModPlayerPersistTag((EntityPlayer)player, (String)OPENBLOCKS_PERSIST_TAG);
            boolean bl = shouldGiveManual = OpenBlocks.Items.infoBook != null && !persistTag.func_74767_n(GIVEN_MANUAL_TAG);
            if (shouldGiveManual) {
                ItemStack manual = new ItemStack((Item)OpenBlocks.Items.infoBook);
                if (!player.field_71071_by.func_70441_a(manual)) {
                    BlockUtils.dropItemStackInWorld((World)player.field_70170_p, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)manual);
                }
                persistTag.func_74757_a(GIVEN_MANUAL_TAG, true);
            }
            boolean bl2 = shouldGiveChangelog = OpenBlocks.changeLog != null && !persistTag.func_74779_i(LATEST_CHANGELOG_TAG).equals("1.2.9");
            if (shouldGiveChangelog) {
                ItemStack changeLog = OpenBlocks.changeLog.func_77946_l();
                if (!player.field_71071_by.func_70441_a(changeLog)) {
                    BlockUtils.dropItemStackInWorld((World)player.field_70170_p, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)changeLog);
                }
                persistTag.func_74778_a(LATEST_CHANGELOG_TAG, "1.2.9");
            }
        }
    }
}

