/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.Config;
import openblocks.common.block.OpenBlock;

public class BlockSponge
extends OpenBlock {
    private static final int TICK_RATE = 100;
    private static final Random RANDOM = new Random();

    public BlockSponge() {
        super(Config.blockSpongeId, Material.field_76252_l);
        this.func_71884_a(field_71975_k);
        this.func_71907_b(true);
    }

    public boolean shouldRenderBlock() {
        return true;
    }

    public void func_71863_a(World world, int x, int y, int z, int blockId) {
        this.clearupLiquid(world, x, y, z);
    }

    public int func_71859_p_(World par1World) {
        return 100;
    }

    public void onBlockPlacedBy(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, ForgeDirection side, float hitX, float hitY, float hitZ, int meta) {
        this.clearupLiquid(world, x, y, z);
        world.func_72836_a(x, y, z, this.field_71990_ca, 100 + RANDOM.nextInt(5));
    }

    private void clearupLiquid(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        boolean hitLava = false;
        for (int dx = -Config.spongeRange; dx <= Config.spongeRange; ++dx) {
            for (int dy = -Config.spongeRange; dy <= Config.spongeRange; ++dy) {
                for (int dz = -Config.spongeRange; dz <= Config.spongeRange; ++dz) {
                    Material material = world.func_72803_f(x + dx, y + dy, z + dz);
                    if (!material.func_76224_d()) continue;
                    hitLava |= material == Material.field_76256_h;
                    world.func_72832_d(x + dx, y + dy, z + dz, 0, 0, 2);
                }
            }
        }
        if (hitLava) {
            world.func_72965_b(x, y, z, this.field_71990_ca, 0, 0);
        }
    }

    public boolean func_71883_b(World world, int x, int y, int z, int eventId, int eventParam) {
        if (world.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                double px = (double)x + RANDOM.nextDouble() * 0.1;
                double py = (double)y + 1.0 + RANDOM.nextDouble();
                double pz = (double)z + RANDOM.nextDouble();
                world.func_72869_a("largesmoke", px, py, pz, 0.0, 0.0, 0.0);
            }
        } else {
            world.func_72832_d(x, y, z, Block.field_72067_ar.field_71990_ca, 0, 3);
        }
        return true;
    }

    public void func_71847_b(World world, int x, int y, int z, Random random) {
        this.clearupLiquid(world, x, y, z);
        world.func_72836_a(x, y, z, this.field_71990_ca, 100 + RANDOM.nextInt(5));
    }
}

