/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import openblocks.OpenBlocks;
import openblocks.client.gui.GuiBigButton;
import openblocks.common.container.ContainerBigButton;
import openmods.GenericInventory;
import openmods.IInventoryProvider;
import openmods.api.IActivateAwareTile;
import openmods.api.IHasGui;
import openmods.api.ISurfaceAttachment;
import openmods.include.IExtendable;
import openmods.include.IncludeInterface;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableFlags;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityBigButton
extends SyncedTileEntity
implements IActivateAwareTile,
ISurfaceAttachment,
IHasGui,
IExtendable,
IInventoryProvider {
    private int tickCounter = 0;
    private SyncableFlags flags;
    private final GenericInventory inventory = new GenericInventory("bigbutton", true, 1);

    protected void createSyncedFields() {
        this.flags = new SyncableFlags();
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && this.tickCounter > 0) {
            --this.tickCounter;
            if (this.tickCounter <= 0) {
                this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "random.click", 0.3f, 0.5f);
                this.flags.off((Enum)Flags.active);
                this.sync();
            }
        }
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerBigButton((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiBigButton(new ContainerBigButton((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return false;
    }

    public int getTickTime() {
        ItemStack stack = this.inventory.func_70301_a(0);
        return stack == null ? 1 : stack.field_77994_a;
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!this.field_70331_k.field_72995_K) {
            if (player.func_70093_af()) {
                this.openGui(OpenBlocks.instance, player);
            } else {
                this.flags.on((Enum)Flags.active);
                this.tickCounter = this.getTickTime();
                this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "random.click", 0.3f, 0.6f);
                this.sync();
            }
        }
        return true;
    }

    public ForgeDirection getSurfaceDirection() {
        return this.getRotation();
    }

    @SideOnly(value=Side.CLIENT)
    public void prepareForInventoryRender(Block block, int metadata) {
        super.prepareForInventoryRender(block, metadata);
    }

    public void onServerSync(Set<ISyncableObject> changed) {
        super.onServerSync(changed);
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, OpenBlocks.Blocks.bigButton.field_71990_ca);
        ForgeDirection rot = this.getRotation();
        this.field_70331_k.func_72898_h(this.field_70329_l + rot.offsetX, this.field_70330_m + rot.offsetY, this.field_70327_n + rot.offsetZ, OpenBlocks.Blocks.bigButton.field_71990_ca);
    }

    public void onSynced(Set<ISyncableObject> changes) {
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isButtonActive() {
        return this.flags.get((Enum)Flags.active);
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.inventory.readFromNBT(tag);
    }

    @IncludeInterface
    public IInventory getInventory() {
        return this.inventory;
    }

    public static enum Flags {
        active;

    }
}

