/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import openblocks.OpenBlocks;
import openblocks.common.block.BlockFlag;
import openmods.api.IActivateAwareTile;
import openmods.api.IPlaceAwareTile;
import openmods.api.ISurfaceAttachment;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableFloat;
import openmods.sync.SyncableInt;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.BlockUtils;

public class TileEntityFlag
extends SyncedTileEntity
implements ISurfaceAttachment,
IPlaceAwareTile,
IActivateAwareTile {
    private SyncableFloat angle;
    private SyncableInt colorIndex;

    protected void createSyncedFields() {
        this.angle = new SyncableFloat(0.0f);
        this.colorIndex = new SyncableInt(0);
    }

    protected void initialize() {
    }

    public void onSynced(Set<ISyncableObject> changes) {
    }

    public Icon getIcon() {
        return OpenBlocks.Blocks.flag.func_71858_a(0, 0);
    }

    public void setColorIndex(int index) {
        this.colorIndex.setValue(index);
    }

    public void setAngle(float ang) {
        this.angle.setValue(ang);
    }

    public int getColor() {
        if (this.colorIndex.getValue() >= BlockFlag.COLORS.length) {
            this.colorIndex.setValue(0);
        }
        return BlockFlag.COLORS[this.colorIndex.getValue()];
    }

    public ForgeDirection getSurfaceDirection() {
        return this.getRotation();
    }

    public float getAngle() {
        return this.angle.getValue();
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player != null && player.func_70093_af()) {
            return true;
        }
        if (!this.field_70331_k.field_72995_K && this.getSurfaceDirection() == ForgeDirection.DOWN) {
            this.angle.setValue(this.angle.getValue() + 10.0f);
            this.sync();
            return false;
        }
        return true;
    }

    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        float ang = player.field_70759_as;
        ForgeDirection rotation = this.getRotation();
        if (rotation != ForgeDirection.DOWN) {
            ang = -BlockUtils.getRotationFromDirection((ForgeDirection)side.getOpposite());
        }
        this.setAngle(ang);
        this.setColorIndex(stack.func_77960_j());
        this.sync();
    }

    @SideOnly(value=Side.CLIENT)
    public void prepareForInventoryRender(Block block, int metadata) {
        super.prepareForInventoryRender(block, metadata);
        this.setColorIndex(metadata);
    }
}

