/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.common.MagnetWhitelists;
import openblocks.common.entity.EntityMiniMe;
import openmods.api.IBreakAwareTile;
import openmods.api.IPlaceAwareTile;
import openmods.entity.EntityBlock;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableInt;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityGoldenEgg
extends SyncedTileEntity
implements IPlaceAwareTile,
IBreakAwareTile {
    private static final float SPEED_CHANGE_RATE = 0.1f;
    private static final Random RANDOM = new Random();
    private static final String MR_GLITCH = "Mikeemoo";
    private static final int STAGE_CHANGE_TICK = 100;
    private static final int RISING_TIME = 400;
    private static final int FALLING_TIME = 10;
    public static final int MAX_HEIGHT = 5;
    private static final double STAGE_CHANGE_CHANCE = 0.8;
    public int tickCounter;
    private float rotation;
    private float progress;
    private float rotationSpeed;
    private float progressSpeed;
    private List<EntityBlock> blocks = Lists.newArrayList();
    private SyncableInt stage;
    private String owner = "";

    public float getRotation(float partialTickTime) {
        return this.rotation + this.rotationSpeed * partialTickTime;
    }

    public float getProgress(float partialTickTime) {
        return this.progress + this.progressSpeed * partialTickTime;
    }

    public float getOffset(float partialTickTime) {
        return this.getProgress(partialTickTime) * 5.0f;
    }

    public State tryRandomlyChangeState(int delay, State nextState) {
        return this.tickCounter % delay == 0 && RANDOM.nextDouble() < 0.8 ? nextState : null;
    }

    protected void createSyncedFields() {
        this.stage = new SyncableInt(State.INERT.ordinal());
    }

    private void pickUpBlock(int x, int y, int z) {
        EntityBlock block = EntityBlock.create((World)this.field_70331_k, (int)x, (int)y, (int)z);
        if (block != null) {
            block.setHasAirResistance(false);
            block.setHasGravity(false);
            block.setShouldDrop(false);
            block.field_70181_x = 0.1;
            this.blocks.add(block);
            this.field_70331_k.func_72838_d((Entity)block);
        }
    }

    private void dropBlocks() {
        for (EntityBlock block : this.blocks) {
            block.setShouldDrop(true);
            block.field_70181_x = -0.9;
            block.setHasGravity(true);
        }
        this.blocks.clear();
    }

    private void explode() {
        this.field_70331_k.func_94571_i(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72876_a(null, 0.5 + (double)this.field_70329_l, 0.5 + (double)this.field_70330_m, 0.5 + (double)this.field_70327_n, 2.0f, true);
        if (Strings.isNullOrEmpty((String)this.owner)) {
            this.owner = MR_GLITCH;
        }
        EntityMiniMe miniMe = new EntityMiniMe(this.field_70331_k, this.owner);
        miniMe.func_70080_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, 0.0f, 0.0f);
        this.field_70331_k.func_72838_d((Entity)miniMe);
    }

    public State getState() {
        int stateId = this.stage.getValue();
        if (stateId < 0 || stateId >= State.STATES.length) {
            return State.INERT;
        }
        return State.STATES[stateId];
    }

    public void func_70316_g() {
        super.func_70316_g();
        State state = this.getState();
        if (this.field_70331_k.field_72995_K) {
            this.rotationSpeed = 0.9f * this.rotationSpeed + 0.1f * state.rotationSpeed;
            this.rotation += this.rotationSpeed;
            this.progressSpeed = 0.9f * this.progressSpeed + 0.1f * state.progressSpeed;
            this.progress += this.progressSpeed;
        } else {
            state.onServerTick(this);
            State nextState = state.getNextState(this);
            if (nextState != null) {
                this.stage.setValue(nextState.ordinal());
                nextState.onEntry(this);
                this.sync();
            }
        }
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74778_a("owner", this.owner);
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.owner = nbt.func_74779_i("owner");
    }

    public void onSynced(Set<ISyncableObject> changes) {
    }

    public void onBlockBroken() {
        this.dropBlocks();
    }

    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        if (player != null) {
            this.owner = player.field_71092_bJ;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l, -1024.0, (double)this.field_70327_n, (double)(this.field_70329_l + 1), 1024.0, (double)(this.field_70327_n + 1));
    }

    public static enum State {
        INERT(0.0f, 0.0f, false){

            @Override
            public State getNextState(TileEntityGoldenEgg target) {
                return target.tryRandomlyChangeState(100, ROTATING_SLOW);
            }

            @Override
            public void onServerTick(TileEntityGoldenEgg target) {
                ++target.tickCounter;
            }
        }
        ,
        ROTATING_SLOW(1.0f, 0.0f, false){

            @Override
            public State getNextState(TileEntityGoldenEgg target) {
                return target.tryRandomlyChangeState(100, ROTATING_MEDIUM);
            }

            @Override
            public void onServerTick(TileEntityGoldenEgg target) {
                ++target.tickCounter;
            }
        }
        ,
        ROTATING_MEDIUM(10.0f, 0.0f, false){

            @Override
            public State getNextState(TileEntityGoldenEgg target) {
                return target.tryRandomlyChangeState(100, ROTATING_FAST);
            }

            @Override
            public void onServerTick(TileEntityGoldenEgg target) {
                ++target.tickCounter;
            }
        }
        ,
        ROTATING_FAST(50.0f, 0.0f, false){

            @Override
            public State getNextState(TileEntityGoldenEgg target) {
                return target.tryRandomlyChangeState(100, FLOATING);
            }

            @Override
            public void onServerTick(TileEntityGoldenEgg target) {
                ++target.tickCounter;
            }
        }
        ,
        FLOATING(100.0f, 0.0025f, true){

            @Override
            public void onEntry(TileEntityGoldenEgg target) {
                target.tickCounter = 400;
            }

            @Override
            public void onServerTick(TileEntityGoldenEgg target) {
                int posZ;
                int posY;
                --target.tickCounter;
                if (RANDOM.nextInt(6) != 0) {
                    return;
                }
                int posX = target.field_70329_l + RANDOM.nextInt(20) - 10;
                boolean canMove = MagnetWhitelists.instance.testBlock(target.field_70331_k, posX, posY = target.field_70330_m + RANDOM.nextInt(2) - 1, posZ = target.field_70327_n + RANDOM.nextInt(20) - 10);
                if (canMove) {
                    target.pickUpBlock(posX, posY, posZ);
                }
            }

            @Override
            public State getNextState(TileEntityGoldenEgg target) {
                return target.tickCounter <= 0 ? FALLING : null;
            }
        }
        ,
        FALLING(150.0f, -0.1f, true){

            @Override
            public void onEntry(TileEntityGoldenEgg target) {
                target.tickCounter = 10;
                target.dropBlocks();
            }

            @Override
            public void onServerTick(TileEntityGoldenEgg target) {
                --target.tickCounter;
            }

            @Override
            public State getNextState(TileEntityGoldenEgg target) {
                return target.tickCounter <= 0 ? EXPLODING : null;
            }
        }
        ,
        EXPLODING(666.0f, 0.0f, true){

            @Override
            public void onEntry(TileEntityGoldenEgg target) {
                target.explode();
            }

            @Override
            public State getNextState(TileEntityGoldenEgg target) {
                return null;
            }
        };

        public final float rotationSpeed;
        public final float progressSpeed;
        public final boolean specialEffects;
        private static final State[] STATES;

        public void onEntry(TileEntityGoldenEgg target) {
        }

        public void onServerTick(TileEntityGoldenEgg target) {
        }

        public abstract State getNextState(TileEntityGoldenEgg var1);

        private State(float rotationSpeed, float riseSpeed, boolean specialEffects) {
            this.rotationSpeed = rotationSpeed;
            this.progressSpeed = riseSpeed;
            this.specialEffects = specialEffects;
        }

        static {
            STATES = State.values();
        }
    }
}

