/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraftforge.common.MinecraftForge;
import shukaro.artifice.ArtificeBlocks;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeItems;
import shukaro.artifice.ArtificeTooltips;
import shukaro.artifice.event.ArtificeEventHandler;
import shukaro.artifice.net.ClientPacketHandler;
import shukaro.artifice.net.ClientProxy;
import shukaro.artifice.net.CommonProxy;
import shukaro.artifice.net.ServerPacketHandler;
import shukaro.artifice.recipe.ArtificeRecipes;
import shukaro.artifice.util.BlockCoord;
import shukaro.artifice.util.ChunkCoord;
import shukaro.artifice.world.ArtificeWorldGen;

@Mod(modid="Artifice", name="Artifice", version="1.6.4R1.1.3")
@NetworkMod(clientSideRequired=true, serverSideRequired=false, clientPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"Artifice"}, packetHandler=ClientPacketHandler.class), serverPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"Artifice"}, packetHandler=ServerPacketHandler.class))
public class ArtificeCore {
    @SidedProxy(clientSide="shukaro.artifice.net.ClientProxy", serverSide="shukaro.artifice.net.CommonProxy")
    public static CommonProxy proxy;
    public static final String modID = "Artifice";
    public static final String modName = "Artifice";
    public static final String modChannel = "Artifice";
    public static final String modVersion = "1.6.4R1.1.3";
    public static ArtificeWorldGen worldGen;
    public static Logger logger;
    public static ArtificeEventHandler eventHandler;
    public static final String[] tiers;
    public static final String[] flora;
    public static final String[] rocks;
    @SideOnly(value=Side.CLIENT)
    public static ConcurrentHashMap<ChunkCoord, ConcurrentHashMap<BlockCoord, int[]>> textureCache;
    @Mod.Instance(value="Artifice")
    public static ArtificeCore instance;

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent evt) {
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        logger = evt.getModLog();
        ArtificeConfig.initClient(evt);
        ArtificeConfig.initCommon(evt);
        eventHandler = new ArtificeEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        CommonProxy.init();
        if (evt.getSide() == Side.CLIENT) {
            ClientProxy.init();
        }
        ArtificeBlocks.initBlocks();
        ArtificeItems.initItems();
        if (ArtificeConfig.enableWorldGen.getBoolean(true)) {
            worldGen = new ArtificeWorldGen();
            GameRegistry.registerWorldGenerator((IWorldGenerator)worldGen);
        }
        if (ArtificeConfig.floraBoneMeal.getBoolean(true) && ArtificeConfig.enableWorldGen.getBoolean(true)) {
            MinecraftForge.addGrassPlant((Block)ArtificeBlocks.blockFlora, (int)0, (int)10);
            MinecraftForge.addGrassPlant((Block)ArtificeBlocks.blockFlora, (int)1, (int)10);
            MinecraftForge.addGrassPlant((Block)ArtificeBlocks.blockFlora, (int)2, (int)10);
            MinecraftForge.addGrassPlant((Block)ArtificeBlocks.blockFlora, (int)3, (int)10);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        ArtificeTooltips.initTooltips();
        ArtificeRecipes.registerRecipes();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
    }

    static {
        tiers = new String[]{"Basic", "Reinforced", "Industrial", "Advanced"};
        flora = new String[]{"Bluebell", "Orchid", "Iris", "Lotus", "LotusClosed"};
        rocks = new String[]{"", "Cobblestone", "Brick", "Paver", "Antipaver", "Chiseled"};
    }
}

