/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.block.frame;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeCore;
import shukaro.artifice.block.frame.BlockFrame;
import shukaro.artifice.render.TextureHandler;
import shukaro.artifice.render.connectedtexture.ConnectedTextures;
import shukaro.artifice.util.BlockCoord;
import shukaro.artifice.util.ChunkCoord;
import shukaro.artifice.util.PacketWrapper;

public class BlockFrameBlastWall
extends BlockFrame {
    public BlockFrameBlastWall(int id) {
        super(id);
        this.func_71864_b("artifice.reinforced");
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int meta = world.func_72805_g(x, y, z);
        return this.getResistance(meta);
    }

    public float getResistance(int meta) {
        switch (meta) {
            case 0: {
                return 20.0f;
            }
            case 1: {
                return 30.0f;
            }
            case 2: {
                return 50.0f;
            }
            case 3: {
                return 80.0f;
            }
        }
        return 10.0f;
    }

    @Override
    public float func_71934_m(World world, int x, int y, int z) {
        return super.func_71934_m(world, x, y, z) + 5.0f;
    }

    @Override
    public boolean func_71926_d() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister reg) {
        ArtificeConfig.registerConnectedTextures(reg);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        if (meta >= ArtificeCore.tiers.length) {
            meta = 0;
        }
        switch (meta) {
            case 0: {
                return ConnectedTextures.BasicBlastWall.textureList[0];
            }
            case 1: {
                return ConnectedTextures.ReinforcedBlastWall.textureList[0];
            }
            case 2: {
                return ConnectedTextures.IndustrialBlastWall.textureList[0];
            }
            case 3: {
                return ConnectedTextures.AdvancedBlastWall.textureList[0];
            }
        }
        return ConnectedTextures.BasicBlastWall.textureList[0];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess access, int x, int y, int z, int side) {
        int meta = access.func_72805_g(x, y, z);
        if (meta > ArtificeCore.tiers.length) {
            meta = 0;
        }
        BlockCoord coord = new BlockCoord(x, y, z);
        boolean found = false;
        for (ChunkCoord sector : ArtificeCore.textureCache.keySet()) {
            if (!ArtificeCore.textureCache.get(sector).containsKey(coord)) continue;
            found = true;
        }
        if (!found) {
            TextureHandler.updateTexture(coord);
        }
        if (TextureHandler.getConnectedTexture(this.func_71858_a(side, meta)) != null && ArtificeCore.textureCache.containsKey(new ChunkCoord(coord)) && ArtificeCore.textureCache.get(new ChunkCoord(coord)).get(coord) != null) {
            return TextureHandler.getConnectedTexture((Icon)this.func_71858_a((int)side, (int)meta)).textureList[ArtificeCore.textureCache.get(new ChunkCoord(coord)).get(coord)[side]];
        }
        return this.func_71858_a(side, meta);
    }

    public void func_71863_a(World world, int x, int y, int z, int neighborID) {
        if (!world.field_72995_K) {
            BlockCoord c = new BlockCoord(x, y, z);
            PacketDispatcher.sendPacketToAllAround((double)c.x, (double)c.y, (double)c.z, (double)192.0, (int)world.field_73011_w.field_76574_g, (Packet)PacketWrapper.createPacket("Artifice", 2, new Object[]{c.x, c.y, c.z}));
        }
    }

    @Override
    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }
}

