/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.event;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Level;
import net.minecraft.world.World;
import shukaro.artifice.ArtificeCore;
import shukaro.artifice.util.ChunkCoord;

public class WorldTicker
implements ITickHandler {
    public static HashMap chunksToGen = new HashMap();
    private int count = 0;

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        World world = (World)tickData[0];
        int dim = world.field_73011_w.field_76574_g;
        ArrayList chunks = (ArrayList)chunksToGen.get(dim);
        if (chunks != null && chunks.size() > 0) {
            ++this.count;
            ChunkCoord c = (ChunkCoord)chunks.get(0);
            long worldSeed = world.func_72905_C();
            Random rand = new Random(worldSeed);
            long xSeed = rand.nextLong() >> 3;
            long zSeed = rand.nextLong() >> 3;
            rand.setSeed(xSeed * (long)c.chunkX + zSeed * (long)c.chunkZ ^ worldSeed);
            ArtificeCore.worldGen.generateWorld(rand, c.chunkX, c.chunkZ, world, false);
            chunks.remove(0);
            chunksToGen.put(dim, chunks);
            ArtificeCore.logger.log(Level.INFO, "Regenerated " + this.count + " chunks. " + Math.max(0, chunks.size()) + " chunks left");
        }
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.WORLD);
    }

    public String getLabel() {
        return "Artifice.World";
    }
}

