/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeTooltips;
import shukaro.artifice.compat.ArtificeRegistry;
import shukaro.artifice.gui.ArtificeCreativeTab;
import shukaro.artifice.render.IconHandler;
import shukaro.artifice.util.IdMetaPair;

public class ItemSledge
extends ItemTool {
    private Icon icon;
    private int lossChance;

    public ItemSledge(int id, EnumToolMaterial mat) {
        super(id, 2.0f, mat, null);
        this.func_77637_a(ArtificeCreativeTab.main);
        this.func_77656_e(mat.func_77997_a() / 4);
        this.func_77655_b("artifice.sledge." + this.field_77862_b.toString().toLowerCase(Locale.ENGLISH));
        this.lossChance = this.getLossChance(mat);
    }

    public int getLossChance(EnumToolMaterial mat) {
        switch (mat) {
            case EMERALD: {
                return 20;
            }
            case GOLD: {
                return 25;
            }
            case IRON: {
                return 30;
            }
            case STONE: {
                return 40;
            }
            case WOOD: {
                return 50;
            }
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List infoList, boolean advancedTooltips) {
        if (!ArtificeConfig.tooltips.getBoolean(true)) {
            return;
        }
        IdMetaPair pair = new IdMetaPair(stack.field_77993_c, 0);
        if (ArtificeRegistry.getTooltipMap().get(pair) != null) {
            for (String s : ArtificeRegistry.getTooltipMap().get(pair)) {
                if (!ArtificeConfig.flavorText.getBoolean(true) && s.startsWith(ArtificeTooltips.commentCode)) continue;
                infoList.add(s);
            }
        }
    }

    public boolean func_77641_a(Block block) {
        if (ArtificeRegistry.getWildSledgeBlocks().get(block.field_71990_ca) != null) {
            return true;
        }
        for (int i = 0; i < 16; ++i) {
            if (ArtificeRegistry.getSledgeBlocks().get(new IdMetaPair(block.field_71990_ca, i)) == null) continue;
            return true;
        }
        return false;
    }

    public float getStrVsBlock(ItemStack stack, Block block, int meta) {
        IdMetaPair pair = new IdMetaPair(block.field_71990_ca, meta);
        if (ArtificeRegistry.getWildSledgeBlocks().get(block.field_71990_ca) != null || ArtificeRegistry.getSledgeBlocks().get(pair) != null) {
            return this.field_77862_b.func_77998_b();
        }
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77617_a(int meta) {
        return this.icon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister reg) {
        this.icon = IconHandler.registerSingle(reg, "sledge_" + this.field_77862_b.toString().toLowerCase(Locale.ENGLISH), "sledge");
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        World world = player.field_70170_p;
        if (world.field_72995_K || player.field_71075_bZ.field_75098_d) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        try {
            int id = world.func_72798_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            IdMetaPair pair = new IdMetaPair(id, meta);
            ArrayList<ItemStack> dropped = ArtificeRegistry.getWildSledgeBlocks().get(id);
            if (dropped == null) {
                dropped = ArtificeRegistry.getSledgeBlocks().get(pair);
            }
            if (dropped != null) {
                for (ItemStack is : dropped) {
                    if (world.field_73012_v.nextInt(100) <= this.lossChance) continue;
                    world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, is.func_77946_l()));
                }
                world.func_94571_i(x, y, z);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }

    public boolean func_77660_a(ItemStack stack, World world, int id, int x, int y, int z, EntityLivingBase entity) {
        int meta = world.func_72805_g(x, y, z);
        IdMetaPair pair = new IdMetaPair(id, meta);
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.field_71075_bZ.field_75098_d) {
                return true;
            }
        }
        if (ArtificeRegistry.getSledgeBlocks().get(pair) != null) {
            stack.func_77972_a(1, entity);
        }
        return true;
    }
}

