/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.World;
import shukaro.artifice.compat.ArtificeRegistry;
import shukaro.artifice.util.BlockCoord;
import shukaro.artifice.util.ChunkCoord;

public class WorldGenCluster {
    private World world;
    private Random rand;
    private int id;
    private int maxHeight;
    private Set<Integer> replaced;
    private BlockCoord c;
    private List<BlockCoord> blocks;

    public WorldGenCluster(World world, Random rand, int id, int maxHeight) {
        this(world, rand, id, maxHeight, ArtificeRegistry.getStoneTypes());
    }

    public WorldGenCluster(World world, Random rand, int id, int maxHeight, Set<Integer> replaced) {
        this.world = world;
        this.rand = rand;
        this.id = id;
        this.maxHeight = maxHeight;
        this.replaced = replaced;
        this.blocks = new ArrayList<BlockCoord>();
    }

    public boolean generate(int size, int chunkX, int chunkZ) {
        ChunkCoord chunk = new ChunkCoord(chunkX, chunkZ);
        boolean doGen = false;
        int threshold = size / 8;
        int tries = this.rand.nextInt(16) + 4;
        for (int i = 0; i < tries; ++i) {
            int x = (chunkX << 4) + this.rand.nextInt(16);
            int y = this.rand.nextInt(this.maxHeight);
            int z = (chunkZ << 4) + this.rand.nextInt(16);
            this.c = new BlockCoord(x, y, z);
            if (!this.canGenHere(this.world, chunk, this.c)) continue;
            doGen = true;
            break;
        }
        if (!doGen) {
            return false;
        }
        int genned = 0;
        while (genned < size) {
            for (BlockCoord t : this.c.getAdjacent()) {
                if (!this.canGenHere(this.world, chunk, t)) continue;
                this.blocks.add(t);
            }
            if (this.blocks.size() == 0) break;
            this.c.set(this.blocks.get(this.rand.nextInt(this.blocks.size())));
            this.blocks.remove(this.c);
            this.world.func_72832_d(this.c.x, this.c.y, this.c.z, this.id, 0, 0);
            ++genned;
            while (this.blocks.size() > threshold && genned < size && this.blocks.size() != 0) {
                this.c.set(this.blocks.get(this.rand.nextInt(this.blocks.size())));
                this.blocks.remove(this.c);
                this.world.func_72832_d(this.c.x, this.c.y, this.c.z, this.id, 0, 0);
                ++genned;
            }
        }
        return true;
    }

    public boolean canGenHere(World world, ChunkCoord c, BlockCoord b) {
        return c.contains(b) && b.getBlock(world) != null && this.replaced.contains(b.getBlockID(world));
    }
}

