/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.world;

import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import shukaro.artifice.ArtificeBlocks;
import shukaro.artifice.util.ChunkCoord;

public class WorldGenLily {
    private World world;
    private Random rand;

    public WorldGenLily(World world, Random rand) {
        this.world = world;
        this.rand = rand;
    }

    public boolean generate(int chunkX, int chunkZ) {
        int xMin = chunkX << 4;
        int zMin = chunkZ << 4;
        int startX = xMin + this.rand.nextInt(16);
        int startZ = zMin + this.rand.nextInt(16);
        if (this.rand.nextInt(10) > 4) {
            return false;
        }
        BiomeGenBase biome = this.world.func_72807_a(startX, startZ);
        if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            return false;
        }
        int tries = this.rand.nextInt(16) + 8;
        ChunkCoord c = new ChunkCoord(chunkX, chunkZ);
        for (int l = 0; l < tries; ++l) {
            int x = startX + this.rand.nextInt(8) - this.rand.nextInt(8);
            int z = startZ + this.rand.nextInt(8) - this.rand.nextInt(8);
            int y = this.world.func_72976_f(x, z);
            if (!c.contains(x, z) || !this.world.func_72799_c(x, y, z) || !ArtificeBlocks.blockLotus.func_71930_b(this.world, x, y, z)) continue;
            if (this.world.func_72820_D() > 12000L) {
                this.world.func_72832_d(x, y, z, ArtificeBlocks.blockLotus.field_71990_ca, 1, 0);
                continue;
            }
            this.world.func_72832_d(x, y, z, ArtificeBlocks.blockLotus.field_71990_ca, 0, 0);
        }
        return true;
    }
}

