/*
 * Decompiled with CFR 0.152.
 */
package enhancedcore.packet;

import cpw.mods.fml.common.network.PacketDispatcher;
import enhancedcore.world.BlockPosition;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;

public class PacketHelper {
    public static byte[] getByteArray(Object ... objects) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(8);
        DataOutputStream stream = new DataOutputStream(byteStream);
        try {
            for (Object obj : objects) {
                Object[] arr;
                if (obj instanceof Integer) {
                    stream.writeInt(Integer.parseInt(obj.toString()));
                    continue;
                }
                if (obj instanceof int[]) {
                    arr = (int[])obj;
                    stream.writeInt(arr.length);
                    for (int i : arr) {
                        stream.writeInt(i);
                    }
                    continue;
                }
                if (obj instanceof String) {
                    stream.writeUTF(obj.toString());
                    continue;
                }
                if (obj instanceof String[]) {
                    arr = (String[])obj;
                    stream.writeInt(arr.length);
                    for (int s : arr) {
                        stream.writeUTF((String)s);
                    }
                    continue;
                }
                if (obj instanceof Byte) {
                    stream.writeByte(Byte.parseByte(obj.toString()));
                    continue;
                }
                if (obj instanceof byte[]) {
                    arr = (byte[])obj;
                    stream.writeInt(arr.length);
                    for (int b : arr) {
                        stream.writeByte(b);
                    }
                    continue;
                }
                if (obj instanceof Boolean) {
                    stream.writeBoolean(Boolean.parseBoolean(obj.toString()));
                    continue;
                }
                if (obj instanceof BlockPosition) {
                    ((BlockPosition)obj).write(stream);
                    continue;
                }
                System.out.println("Unsupported object found: " + obj.toString());
            }
        }
        catch (Exception e) {
            return null;
        }
        return byteStream.toByteArray();
    }

    public static void sendPacketToAllAround(TileEntity tileEntity, Packet packet) {
        PacketDispatcher.sendPacketToAllAround((double)((double)tileEntity.field_70329_l + 0.5), (double)((double)tileEntity.field_70330_m + 0.5), (double)((double)tileEntity.field_70327_n + 0.5), (double)128.0, (int)tileEntity.field_70331_k.field_73011_w.field_76574_g, (Packet)packet);
    }
}

