/*
 * Decompiled with CFR 0.152.
 */
package enhancedcore.world;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;

public class BlockPosition {
    protected int x;
    protected int y;
    protected int z;

    public static BlockPosition getBlockPosition(DataInputStream stream) {
        try {
            return new BlockPosition(stream.readInt(), stream.readInt(), stream.readInt());
        }
        catch (Exception e) {
            return null;
        }
    }

    public BlockPosition(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockPosition above() {
        return new BlockPosition(this.x, this.y + 1, this.z);
    }

    public BlockPosition below() {
        return new BlockPosition(this.x, this.y - 1, this.z);
    }

    public BlockPosition east() {
        return new BlockPosition(this.x + 1, this.y, this.z);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockPosition)) {
            return false;
        }
        BlockPosition pos = (BlockPosition)obj;
        return this.x == pos.x && this.y == pos.y && this.z == pos.z;
    }

    public double getDistanceFrom(BlockPosition pos) {
        return this.getDistanceFrom(pos.x, pos.y, pos.z);
    }

    public double getDistanceFrom(int x, int y, int z) {
        int distX = this.x - x;
        int distY = this.y - y;
        int distZ = this.z - z;
        return Math.sqrt(distX * distX + distY * distY + distZ * distZ);
    }

    public BlockPosition getOffset(ForgeDirection direction) {
        return this.getOffset(direction, 1);
    }

    public BlockPosition getOffset(ForgeDirection direction, int count) {
        return new BlockPosition(this.x + direction.offsetX * count, this.y + direction.offsetY * count, this.z + direction.offsetZ * count);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public BlockPosition north() {
        return new BlockPosition(this.x, this.y, this.z - 1);
    }

    public BlockPosition south() {
        return new BlockPosition(this.x, this.y, this.z + 1);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public BlockPosition west() {
        return new BlockPosition(this.x - 1, this.y, this.z);
    }

    public void write(DataOutputStream stream) throws IOException {
        stream.writeInt(this.x);
        stream.writeInt(this.y);
        stream.writeInt(this.z);
    }
}

