/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.plugins;

import cpw.mods.fml.common.Loader;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import mods.natura.Natura;
import mods.natura.plugins.ICompatPlugin;
import mods.natura.plugins.fmp.ForgeMultiPart;
import mods.natura.plugins.minefactoryreloaded.MineFactoryReloaded;
import mods.natura.plugins.nei.NotEnoughItems;
import net.minecraftforge.common.Configuration;

public class PluginController {
    private static PluginController instance;
    private Configuration conf = null;
    private List<ICompatPlugin> plugins = new LinkedList<ICompatPlugin>();
    private Phase currPhase = Phase.PRELAUNCH;

    private PluginController() {
        String path = Loader.instance().getConfigDir().toString() + File.separator + "NaturaCompat.cfg";
        Natura.logger.info("[PluginController] Using config path: " + path);
        this.conf = new Configuration(new File(path));
    }

    public static PluginController getController() {
        if (instance == null) {
            instance = new PluginController();
        }
        return instance;
    }

    public void registerPlugin(ICompatPlugin plugin) {
        this.conf.load();
        boolean shouldLoad = this.conf.get("Plugins", plugin.getModId(), true).getBoolean(true);
        this.conf.save();
        if (shouldLoad) {
            this.loadPlugin(plugin);
        }
    }

    private void loadPlugin(ICompatPlugin plugin) {
        if (!Loader.isModLoaded((String)plugin.getModId())) {
            return;
        }
        Natura.logger.info("[PluginController] Registering compat plugin for " + plugin.getModId());
        this.plugins.add(plugin);
        switch (this.currPhase) {
            case DONE: 
            case POSTINIT: {
                plugin.preInit();
                plugin.init();
                plugin.postInit();
                break;
            }
            case INIT: {
                plugin.preInit();
                plugin.init();
                break;
            }
            case PREINIT: {
                plugin.preInit();
                break;
            }
        }
    }

    public void preInit() {
        this.currPhase = Phase.PREINIT;
        for (ICompatPlugin pl : this.plugins) {
            pl.preInit();
        }
    }

    public void init() {
        this.currPhase = Phase.INIT;
        for (ICompatPlugin pl : this.plugins) {
            pl.init();
        }
    }

    public void postInit() {
        this.currPhase = Phase.POSTINIT;
        for (ICompatPlugin pl : this.plugins) {
            pl.postInit();
        }
        this.currPhase = Phase.DONE;
    }

    public void registerBuiltins() {
        this.registerPlugin(new ForgeMultiPart());
        this.registerPlugin(new MineFactoryReloaded());
        this.registerPlugin(new NotEnoughItems());
    }

    private static enum Phase {
        PRELAUNCH,
        PREINIT,
        INIT,
        POSTINIT,
        DONE;

    }
}

